'*********************************************************
'! File       : CALC.BAS
'! Vers.      : 1.0
'! Last Edit  :  7.5.92
'! Autor      : G. Born
'! Files      : INPUT, OUTPUT
'! Progr. Spr.: POWER Basic
'! Betr. Sys. : DOS 2.1 - 5.0
'! Funktion: Das Programm simuliert einen Hex-Dez-Bin-Rechner.
'!           Die Eingaben werden bernommen, decodiert und das
'!           Ergebnis wird im Bildschirmspeicher jeweil normal
'!           und invertiert als Dezimal-, Hexadezimal- und
'!           Binrzahl angezeigt. Zustzlich werden ASCII -
'!           Darstellung und Eingabe eingeblendet.
'**********************************************************
'! Variable definieren
'! globale Konstanten
 %true = -1: %false = 0
 %hex = 1: %bin = 2: %dec = 3          '! code fr Zahlenbasis
 %add = 1: %sub = 2: %mul = 3: %div = 4'! code fr Operationen
'! globale Variablen
 %maxentry = 10
 DIM wertx%(1:%maxentry)               '! Speicher fr 10 Parameter
 DIM opc%(1:%maxentry)                 '!     "     "  10 Operatoren
 wert% = 0                             '! Ergebnis
 count% = 0                            '! Zahl der Parameter
 errx% = 0                             '! Fehlernummer
 errptr% = 0                           '! ptr auf Fehler im Text

'! definiere die Koordinaten der Ein- / Ausgabefelder
 %y1 = 8: %y2 = 10: %y3 = 12: %y4 = 14 '! y Koordinaten
 %y5 = 19
 %x1 = 12: %x2 = 42: %x3 = 28: %x4 = 15 '! x Koordinaten
 %tx1 = 12: %ty1 = 2                   '! Textkoordinaten
 %tx2 = 17: %tx3 =45: %ty2 = 5
 %tx4 = 5: %tx5 = 18

 lang% = 0                             '! Lnge Eingabetext
 text$ = ""                            '! Eingabetext
 DIM errtxt$(1:4)                      '! Fehlertexte
 errtxt$(1) = "ungltige Ziffer"
 errtxt$(2) = "----------------"
 errtxt$(3) = "ungltiger Operator"
 errtxt$(4) = "ungltige Zahlenbasis"

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

ON ERROR GOTO fehler1

CALL kopf                         '! Bildschirmmaske ausgeben
WHILE %true                       '! Endloschleife
 errx% = 0                        '! clear Fehlervariable
 LOCATE %y5,%x4,1                 '! Auf Eingabefeld
 INPUT "";text$                   '! Eingabe lesen und decod.

 '!  Test auf EXIT-Befehl
 IF (INSTR(UCASE$(text$),"EXIT") <> 0) THEN
  END
 END IF

 LOCATE %y5,%x4,1
 PRINT SPACE$(30)                 '! clear Eingabefeld
 lang% = LEN(text$)               '! Stringlnge
 CALL decode (text$)              '! Eingabe decodieren
 IF errx% = 0 THEN
  CALL display (wert%)            '! Ergebnis ausgeben
 ELSE
  CALL fehler (errx%)             '! Fehlermeldung ausgeben
 END IF
 wert% = 0
 FOR a% = 1 to %maxentry          '! clear results
  wertx%(a%) = 0
 NEXT a%
WEND
END

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

SUB kopf
'!---------------------------------------------------------
'! Ausgabe des statischen Maskenteils auf dem Bildschirm
'!---------------------------------------------------------

 CLS
 LOCATE %ty1,%tx1,0                 '! setze Kursor
 PRINT "D E Z   -   H E X   -    B I N   -   R e c h n e r"
 LOCATE %ty2,%tx2,1
 PRINT "Ergebnis";
 LOCATE %ty2,%tx3,0
 PRINT "invertiert";

 LOCATE %y1-1,%x4-4,0
 PRINT "Ŀ";       '! zeichne Rahmen
 PRINT SPACE$(10);
 PRINT "Ŀ";

 LOCATE %y1,%tx4,0
 PRINT "DEZ.  ";SPACE$(18);"";
 PRINT SPACE$(10);"";SPACE$(18);"";

 LOCATE %y2-1,%x4-4,0
 PRINT "Ĵ";
 PRINT SPACE$(10);
 PRINT "Ĵ";

 LOCATE %y2,%tx4,0
 PRINT "HEX.  ";SPACE$(18);"";
 PRINT SPACE$(10);"";SPACE$(18);"";

 LOCATE %y3-1,%x4-4,0
 PRINT "Ĵ";
 PRINT SPACE$(10);
 PRINT "Ĵ";

 LOCATE %y3,%tx4,0
 PRINT "BIN.  ";SPACE$(18);"";
 PRINT SPACE$(10);"";SPACE$(18);"";

 LOCATE %y4-1,%x4-4,0
 PRINT "";
 PRINT SPACE$(10);
 PRINT "";

 LOCATE %y4,%tx4,0
 PRINT "ASCII";
 LOCATE %y5,%tx4,0
 PRINT "Eingabe :";
 LOCATE %y5-2,%tx4,0
 PRINT "Die Eingabe: EXIT beendet das Programm";
 LOCATE %y4,%tx5,0
 PRINT "Eingabe :";

END SUB


SUB decode (text$)

'!---------------------------------------------------------
'! bearbeite Eingabe und berechne Ergebnis
'!---------------------------------------------------------
LOCAL ptr%, l%, flag%

SHARED lang%, count%, errx%, wert%
SHARED wertx%(), opc%()

 ptr% = 1: errx% = 0: count% = 1     '! init locale variable
 WHILE ptr% <= lang%                 '! scan String
  CALL getval (ptr%,wertx%(count%))  '! ermittle 1. Parameter
  IF errx% > 0 THEN EXIT SUB         '! Error Exit
  IF wertx%(count%) = 0 THEN GOTO ready '! WHILE EXIT
  CALL getop (ptr%,opc%(count%))     '! ermittle 1. Operator
  IF errx% > 0 THEN EXIT SUB         '! Error Exit
  INCR ptr%                          '! hinter Operator
  INCR count%                        '! nchste Zelle
 WEND

 DECR count%                         '! Zahl der Werte

ready:
'! nur 1 Parameter gefunden, oder Leereingabe ?
 IF count% < 2 THEN
  wert% = wertx%(1)
  EXIT SUB
 END IF

'! Punktrechnung "*"  "/" vorziehen !!!
 FOR l% = 1 TO count%-1
  IF opc%(l%) = %mul THEN
   wertx%(l%+1) = wertx%(l%) * wertx%(l%+1)
  ELSE
   IF opc%(l%) = %div THEN
    wertx%(l%+1) = INT(wertx%(l%) / wertx%(l%+1))
   END IF
  END IF
 NEXT l%

'! Strichrechnung "+"  "-" nachziehen !!!
 FOR l% = 1 TO count%-1
  WHILE (opc%(l%) = %mul) OR (opc%(l%) = %div) '! skip A * B  + ...
   INCR l%
  WEND
  j% = l%+1: flag% = %false              '! clear gefunden
  WHILE (opc%(j%) = %mul) OR (opc%(j%) = %div) '! skip A + B * C ...
   INCR j% : flag% = %true               '! setze gefunden
  WEND

  IF opc%(l%) = %add THEN
   wertx%(j%) = wertx%(l%) + wertx%(j%)
  ELSE
   IF opc%(l%) = %sub THEN
    wertx%(j%) = wertx%(l%) - wertx%(j%)
   END IF
  END IF
  IF flag% THEN l% = j%-1
 NEXT l%

' FOR n% = 1 TO count%
'  PRINT "n= ";n%;" wert ";wertx%(n%);" opc "; opc%(n%)
' NEXT n%

 wert% = wertx%(count%)                 '! Endergebnis

END SUB

SUB getval (ptr%, wert%)

'!---------------------------------------------------------
'! lese eine Zahl ein und decodiere sie
'!---------------------------------------------------------

SHARED text$, errx%, count%, lang%, vorz%
LOCAL tmp%, zchn$, basis%, first%, last%

 vorz% = 1 : tmp% = 0                '! init Hilfsvariablen

'! suche Anfang und Ende der Zahl
 CALL skipblank  (ptr%,text$)        '! skip fhrende blanks

'! Vorzeichen bearbeiten
 zchn$ = MID$ (text$,ptr%,1)         '! hole Zeichen

 IF (zchn$ = "-") THEN
  vorz% = -1                         '! negative Zahl
  INCR ptr%
 ELSE
  IF (zchn$ = "+") THEN              '! Vorz. berlesen
   INCR ptr%
  END IF
 END IF
 zchn$ = MID$ (text$,ptr%,1)         '! hole Zeichen
 first% = ptr%                       '! merke Anfang Zahl

'! suche Ende der Zahl = " ";"+";"-";"*";"/"
 WHILE (INSTR(" +-*/",zchn$) = 0) _
               AND ptr% <= lang%
  INCR ptr%                          '! hole nchstes Zeichen
  zchn$ = MID$ (text$,ptr%,1)        '! hole Zeichen
 WEND
'! merke Ende der Zahl
 IF ptr% < lang% THEN
  last% = ptr% - 1                   '! auf letzte Ziffer
 ELSE
  last% = lang%                      '! auf Textende
 END IF

'! decodiere Zahlenbasis
 zchn$ = UCASE$(MID$ (text$,last%,1))'! hole Zeichen
 CALL basex (basis%,zchn$,last%)     '! decodiere Basis
 IF errx% > 0 THEN EXIT SUB          '! error exit

 SELECT CASE basis%                  '! decodiere Zahl

 CASE %hex
  CALL hex1 (first%,last%,wert%)     '! Hexzahl

 CASE %bin
  CALL bin1 (first%,last%,wert%)     '! Binrzahl

 CASE %dec
  CALL dec1 (first%,last%,wert%)     '! Dezimalzahl

 END SELECT

END SUB

SUB getop (ptr%,opcode%)

'!---------------------------------------------------------
'! ermittle operator (+ - * / )
'!---------------------------------------------------------

SHARED errx%, errptr%, text$, lang%
LOCAL  zchn$, tmp%

 CALL skipblank (ptr%,text$)         '! berlese blanks

 IF ptr% >= lang% THEN
  opcode% = 0                        '! nichts gefunden
  EXIT SUB
 END IF

 zchn$ = MID$(text$,ptr%,1)          '! hole Zeichen
 tmp% = INSTR ("+-*/",zchn$)         '! decodiere Operator

 SELECT CASE tmp%                    '! Zuweisung Opcode

 CASE 1
  opcode% = %add                     '! Addition

 CASE 2
  opcode% = %sub                     '! Subtraktion

 CASE 3
  opcode% = %mul                     '! Multiplikation

 CASE 4
  opcode% = %div                     '! Division

 CASE ELSE
  errx% = 3                          '! ungltiger Operator
  errptr% = ptr%                     '! Zeiger setzen
  opcode% = 0

 END SELECT

END SUB

SUB display (wert%)

'!---------------------------------------------------------
'! Ausgabe des Ergebnisses auf dem Bildschirm
'!---------------------------------------------------------
LOCAL nwert%, res$
SHARED text$

 nwert% = (NOT wert%)              '! Complement
'! Ausgabe der Werte in DEZ HEX BIN
 LOCATE %y1,%x1+12,0
 PRINT USING "######"; wert%       '! Dezimalzahl
 LOCATE %y1,%x2+12,0
 PRINT USING "######"; nwert%;     '! Einerkomplement
 LOCATE %y2,%x1+14,0
 res$ = HEX$(wert%)                '! Hexausgabe mit
 PRINT STRING$(4-LEN(res$),"0");res$  '! fhrend. Nullen
 LOCATE %y2,%x2+14,0
 res$ = HEX$(nwert%)               '! Hexausgabe
 PRINT STRING$(4-LEN(res$),"0");res$
 LOCATE %y3,%x1+1,0
 res$ = BIN$(wert%)                '! Binrausgabe mit
 res$ = STRING$(16-LEN(res$),"0") + res$ '! fhr. Nullen
 PRINT MID$(res$,1,8);":";MID$(res$,9)
 LOCATE %y3,%x2+1,1
 res$ = BIN$(nwert%)               '! Binrausgabe mit
 res$ = STRING$(16-LEN(res$),"0") + res$ '! fhr. Nullen
 PRINT MID$(res$,1,8);":";MID$(res$,9)
 LOCATE %y4,%x1,1
 PRINT " "
 IF (wert% >= &H20) AND (wert% < 256) THEN
  LOCATE %y4,%x1,1
  PRINT CHR$(wert% MOD 256);       '! ASCII Wert
 ELSE
  LOCATE %y4,%x1,1
  PRINT " "                        '! ASCII Feld
 END IF
 LOCATE %y4,%x3,1
 PRINT text$;
 PRINT SPACE$(30-LEN(text$));      '! clear Restfeld

END SUB


SUB skipblank(ptr%,text$)
'---------------------------------------------------------
'! zhle fhrende Blanks in einer Zeichenkette
'! text$ = Zeichenkette, zeiger% = Zeiger in Kette
'---------------------------------------------------------
SHARED lang%

WHILE (ptr% =< lang%) and (MID$(text$,ptr%,1) = " ")
 INCR ptr%
WEND
END SUB

SUB basex (basis%, zchn$, last%)

'!---------------------------------------------------------
'! decodieren der Zahlenbasis
'! "H" basis = 1, "B" basis = 2, "T" basis = 3
'!---------------------------------------------------------

LOCAL tmp%
SHARED text$, errx%, errptr%

 DECR last%                        '! Zeiger auf letzte Ziffer
 tmp% = INSTR("HBT",zchn$)         '! decodiere Zeichen

 SELECT CASE tmp%

 CASE 1
  basis% = %hex                    '! Hexzahl

 CASE 2
  basis% = %bin                    '! Binrzahl

 CASE 3
  basis% = %dec                    '! Dezimalzahl

 CASE ELSE

  IF (zchn$ >= "0") AND (zchn$ =< "9") THEN  '! Ziffer = 0 .. 9
   INCR last%
   basis% = %dec                   '! Dezimalzahl
  ELSE
   errx% = 4                       '! 1 Fehler
   errptr% = last%                 '! Fehler Exit
  END IF

 END SELECT

END SUB


SUB hex1 (first%,last%,wert%)

'!---------------------------------------------------------
'! decodieren der Hexzahl
'!---------------------------------------------------------

SHARED text$, vorz%, errx%, errptr%
LOCAL tmp%, b%

 wert% = 0                         '! init

 FOR b% = first% TO last%          '! alle Ziffern
  zchn$ = UCASE$(MID$(text$,b%,1)) '! hole Ziffer

  tmp% = INSTR("0123456789ABCDEF",zchn$) '! decodiere Ziffer

  IF tmp% = 0 THEN                 '! Wert gefunden ?
   errx% = 1: errptr% = b%         '! Nein -> Fehler
   EXIT SUB
  END IF
'!
'! Achtung: Power Basic kann bei I*2 keine Zahlen grer
'! 7FFFH verarbeiten (8000H fhrt zu Overflow). Deshalb
'! wird das oberste Bit bei Zahlen > 8000H gelscht und
'! zum Abschlu wieder gesetzt (sorry).
'!

  IF (b% = 4) AND wert% > &H7FF THEN '! Teste auf Overflow
    wert% = wert% AND &H7FF        '! clear oberes Bit
    wert% = wert% * 16 + (tmp% - 1)'! Ziffer auf Zahl addieren
    wert% = wert% OR &H8000        '! setze oberes Bit
  ELSE
   wert% = wert% * 16 + (tmp% - 1) '! Ziffer auf Zahl addieren
  END IF
  wert% = wert% * vorz%

 NEXT b%

END SUB


SUB bin1 (first%,last%,wert%)

'!---------------------------------------------------------
'! decodieren der Binrzahl
'!---------------------------------------------------------

SHARED text$, vorz%, errx%, errptr%
LOCAL tmp%, b%

 wert% = 0                        '! init
 FOR b% = first% TO last%         '! alle Ziffern
  zchn$ = MID$(text$,b%,1)        '! lese Ziffer

'! gltige Ziffer ????
  IF zchn$ < "0" OR zchn$ > "1" THEN
   errx% = 1                      '! Fehlerausgang
   errptr% = b%
  ELSE
   tmp%  = VAL(zchn$)             '! Wert der Ziffer
   wert% = wert% * 2 + tmp% * vorz% '! Ziffer auf Zahl addieren
  END IF
 NEXT b%

END SUB


SUB dec1 (first%,last%,wert%)

'!---------------------------------------------------------
'! decodieren der Dezimalzahl
'!---------------------------------------------------------

SHARED text$, vorz%, errx%, errptr%
LOCAL tmp%, b%

 wert% = 0                        '! init

 FOR b% = first% TO last%         '! alle Ziffern
  zchn$ = MID$(text$,b%,1)        '! hole Ziffer
  '! Achtung VAL funktioniert nicht, da 0 bei Fehler geliefert wird
  tmp% = INSTR ("0123456789",zchn$) '! Wert der Ziffer
  tmp% = tmp% - 1
'! gltige Ziffer ????
  IF tmp% < 0 THEN
   errx% = 1                      '! Fehlerexit
   errptr% = b%
  ELSE
   wert% = wert% * 10 + (tmp% * vorz%) '! Ziffer auf Zahl addieren
  END IF
 NEXT b%

END SUB

fehler1:
'!---------------------------------------------------------
'! Abfangroutine fr Power Basic Fehler
'!---------------------------------------------------------

IF ERR = 6 THEN
 LOCATE %y4, %x3,0
 PRINT "Overflow Error";                '! Fehlermeldung
ELSE
 PRINT "Fehler : ";ERR;
END IF

END
RETURN


SUB fehler (fehlernr%)

'!---------------------------------------------------------
'! Fehlerausgabe auf dem Bildschirm
'!---------------------------------------------------------
SHARED text$, errtxt$()

 LOCATE %y4,%x3,0
 PRINT text$;                        '! display Eingabe
 PRINT SPACE$(30-LEN(text$));        '! lsche Restfeld
 LOCATE (%y4+1%),(%x3+2+errptr%),0
 PRINT "^";                          '! Fehlerstelle markieren
 LOCATE %y5,%x4,1
 PRINT errtxt$(fehlernr%);           '! Fehlermeldung ausgeben

 INPUT ", bitte die Return Taste bettigen ", text$
 LOCATE %y5,%x4,0
 PRINT SPACE$(60)                    '! clear Meldung
 LOCATE (%y4+1),(%x3+2+errptr%)
 PRINT " "                           '! Clear ^

END SUB

'**** Programm Ende ****
