'*********************************************************
'! File       : CRDEL.BAS
'! Vers.      : 1.0
'! Last Edit  : 6. 5.92
'! Autor      : G. Born
'! Files      : INPUT, OUTPUT
'! Progr. Spr.: POWER Basic
'! Betr. Sys. : DOS 2.1 - 5.0
'! Funktion: Das Programm liest eine Textdatei ein und filtert
'!           auf Benutzeranweisung die "harten RETURN" Zeichen
'!           am Zeilenende aus der Datei. Damit kann diese mit
'!           Textverarbeitungsprogrammen wie Word bearbeitet
'!           werden.
'!
'! Aufruf:   CRDEL                     '! Interaktiv Mode
'!           CRDEL <datei1> <datei2>   '! Kommando Mode
'**********************************************************
'! Variable definieren
%max = 15                              '! Konstante
ein% = 1 : aus% = 2                    '! Kanle fr I/O
DIM inlinie$(0:%max-1)                 '! Puffer Lesedatei
zeile% = 0
ptr% = 0: hilf% = 0                    '! Hilfszeiger
y% = 0                                 '! Kursor

ON ERROR GOTO fehler

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$ + " "             '! Parameter ?
IF LEN (kommando$) <= 1 THEN           '! Interaktiv Mode ?
 CLS                                   '! ja -> Clear Screen
'! #####   Kopf ausgeben  ######
 PRINT "C R D E L                        (c) Born Version 1.0"
 PRINT
 PRINT "lschen -> J eingeben, sonst eine beliebige Taste bettigen"
 PRINT
 INPUT "Eingabedatei : ",infilename$   '! lese Dateiname Eingabe
 INPUT "Ausgabedatei : ",outfilename$  '! lese Dateiname Ausgabe
 PRINT
ELSE                                   '! Kommando Mode
 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "C R D E L                        (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: CRDEL"
  PRINT " oder   CRDEL <Quellfile> <Zielfile>"
  PRINT
  PRINT "Das Programm filtert die harten Returns aus einer Textdatei."
  PRINT "Lschen -> J eingeben, sonst eine beliebige Taste bettigen"
  PRINT
  SYSTEM
 END IF
'!
'! getfile separiert den Dateinamen aus der Kommandozeile
'! Falls ein Name fehlt, wrden die Optionen in die jeweilige
'! Variable gespeichert. Dies ist abgefangen, da Optionen mit
'! /.. beginnen. Dann wird ein Leerstring zurckgegeben
'!
 ptr% = 1                              '! Parameter holen
 CALL getfile(ptr%, kommando$,infilename$) '! Name Eingabedatei
 INCR ptr%                                 '! Anfang next token
 CALL getfile(ptr%, kommando$,outfilename$)'! Name Ausgabedatei
END IF

IF infilename$ = "" THEN               '! Leereingabe ?
 PRINT "Der Name der Eingabedatei fehlt"
 END
END IF

IF outfilename$ = "" THEN              '! Leereingabe ?
 PRINT "Der Name der Ausgabedatei fehlt"
 END
END IF

IF outfilename$ = infilename$ THEN     '! Namen gleich ?
 PRINT "Eingabedetei = Ausgabedatei nicht erlaubt"
 END
END IF

OPEN infilename$ FOR INPUT AS #ein%   '! ffne Eingabedatei
'! Ausgabedatei vorhanden -> prfe ber OPEN inputdatei

ON ERROR GOTO ok
OPEN outfilename$ FOR INPUT AS #aus%   '! existiert Ausgabedatei%
ON ERROR GOTO fehler
CLOSE #aus%                            '! nein -> Close

INPUT "Ausgabedatei existiert bereits, berschreiben (J/N) ? ",zchn$
PRINT
IF UCASE$(zchn$) <> "J" THEN END       '! stopp -> sonst Datei weg

ok:
OPEN outfilename$ FOR OUTPUT AS #aus%  '! Ausgabedatei open

CLS                                    '! Clear Screen
PRINT                                  '! Leerzeile
'!
'! lese die ersten n Stze aus der Datei un den Puffer und
'! zeige sie an
'!

FOR i% = 0 TO %max-2
 LINE INPUT #ein%, inlinie$(i%)       '! lese eine Zeile
 PRINT inlinie$(i%)                   '! Anzeige auf Screen
 IF EOF(ein%) THEN GOTO weiter
 zeile% = i%
NEXT i%

weiter:
'!
'! Lese weitere Stze aus der Datei und bearbeite den
'! Puffer, zeige gelesene Stze an.
'!

INCR zeile%
WHILE (NOT (EOF(ein%)))
 lang% = LEN (inlinie$(hilf%))        '! Lnge Satz ermitteln

 y% = csrlin - 1                      '! merke Zeile Cursor

 LOCATE 2,lang%+2                     '! Marke an akt.
 PRINT "";                          '! Zeile setzen
 zchn$ = INPUT$ (1)                   '! lese Taste
 LOCATE 2,lang%+2                     '! clear Marke
 PRINT "  ";                          '!  "

 IF UCASE$(zchn$) = "J" THEN
  IF lang% > 0 THEN
   IF RIGHT$(inlinie$(hilf%),1) = "-" THEN   '! Ende = "-" ?
    IF MID$(inlinie$(hilf%),lang%-1,1)_      '! Ende = " -" ?
              <> " "  THEN                   '! END = " -"?
     PRINT #aus%, LEFT$(inlinie$(hilf%),_    '! entferne "-"
                  lang% - 1);
    ELSE
     PRINT #aus%, inlinie$(hilf%);" ";  '! volle Zeile
    END IF
   ELSE
    PRINT #aus%, inlinie$(hilf%);" ";   '! volle Zeile
   END IF
  END IF
 ELSE
  PRINT #aus%, inlinie$(hilf%)        '! mit RETURN ausgeben
 END IF

 LINE INPUT #ein%, inlinie$(zeile%)   '! lese neue Zeile

 LOCATE 25,1                          '! Kursor an unteres Bild
 PRINT                                '! -> Scroll
 LOCATE y% ,1                         '! restore Kursor
 PRINT inlinie$(zeile%)               '! Anzeige auf Screen
 zeile% = (zeile% + 1) MOD %max       '! Adresse berechnen
 hilf% = (hilf% + 1) MOD %max         '!  "

WEND
'!
'! bearbeite restlichen Puffer
'!

rest% = %max - hilf% + zeile% - 2
FOR i% = 0 TO rest%
 lang% = LEN (inlinie$(hilf%))        '! Lnge Satz ermitteln

 y% = csrlin - 1                      '! merke Zeile Cursor

 LOCATE 2,lang%+2                     '! Marke an akt.
 PRINT "";                          '! Zeile setzen
 zchn$ = INPUT$ (1)                   '! lese Taste
 LOCATE 2,lang%+2                     '! clear Marke
 PRINT "  ";                          '!  "

 IF UCASE$(zchn$) = "J" THEN
  IF lang% > 0 THEN
   IF RIGHT$(inlinie$(hilf%),1) = "-" THEN   '! Ende = "-" ?
    IF MID$(inlinie$(hilf%),lang%-1,1) _     '! END = " -"?
           <> " " THEN
     PRINT #aus%, LEFT$(inlinie$(hilf%),_    '! entferne "-"
                  lang%-1);
    ELSE
     PRINT #aus%, inlinie$(hilf%);" ";  '! volle Zeile
    END IF
   ELSE
    PRINT #aus%, inlinie$(hilf%);" ";   '! volle Zeile
   END IF
  END IF
 ELSE
  PRINT #aus%, inlinie$(hilf%)        '! mit RETURN ausgeben
 END IF

 LOCATE 25,1                          '! Kursor an unteres Bild
 PRINT                                '! -> Scroll
 LOCATE y% ,1                         '! restore Kursor
 PRINT                                '! Leerzeile
 hilf% = (hilf% + 1) MOD %max         '! Zeiger erhhen
NEXT i%

CLOSE
PRINT
PRINT "CRDEL Ende"
END

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in CRDEL
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";infilename$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
END                                 '! MSDOS Exit
RETURN


SUB getfile(ptr%,text$,result$)
'!---------------------------------------------------------
'! separiere Filename aus Eingabetext (text$)
'! ptr% -> Anfang Filename, result$ = Filename
'!---------------------------------------------------------
LOCAL tmp%

CALL skipblank (ptr%,text$)            '! entferne Blanks
tmp% = INSTR(ptr%,text$," ")           '! suche Separator
IF tmp% = 0 THEN
 PRINT "Fehler: kein Fileseparator"    '! kein Endeseparator
 END                                   '! Exit
END IF
IF MID$(text$,ptr%,1) = "/" THEN       '! Optionen eingegeben ?
 result$ = ""                          '! Leerstring
ELSE
 result$ = MID$(text$,ptr%,tmp%-ptr%)  '! Filename
 ptr% = tmp%                           '! korrigiere ptr%
END IF

END SUB

SUB skipblank(ptr%,text$)
'!---------------------------------------------------------
'! entferne fhrende Leerzeichen aus text$
'!---------------------------------------------------------

LOCAL lang%, zchn$

lang% = LEN (text$)                    '! Stringlnge
zchn$ = MID$(text$,ptr%,1)             '! separiere Zeichen

WHILE (zchn$ = " ") AND (ptr% <= lang%) '! Zeichen <> blank
 INCR ptr%
 zchn$ = MID$(text$,ptr%,1)            '! separiere Zeichen
WEND

END SUB

'***** Programm Ende ******
