'*********************************************************
'! File       : CUT.BAS
'! Vers.      : 1.0
'! Last Edit  : 6. 5.92
'! Autor      : G. Born
'! Files      : INPUT, OUTPUT
'! Progr. Spr.: POWER Basic
'! Betr. Sys. : DOS 2.1 - 5.0
'! Funktion: Das Programm liest eine Textdatei ein und filtert
'!           bestimmte Textspalten aus. Das Ergebnis wird in
'!           einer zweiten Datei abgelegt. Es sind folgende
'!           Optionen mglich:
'!
'!           /F=x1    entferne Feld x1
'!
'!           In diesem Fall mu ein Feldseparator mit
'!
'!           /D=x     x = Trennzeichen
'!
'!           eingegeben werden. Weiterhin knnen einzelne Spalten
'!           mit
'!
'!           /C=x1-x2  x1 = Anfangsspalte  x2 = Endspalte
'!
'!           entfernt werden. Es ist jeweils nur die /F oder
'!           /C Option zulssig. Die Option:
'!
'!           /S=xx
'!
'!           erlaubt am Anfang der Textdatei n Zeilen zu berlesen,
'!           whrend bei der
'!
'!           /P=xx
'!
'!           Option nur n Zeilen bearbeitet werden.
'!
'! Aufruf:   CUT                                '! Interaktiv Mode
'!           CUT <datei1> <datei2> <Optionen>   '! Kommando Mode
'**********************************************************
'! Variable definieren
%true = &HFFFF: %false = 0            '! Konstante
trace% = %false                       '! No Trace Mode
ein% = 1 : aus% = 2                   '! Kanle fr I/O
col1% = 1                             '! Anfangsspalte
col2% = 255                           '! Endspalte
feld% = 0                             '! Feldnr. fr Option /F
colopt% = %true                       '! Column Option einstellen
options$ = ""                         '! Optionen
inlinie$ = ""                         '! Puffer Lesedatei
outlinie$ = ""                        '! Puffer Schreibdatei
skip% = 0                             '! Zeilen berlesen
work& = 100000                        '! Zeilen zu bearbeiten
zeile& = 0                            '! bearbeitete Zeilen
ptr% = 0: hilf% = 0                   '! Hilfszeiger
tmp$ = ""                             '! Hilfsstring
sep$ = ""                             '! Delimiter Feld

ON ERROR GOTO fehler

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! Interaktiv Mode ?
 CLS                                  '! ja -> Clear Screen
'! #####   Kopf ausgeben  ######
 PRINT "C U T                         (c) Born Version 1.0"
 PRINT
 PRINT "Optionen : [ /F=xx    Feld Nummer       /D=x  Delimiter       ]"
 PRINT "           [ /S=xx    Skip n Lines      /P=xx Prozess n Lines ]"
 PRINT "           [ /C=x1-x2 Column x1 bis x2  /T    Trace ON        ]"
 PRINT
 INPUT "Eingabedatei : ",infilename$  '! lese Dateiname Eingabe
 INPUT "Ausgabedatei : ",outfilename$ '! lese Dateiname Ausgabe
 INPUT "Optionen     : ",options$     '! lese Optionen
 PRINT
ELSE                                  '! Kommando Mode
 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "C U T                         (c) Born Version 1.0"
  PRINT
  PRINT "Optionen : [ /F=xx    Feld Nummer       /D=x  Delimiter       ]"
  PRINT "           [ /S=xx    Skip n Lines      /P=xx Process n Lines ]"
  PRINT "           [ /C=x1-x2 Column x1 bis x2  /T    Trace ON        ]"
  PRINT
  PRINT "Das Programm filtert bestimmte Textspalten aus einer"
  PRINT "Eingabedatei heraus. Optionen:"
  PRINT
  PRINT "/F=xx   filtert das durch Delimiter getrennte Feld Nr. xx heraus"
  PRINT "/D=x    gibt den Delimiter (z.B. , oder ;) fr die Felder an"
  PRINT "/C=x1-x2 schneidet die Spalten x1 bis x2 aus der Datei"
  PRINT "/S=xx   berliest n Zeilen, bevor der Filter aktiviert wird"
  PRINT "/P=xx   filtert nur n Zeilen und terminiert dann"
  PRINT "/T      gibt die bearbeitete Zeile und das Ergebnis am Bildschirm aus"
  PRINT
  SYSTEM
 END IF
'!
'! getfile separiert den Dateinamen aus der Kommandozeile
'! Falls ein Name fehlt, wrden die Optionen in die jeweilige
'! Variable gespeichert. Dies ist abgefangen, da Optionen mit
'! /.. beginnen. Dann wird ein Leerstring zurckgegeben
'!
 ptr% = 1                                  '! Parameter holen
 CALL getfile(ptr%, kommando$,infilename$) '! Name Eingabedatei
 INCR ptr%                                 '! Anfang next token
 CALL getfile(ptr%, kommando$,outfilename$)'! Name Ausgabedatei
 hilf% = INSTR(kommando$,"/")         '! suche Optionen
 IF hilf% >= ptr% THEN                '! gefunden ?
  options$ = MID$(kommando$,hilf%)    '! Reststring mit Optionen
 END IF
END IF

IF infilename$ = "" THEN              '! Leereingabe ?
 PRINT "Der Name der Eingabedatei fehlt"
 END
END IF

IF outfilename$ = "" THEN              '! Leereingabe ?
 PRINT "Der Name der Ausgabedatei fehlt"
 END
END IF


IF (LEN(options$) = 0) OR _            '! Optionen prfen ?
 (INSTR(options$,"/") = 0) THEN
 PRINT "Die Options fehlen oder sind falsch"
 END
END IF

OPEN infilename$ FOR INPUT AS #ein%  '! ffne Eingabedatei
'! Ausgabedatei vorhanden -> prfe ber OPEN inputdatei

ON ERROR GOTO ok
OPEN outfilename$ FOR INPUT AS #aus% '! existiert Ausgabedatei%
ON ERROR GOTO fehler
CLOSE #aus%                          '! nein -> Close

INPUT "Ausgabedatei existiert bereits, berschreiben (J/N) ? ", tmp$
PRINT
IF UCASE$(tmp$) <> "J" THEN END      '! stopp -> sonst Datei weg

ok:
OPEN outfilename$ FOR OUTPUT AS #aus% '! Ausgabedatei open

options$ = UCASE$(options$)           '! in Grobuchstaben
GOSUB getswitch                       '! lese Optionen

PRINT
PRINT "CUT Start "
PRINT

'!
'! berlese fhrende Zeilen falls skip line gesetzt
'!

WHILE (skip% > 0) AND (NOT (EOF(ein%)))
 DECR skip%                           '! skip% - 1
 LINE INPUT #ein%, inlinie$           '! lese eine Zeile
 PRINT #aus%, inlinie$                '! in Ausgabedatei
 IF trace% THEN                       '! Trace Mode ?
  PRINT inlinie$                      '! Anzeige Original
  PRINT inlinie$                      '! Anzeige Kopie
  PRINT
 END IF
WEND

'!
'! bearbeite n Zeilen
'!

WHILE (zeile& < work&) AND (NOT (EOF(ein%)))
 LINE INPUT #ein%, inlinie$           '! lese eine Zeile
 lang% = LEN (inlinie$)               '! Merke Zeilenlnge
 IF colopt% THEN
  CALL column (inlinie$, outlinie$)   '! auswerten Zeile
 ELSE
  CALL fieldx(inlinie$, outlinie$)    '!    "
 END IF
 PRINT #aus%, outlinie$               '! Zeile in Ausgabedatei
 IF trace% THEN                       '! Trace Mode ?
  PRINT inlinie$                      '! display Original
  PRINT outlinie$                     '! display Zeile
  PRINT
 END IF
 INCR zeile&                          '! Zeile + 1
WEND

'!
'! restliche Zeilen umcopieren
'!

WHILE NOT (EOF (ein%))
 LINE INPUT #ein%, inlinie$           '! lese eine Zeile
 PRINT #aus%, inlinie$                '! in Ausgabedatei
 IF trace% THEN                       '! Trace Mode ?
  PRINT inlinie$                      '! ja -> Anzeige
  PRINT inlinie$                      '! 2 x
  PRINT
 END IF
WEND

CLOSE
PRINT
PRINT "CUT Ende"
END

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in CUT
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";infilename$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
END                                 '! MSDOS Exit
RETURN

getswitch:
'--------------------------------------------------------
'! decodiere eingegebene Optionen
'! /F = field   /D = separator    /C = column
'! /S = skip    /P = process      /T = trace
'--------------------------------------------------------

 options$ = UCASE$(options$)

 IF INSTR(options$,"/T") > 0 THEN
  trace% = %true                       '! Trace Mode ein
 END IF

 ptr% = INSTR(options$,"/S=")          '! Skip Lines Option ?
 IF ptr% > 0 THEN
  CALL getval(options$,ptr%+3,skip%)   '! lese Zahl
 END IF

 ptr% = INSTR(options$,"/P=")          '! Process Lines Option ?
 IF ptr% > 0 THEN
  CALL getval(options$,ptr%+3,tmpx%)   '! lese Zahl
  work& = tmpx%
 END IF
 ptr% = INSTR(options$,"/F=")          '! Field Option ?
 IF ptr% > 0 THEN
  CALL getval(options$,ptr%+3,feld%)   '! lese Zahl
  IF feld% <= 0 THEN                   '! falsche Nummer
   PRINT "Feld Nummer ";feld%;" nicht zulssig"
   END
  END IF
  ptr% = INSTR(options$,"/D=")          '! check Delimiter
  IF ptr% = 0 THEN
   PRINT "Option /D fehlt"
   END
  END IF
  sep$ = MID$(options$,ptr%+3,1)       '! get Separator
  colopt% = %false                     '! select Field Option
  RETURN
 END IF
 ptr% = INSTR(options$,"/C=")          '! Column Option ?
 IF ptr% > 0 THEN
'! es sind folgende Eingaben erlaubt:
'! /C10-20   /C-20      /C10-
  INCR ptr%,3                          '! auf 1. Zeichen
  CALL getval (options$,ptr%,tmpx%)    '! lese 1. Wert
   IF tmpx% < 0 THEN                   '! negativer Wert ?
    col2% = -tmpx%                     '! Endespalte
   ELSE
    col1% = tmpx%                      '! Startspalte
    IF MID$(options$,ptr%,1) = "-" THEN
     CALL getval (options$,ptr%,tmpx%) '! lese 2. Wert
     tmpx% = - tmpx%                    '! Vorzeichenwechsel
     IF tmpx% > col1% THEN              '! Endewert?
      col2% = tmpx%                     '! ja
     END IF
    END IF
  END IF
 ELSE
  PRINT "Fehler: Options /C oder /F fehlen"
  END
 END IF
RETURN

SUB getval(text$,ptr%,result%)
'--------------------------------------------------------
'! decodiere Eingabewert als Dezimalzahl
'--------------------------------------------------------
LOCAL tmp%, zchn$, leng%, sign%

sign% = 1                             '! Vorzeichen +
tmp% = 0                              '! Hilfsvariable

leng% = LEN(text$)

CALL skipblank(ptr%,text$)            '! berlese Leerzeichen
zchn$ = MID$(text$,ptr%,1)            '! separ. Zeichen
IF zchn$ = "-" THEN                   '! Vorzeichen ?
 sign% = -1                           '! Vorzeichen  -
 INCR ptr%                            '! auf 1. Ziffer
END IF

zchn$ = MID$(text$,ptr%,1)            '! separ. Zeichen

WHILE (zchn$ >= "0") AND (zchn$ <= "9")_
 AND (ptr% <= leng%)                  '! n Ziffern
 tmp% = tmp% * 10 + VAL(zchn$)        '! Ziffer holen
 INCR ptr%                            '! nchstes Zeichen
 zchn$ = MID$(text$,ptr%,1)           '! lese Zeichen
WEND
result% = tmp% * sign%                '! Vorzeichen

END SUB

SUB column(quelle$,ziel$)
'!---------------------------------------------------------
'! entferne alle Zeichen von Spalte (start) bis Spalte (ende)
'!---------------------------------------------------------

SHARED col1%, col2%

 IF col1% <= 0 THEN col1% = 1        '! negativer Wert
 ziel$ = LEFT$(quelle$,col1%-1)     '! Anfang merken
 ziel$ = ziel$ + MID$(quelle$,col2%+1)'! Rest anhngen

END SUB

SUB fieldx (quelle$,ziel$)
'!---------------------------------------------------------
'! entferne Feld Nr. n
'!---------------------------------------------------------
SHARED feld%, col1%, col2%, sep$
LOCAL ptr%, zahl%, anf%, ende%, lang%

lang% = LEN(quelle$)
ptr% = INSTR(quelle$,sep$)            '! suche separator

IF ptr% = 0 THEN                      '! nicht gefunden
 ziel$ = quelle$                      '! alles bernehmen
 PRINT "kein Separator"
 EXIT SUB
END IF

'! beachte, da ein Delimiter entfernt wird !!!

anf% = 1: ende% = ptr%                '! init Feldgrenzen
zahl% = 1                             '! Feldzhler

WHILE (zahl% < feld%) AND (ptr% > 0)
 anf% = ende% + 1                     '! hinter Delimiter
 ptr% = INSTR(ptr%+1,quelle$,sep$)    '! suche Feldende
'!
'!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
'! Achtung TB Fehler: Der Befehl INSTR() funktioniert
'! nicht immer, falls der Suchbegriff nicht vorkommt.
'! Deshalb mu ptr% = 0 und ptr% < Stringlnge abge-
'! fragt werden.
'!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
'!
 IF (ptr% = 0) OR (ptr% >= lang%) THEN '! letztes Feld ?
  ende% = LEN(quelle$)                '! ja -> auf Stringlnge
  DECR anf%                           '! auf Delimiter
  ptr% = 0                            '! Ende Schleife !
 ELSE
  ende% = ptr%                        '! nein -> auf Delimiter
 END IF
 INCR zahl%                           '! next Feld

WEND

IF (zahl% < feld%) THEN               '! Feld gefunden?
 ziel$ = quelle$                      '! Feld nicht gefunden
 PRINT "Feld Nr. ";feld%;" nicht gefunden"
 EXIT SUB
END IF

IF zahl% = feld% THEN                 '! Feld gefunden
 col1% = anf%                         '! Feldanfang
 col2% = ende%                        '! Feldende
 CALL column(quelle$,ziel$)           '! cut field with column
END IF

END SUB


SUB getfile(ptr%,text$,result$)
'!---------------------------------------------------------
'! separiere Filename aus Eingabetext (text$)
'! ptr% -> Anfang Filename, result$ = Filename
'!---------------------------------------------------------
LOCAL tmp%

CALL skipblank (ptr%,text$)            '! entferne Blanks
tmp% = INSTR(ptr%,text$," ")           '! suche Separator
IF tmp% = 0 THEN
 PRINT "Fehler: kein Fileseparator"    '! kein Endeseparator
 END                                   '! Exit
END IF
IF MID$(text$,ptr%,1) = "/" THEN       '! Optionen eingegeben ?
 result$ = ""                          '! Leerstring
ELSE
 result$ = MID$(text$,ptr%,tmp%-ptr%)  '! Filename
 ptr% = tmp%                           '! korrigiere ptr%
END IF

END SUB

SUB skipblank(ptr%,text$)
'!---------------------------------------------------------
'! entferne fhrende Leerzeichen aus text$
'!---------------------------------------------------------

LOCAL lang%, zchn$

lang% = LEN (text$)                    '! Stringlnge
zchn$ = MID$(text$,ptr%,1)             '! separiere Zeichen

WHILE (zchn$ = " ") AND (ptr% <= lang%) '! Zeichen <> blank
 INCR ptr%
 zchn$ = MID$(text$,ptr%,1)            '! separiere Zeichen
WEND

END SUB

'***** Programm Ende ******
