'*********************************************************
'! File       : DBDOC.BAS
'! Vers.      : 1.0
'! Last Edit  : 10.6.92
'! Autor      : G. Born
'! Files      : DBASE File
'! Progr. Spr.: Power Basic 4.0 / 4.5
'! Betr. Sys. : DOS 2.1 - 3.3
'! Funktion: Demonstration des Zugriffs auf DBASE III Daten-
'!           bankfiles aus Power Basic. Das Programm gibt den
'!           Inhalt einer DBASE III Datei auf dem Screen aus.
'!           Dabei wird insbesondere der Umgang mit den ein-
'!           zelnen Unterprogrammen gezeigt.
'!
'! Aufruf:   DBDOC
'**********************************************************
'! definiere die Header Datenstrukturen !!!!!!

$INCLUDE "DB_DEF.INC"

filename$ = ""                        '! Dateiname
ein%      = 1                         '! Filehandle

ON ERROR GOTO fehler                  '! Fehlerhandler

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

'! #####   Kopf ausgeben  ######
CLS                                    '! Clear Screen
PRINT "DBASE III (DBF) DOC              (c) Born Version 1.0"
PRINT
INPUT "File    : ", filename$          '! lese Dateiname
PRINT

IF filename$ = "" THEN                 '! Leereingabe ?
 PRINT "Der Name der Eingabedatei fehlt"
 END
END IF

'!-------------------------------------------------------
'!     *** Bearbeitung der DBASE III Datei ***
'!-------------------------------------------------------

CALL USE (ein%, filename$,status%)        '! ffne Datei

IF status% <> 0 THEN
 PRINT "Fehler : "; status%
 END
END IF

'!-------------------------------------------------------
'! ***  Ausgabe des Headers der DBASE III Datei ***
'! Die Version gibt dabei an, ob intern Memofelder be-
'! nutzt wurden (version = 83H -> Memodatei)
'!-------------------------------------------------------

PRINT "Header der DBASE III Datei"
PRINT
PRINT "Version       ";HEX$(ver%)
PRINT "Datum        ";ASC(MID$(header$,4,1));".";
PRINT ASC(MID$(header$,3,1));".";
PRINT ASC(MID$(header$,2,1))
PRINT "Records      "; rec&
PRINT "Header Lnge "; headb%
PRINT "Record Lnge "; reclen%
PRINT

INPUT "Weiter, bitte die <RET> Taste bettigen", tmp$

'!-------------------------------------------------------
'! lese und decodiere die Feldbescheibung der DBASE III-
'! Datei, es sind maximal 128 Felder zulssig
'!-------------------------------------------------------

PRINT "Feldbeschreibung der Datei ";filename$
PRINT
PRINT "Feldname      Typ     Stellen  Kommastellen"
PRINT ""

FOR i% = 1 TO anzahl%                  '! n Felddefinitionen
 PRINT feldname$(i%);" ";                 '! Name des Feldes
 SELECT CASE ftyp$(i%)                 '! gebe Feldtyp aus
 CASE "N"
  PRINT "Numerisch ";
 CASE "C"
  PRINT "Character ";
 CASE "L"
  PRINT "Logical   ";
 CASE "D"
  PRINT "Datum     ";
 CASE "M"
  PRINT "Memo      ";
 END SELECT

 PRINT USING "\  \##";"    ";laenge%(i%);    '! Feldlnge
 PRINT "      ";komma%(i%)                '! Nachkommastellen
NEXT i%
PRINT ""

'! *** Hinweis: Die Recordlnge ist 1 Byte grer als dies
'!              aus den Feldlngen ersichtlich ist, da
'!              im ersten Byte des Records die Information
'!              fr gelschte Stze steht (*).

PRINT "Recordlnge in Byte       "; reclen%
PRINT

INPUT "Weiter, bitte die <RET> Taste bettigen", tmp$

'!-------------------------------------------------------
'! lese und decodiere die Datenstze der DBASE III Datei
'!-------------------------------------------------------

PRINT "Datenstze der DBASE III Datei "; filename$
PRINT
'!-------------------------------------------------------
'! Hier wird gezeigt, wie der Inhalt der Datei satzweise
'! per FOR Schleife gelesen werden kann.
'!-------------------------------------------------------
CALL GotoBottom (ein%,status%)         '! auf 1. Satz
FOR i& = 1 TO rec&                     '! Schleife ber alle Records
 CALL GetRecord (ein%, status%, satz$) '! lese Satz
 PRINT satz$                           '! dokumentiere Satz
 CALL Skip (ein%, status%, 1)          '! nchster Satz
NEXT i&

'!-------------------------------------------------------
'! Der Inhalt des aktuellen Satzes wird verndert und in die
'! Datenbank zurckgespeichert
'!-------------------------------------------------------

satz1$ = " " + "Hallo" + MID$(satz$,7) '! ndere Feld 1
CALL PutRecord (ein%, status%, satz1$) '! speichere Satz

'!-------------------------------------------------------
'! Alternativ besteht die Mglichkeit, die Datei satzweise
'! zu lesen, bis EOF() erreicht ist. Hierfr dient die
'! Funktion DBEof().
'!-------------------------------------------------------

PRINT "Lese Datei nochmals"
CALL GotoBottom (ein%,status%)         '! auf 1. Satz
CALL DBEOF(ein%,status%)               '! EOF erreicht ?
WHILE status% = 0
 CALL GetRecord (ein%,status%,satz$)   '! lese Satz

 FOR i% = 1 TO anzahl%                 '! gebe Felder aus
  PRINT feldname$(i%), " : "; feldinh$(i%)
 NEXT i%

 INPUT "Weiter, bitte die <RET> Taste bettigen", tmp$

 CALL Skip (ein%, status%, 1)          '! nchster Satz
 CALL DBEOF(ein%,status%)              '! EOF erreicht ?
WEND
PRINT "EOF Erreicht"

INPUT "Weiter, bitte die <RET> Taste bettigen", tmp$

'!-------------------------------------------------------
'! Es wird ein leerer Satz angefgt und mit dem Inhalt des
'! vorletzten Satzes berschrieben
'!-------------------------------------------------------

PRINT "Leersatz anhngen"
CALL AppendBlank (ein%)                '! Leersatz anhngen
CALL PutRecord (ein%, status%, satz$)  '! alten Satz speichern

INPUT "Weiter, bitte die <RET> Taste bettigen", tmp$

CLOSE

PRINT "Ende DBDOC"
END

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in DBDOC
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Fehler: Datei nicht gefunden"
 CLOSE
 END
ELSE
 PRINT "Fehler : "; ERR; " unbekannt"
 PRINT "Programmabbruch"
 END
END IF
END                                    '! MSDOS Exit
RETURN

$INCLUDE "DBF_LIB.INC

'! **** Ende ****

