'*********************************************************
'! File       : DBF_LIB.INC
'! Vers.      : 1.0
'! Last Edit  : 10.6.92
'! Autor      : G. Born
'! Progr. Spr.: Power Basic 4.0 / 4.5
'! Funktion: Library mit Routinen zum Zugriff auf dBASE DBF-Files
'**********************************************************
'!
SUB MOVE INLINE
'---------------------------------------------------------
'! CALL MOVE (LEN, ZIEL, QUELLE)
'! Die Prozedur verschiebt n Byte eines Strings in die
'! Zieladresse. Achtung: der String mu mit seiner Adresse
'! angegeben werden.
'! Bsp.:   A$="AB"      String
'!         DIM a%(2)    Adress Dummy
'!         X% = 0       Ziel
'!         a%(1) = STRPTR (A$)
'!         a%(2) = STRSEG (A$)
'!         CALL MOVE (2, X%, a5(1)  verschiebe 2 Byte
'---------------------------------------------------------

$INLINE "move.com"

END SUB

SUB USE (handle%, filename$, status%)
'---------------------------------------------------------
'! Die Routine ffnet eine gltige DBASE III-Datei.
'! Parameter:  handle%   = Nummer Filehandle
'!             filename$ = Dateiname
'!             status%   = Fehlerstatus USE-Aufruf
'!                          0 -> ok,
'!                          2 -> keine DBF-Datei (dBASE III)
'!                          3 -> DBF-Datei (dBASE II)
'!                          4 -> EOF erreicht
'!                          5 -> kein Header Ende
'!
'---------------------------------------------------------

SHARED header$, ver%, rec&, headb%, reclen%, anzahl%
SHARED feldname$(), ftyp$(), laenge%(), komma%(), recofs&
LOCAL i%; headend$, tmp$
DIM a%(2)

'! ffne die DBF-Datei im BINARY-Mode
'! Achtung: da PB bei fehlender Datei diese
'! anlegt, wird erst im INPUT-Mode geprft,
'! ob die Datei vorhanden ist!!!

OPEN filename$ FOR INPUT AS #handle%  '! Datei vorhanden?
CLOSE #handle%
OPEN filename$ FOR BINARY AS #handle% '! ffne als Binary

GET$ #handle%, 32, header$            '! lese Kopf der Datei

ver% = (ASC(MID$(header$,1,1)))       '! decodiere Signatur
IF (ver% <> &H83) AND (ver% <> &H03) THEN
 CLOSE #handle%                       '! schlieen, da
 status% = 2                          '! keine DBF
 EXIT SUB
ELSEIF (ver% = &H02) THEN             '! DBASE II Header
 CLOSE #handle%                       '! schlieen, da
 status% = 3                          '! dBASE II DBF
 EXIT SUB
END IF

tmp$ = MID$(header$,5,4)               '! Elemente decodieren
a%(1) = STRPTR(tmp$)
a%(2) = STRSEG(tmp$)
CALL MOVE (4,rec&,a%(1))               '! Zahl der Records
tmp$ = MID$(header$,9,2)
a%(1) = STRPTR(tmp$)
a%(2) = STRSEG(tmp$)
CALL MOVE (2,headb%,a%(1))             '! Headerlnge
tmp$ = MID$(header$,11,4)
a%(1) = STRPTR(tmp$)
a%(2) = STRSEG(tmp$)
CALL MOVE (2,reclen%,a%(1))            '! Recordlnge

'!-------------------------------------------------------
'! lese und decodiere die Feldbescheibung der DBASE III-
'! Datei, es sind maximal 128 Felder zulssig
'!-------------------------------------------------------

anzahl% = ((headb% - 1) / 32) - 1      '! Zahl der Felder

SEEK #handle%, 32                      '! setze Zeiger auf 1. Feld
FOR i% = 1 TO anzahl%                  '! lese n Felddefinitionen
 GET$ #handle%,32, feld$               '! lese Definition Feld
 IF EOF(handle%) THEN                  '! Fehler abfangen?
  CLOSE #handle%                       '! schlieen, da
  status% = 4                          '! EOF erkannt
  EXIT SUB
 END IF

 feldname$(i%) = MID$(feld$,1,10)       '! Feldname
 ftyp$(i%) = MID$(feld$,12,1)           '! Feldtyp
 laenge%(i%) = ASC(MID$(feld$,17,1))    '! Lnge
 komma%(i%) = ASC(MID$(feld$,18,1))     '! Dezimalstellen

NEXT i%

'!-------------------------------------------------------
'! prfe ob nchstes Byte das Header Ende signalisiert
'!-------------------------------------------------------

GET$ #handle%,1, headend$              '! lese Zeichen
IF headend$ <> CHR$(&H0D) THEN         '! Ende = 0DH
  CLOSE #handle%                       '! schlieen, da kein
  status% = 5                          '! Ende Header da
  EXIT SUB
END IF

recofs& = SEEK (handle%)               '! merke Offset 1. Datensatz

END SUB  '! ***** use ******



SUB GetRecord (handle%, status%, buffer$)
'!-------------------------------------------------------
'! lese einen Satz aus der DBASE III - Datenbank und
'! gebe das Ergebnis in buffer$ zurck. Die Daten sind
'! als ASCII - Text in der Datenbank abgelegt.
'! handle% = filehandle, status% = 0 ok., 1 = EOF
'!-------------------------------------------------------
'!
SHARED header$, ver%, rec&, headb%, reclen%, anzahl%
SHARED feldname$(), ftyp$(), laenge%(), komma%(), recofs&
SHARED feldinh$()
LOCAL i%, ptr%, lang%

 status% = 0
 SEEK #handle%, recofs&              '! auf Satzanfang
 GET$ #handle%, reclen% ,buffer$     '! lese Satz in Buffer
 IF EOF(handle%) THEN
  status% = 1    '! Error
 ELSE
  ptr% = 2
  FOR i% = 1 to anzahl%              '! separiere Felder
   lang% = laenge%(i%)               '! Feldlnge
   feldinh$(i%) = MID$(buffer$,ptr%,lang%)
   ptr% = ptr% + lang%
  NEXT i%
 END IF

END SUB  '! ****** GetRecord *****

SUB PutRecord (handle%, status%, buffer$)
'!-------------------------------------------------------
'! Schreibe einen Satz in die DBASE III - Datenbank.
'! Die Daten sind als ASCII - Text im Puffer, geordnet
'! nach Feldern, abzulegen. Achtung: Die Bufferlnge
'! mu gleich der Recordlnge in DBASE sein !!!
'! Der Inhalt des Puffers wird an der aktuellen Stelle
'! in die Datenbank abgespeichert.
'! handle% = filehandle, status% = 0 ok., 1 = Fehler
'!-------------------------------------------------------
'!
SHARED header$, ver%, rec&, headb%, reclen%, anzahl%
SHARED feldname$(), ftyp$(), laenge%(), komma%(), recofs&
LOCAL datum$

 IF (LEN(buffer$) <> reclen%) THEN   '! Buffer = Satzlnge
  status% = 1                        '! Satzlnge falsch
  EXIT SUB
 END IF

 SEEK #handle%, recofs&               '! auf Satzanfang
 PUT$ #handle%, buffer$               '! schreibe Buffer in DB


 datum$ = CHR$(VAL(MID$(DATE$,9,2)))_  '! Jahr
        + CHR$(VAL(MID$(DATE$,1,2)))_  '! Monat
        + CHR$(VAL(MID$(DATE$,4,2)))   '! Tag

 SEEK #handle%, 1
 PUT$ #handle%, datum$                 '! Datum aktualisieren
 status% = 0

END SUB  '! ****** PutRecord *****


SUB AppendBlank (handle%)
'!-------------------------------------------------------
'! Hnge einen leeren Satz in die DBASE III - Datenbank an.
'! nach dem Aufruf steht der Schreiblesezeiger auf diesem
'! Satz, d.h. PutRecord kann direkt Daten speichern.
'!-------------------------------------------------------
'!
SHARED header$, ver%, rec&, headb%, reclen%, anzahl%
SHARED feldname$(), ftyp$(), laenge%(), komma%(), recofs&

LOCAL buf$, satz$, i%, tmp&

 satz$ = SPACE$(reclen%) + CHR$(&H1A) '! Leersatz mit EOF
 rec& = rec& + 1
 recofs& = headb% + (rec& * reclen%)  '! Endezeiger

 SEEK #handle%, recofs&               '! an Dateiende
 PUT$ #handle%, satz$                 '! append Leersatz

'! Datum und Recordzahl im Header korrigieren

 buf$   = CHR$(VAL(MID$(DATE$,9,2)))_  '! Jahr
        + CHR$(VAL(MID$(DATE$,1,2)))_  '! Monat
        + CHR$(VAL(MID$(DATE$,4,2)))   '! Tag

 tmp& = rec&
 FOR i% = 1 to 4
  buf$ = buf$ + CHR$(tmp& AND &HFF)    '! in String
  tmp& = tmp& / &H100
 NEXT i%
 SEEK #handle%, 1
 PUT$ #handle%, buf$                   '! aktualisieren
 status% = 0

END SUB  '! ****** AppendBlank *****

SUB Skip (handle%, status%, n%)
'!-------------------------------------------------------
'! Positioniere den Schreib- / Lesezeiger n Stze weiter.
'!-------------------------------------------------------
'!
SHARED header$, ver%, rec&, headb%, reclen%, anzahl%
SHARED feldname$(), ftyp$(), laenge%(), komma%(), recofs&

LOCAL min1&, max1&, tmp&

 status% = 0
 min1& = headb%                     '! Grenzen
 max1& = headb% + (rec& * reclen%)
 tmp& = recofs& + (reclen% * n%)
 IF tmp& < min1& THEN               '! Untergrenze prfen
  status% = 1
 ELSEIF tmp& > max1& THEN          '! Obergrenze prfen
  status% = 1
 ELSE
  recofs& = tmp&
 END IF

END SUB  '! ****** Skip *****

SUB GotoBottom (handle%, status%)
'!-------------------------------------------------------
'! Positioniere den Schreib- / Lesezeiger auf Satz 1.
'!-------------------------------------------------------
'!
SHARED header$, ver%, rec&, headb%, reclen%, anzahl%
SHARED feldname$(), ftyp$(), laenge%(), komma%(), recofs&

 status% = 0
 recofs& = headb%                    '! 1. Satz

END SUB  '! ****** GotoBottom *****

SUB GotoTop (handle%, status%)
'!-------------------------------------------------------
'! Positioniere den Schreib- / Lesezeiger auf letzen Satz
'!-------------------------------------------------------
'!
SHARED header$, ver%, rec&, headb%, reclen%, anzahl%
SHARED feldname$(), ftyp$(), laenge%(), komma%(), recofs&

 status% = 0
 recofs& = headb% + (reclen% * rec&)  '! letzter Satz

END SUB  '! ****** GotoTop *****

SUB DBEof (handle%, status%)
'!-------------------------------------------------------
'! Prfe, ob EOF() der Datenbank erreicht ist
'!-------------------------------------------------------
'!
SHARED header$, ver%, rec&, headb%, reclen%, anzahl%
SHARED feldname$(), ftyp$(), laenge%(), komma%(), recofs&
LOCAL tmp&

 status% = 1
 tmp& = headb% + (reclen% * rec&)
 IF recofs& < tmp& THEN
  status% = 0                           '! True
 END IF

END SUB  '! ****** DBEof *****

'! **** Ende ****

