'*********************************************************
'! File       : DELX.BAS
'! Vers.      : 1.0
'! Last Edit  : 16.5.92
'! Autor      : G. Born
'! Files      : INPUT, OUTPUT
'! Progr. Spr.: Power Basic
'! Betr. Sys. : DOS 2.1 - 5.0
'! Funktion: Das Programm lscht eine Datei pyhsikalisch, d.h.
'!           die Daten werden erst mit FFH berschrieben.
'!
'! Aufruf:   DELX                          '! Interaktiv Mode
'!           DELX <datei1>                 '! Kommando Mode
'!           DELX /?                       '! Online-Hilfe
'**********************************************************
'! Variable definieren

ein% = 1                              '! I/O Kanal
ptr% = 0: hilf& = 0                   '! Hilfszeiger
konst$ = ""

ON ERROR GOTO fehler

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! Interaktiv Mode ?
 CLS                                  '! ja -> Clear Screen
'! #####   Kopf ausgeben  ######
 PRINT "D E L X                       (c) Born Version 1.0"
 PRINT "Lschen einer Datei"
 PRINT
 INPUT "Datei : ",infilename$  '! lese Dateiname Eingabe
 PRINT
ELSE                                  '! Kommando Mode
 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "D E L X                       (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf:   DELX"
  PRINT "          DELX <datei>"
  PRINT
  PRINT "Das Programm lscht eine Datei, wobei deren Inhalt ber-"
  PRINT "schrieben wird."
  PRINT
  SYSTEM
 END IF
'!
'! getfile separiert den Dateinamen aus der Kommandozeile
'!
 kommando$ = UCASE$(kommando$) + " "  '! Blank als Endeseparator
 ptr% = 1                             '! Parameter holen
 CALL getfile(ptr%, kommando$,infilename$) '! Name Eingabedatei
END IF

IF infilename$ = "" THEN              '! Leereingabe ?
 PRINT "Der Name der Datei fehlt"
 END
END IF

OPEN infilename$ FOR INPUT AS #ein%   '! Datei vorhanden ?
CLOSE                                 '! ja-> open als
OPEN infilename$ FOR BINARY AS #ein%  '! Binary Datei
konst$ = STRING$(512,CHR$(&HFF))      '! auf FFH setzen

PRINT "Die Datei ";infilename$;
PRINT " wird gelscht"

WHILE NOT (EOF(ein%))
 GET$ #ein%, 512, zchn$               '! lese 512 Bytes
 SEEK #ein%, hilf&                    '! auf Anfang Satz
 IF LEN(zchn$) = 512 THEN             '! voller Satz ?
  PUT$ #ein% , konst$                 '! schreibe 512 * FFH
 ELSE
  PUT$ #ein%, STRING$(LEN(zchn$),CHR$(&HFF)) '! n Bytes
  EXIT LOOP                           '! EOF erreicht
 END IF
 hilf& = hilf& + LEN(zchn$)           '! Zeiger + n
WEND

CLOSE                                 '! Datei schlieen

outfile$ = LEFT$(infilename$,INSTR(infilename$,":"))
outfile$ = outfile$ + "HBorn.G"       '! neuer Name

NAME infilename$ AS outfile$          '! umbenennen

KILL outfile$                         '! lsche Datei

PRINT "Die Datei ";infilename$;
PRINT " ist gelscht"

END

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in XREF
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";infilename$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
END                                 '! MSDOS Exit
RETURN

SUB getfile(ptr%,text$,result$)
'!---------------------------------------------------------
'! separiere Filename aus Eingabetext (text$)
'! ptr% -> Anfang Filename, result$ = Filename
'!---------------------------------------------------------
LOCAL tmp%

CALL skipblank (ptr%,text$)            '! entferne Blanks
tmp% = INSTR(ptr%,text$," ")           '! suche Separator
IF tmp% = 0 THEN
 PRINT "Fehler: kein Fileseparator"    '! kein Endeseparator
 END                                   '! Exit
END IF
IF MID$(text$,ptr%,1) = "/" THEN       '! Optionen eingegeben ?
 result$ = ""                          '! Leerstring
ELSE
 result$ = MID$(text$,ptr%,tmp%-ptr%)  '! Filename
 ptr% = tmp%                           '! korrigiere ptr%
END IF

END SUB

SUB skipblank(ptr%,text$)
'!---------------------------------------------------------
'! entferne fhrende Leerzeichen aus text$
'!---------------------------------------------------------

LOCAL lang%, zchn$

lang% = LEN (text$)                    '! Stringlnge
zchn$ = MID$(text$,ptr%,1)             '! separiere Zeichen

WHILE (zchn$ = " ") AND (ptr% <= lang%) '! Zeichen <> blank
 INCR ptr%
 zchn$ = MID$(text$,ptr%,1)            '! separiere Zeichen
WEND

END SUB

'***** Programm Ende ******
