'*********************************************************
'! File       : DUMP.BAS
'! Vers.      : 1.0
'! Last Edit  : 7.5.92
'! Autor      : G. Born
'! Files      : INPUT, OUTPUT, FILE
'! Progr. Spr.: POWER Basic
'! Betr. Sys. : DOS 2.1 - 5.0
'! Funktion: Das Programm gibt den Inhalt einer Datei in Form
'!           von Hexzahlen auf den Screen oder Printer aus.
'! Ausgabe : Adr    16 Bytes
'!           0000 xx xx xx .....   xx xx xx <- Hex Werte
'!                 a  a  a .....    a  a  a <- ASCII Werte
'!           Nicht darstellbare Codes werden in der ASCII
'!           Anzeige durch einen "." markiert. Mit der Option
'!           /P erfolgt die Ausgabe auf dem Drucker. Mit /W
'!           wird der Wide Mode aktiviert, welcher die
'!           ASCII Zeichen hinter die Hexausgabe positioniert.
'!           Mit /M wird die More Option angewhlt, die die
'!           Ausgabe anhlt, sobald der Screen voll ist.
'!
'! Aufruf:   DUMP                            interaktiver Mode
'!           DUMP <datei> <options>          Kommando Mode
'**********************************************************
'! Variable definieren
%true = &HFFFF: %false = 0            '! Konstante
ein% = 1                              '! Kanal fr I/O
options$ = ""                         '! Optionen
more% = %false                        '! More Option aus
druck% = %false                       '! keine Printerausgabe
wide% = %false                        '! Normalmode

DIM code%(0:15)                       '! Puffer fr 16 Bytes
adr& = 0                              '! Anfangsadresse Zeile
ptr% = 0

%maxscr = 19                          '! Zeilenzahl pro Screen
%maxprt = 60                          '! Zeilenzahl pro Druckseite
maxzeile% = %maxscr                   '! Zeilenzahl fr Screen
zeile% = 2                            '! Zeilennummer der Seite
seite% = 1                            '! Seitennummer
spacex% = 1                           '! Zwischenraum ASCII
kommando$ = ""
filename$ = ""                        '! Dateiname
hilf% = 0

ON ERROR GOTO fehler

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! Interaktiv Mode ?
 CLS                                  '! ja -> Clear Screen
'! #####   Kopf ausgeben  ######
 PRINT "D U M P                            (c) Born Version 1.0"
 PRINT "Options [/Wide /More /Print                           ]"
 PRINT
 INPUT "File    : ",filename$        '! lese Dateiname
 INPUT "Options : ",options$          '! lese Optionen
 PRINT
ELSE                                  '! Kommando Mode
 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "D U M P                            (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf:  DUMP <Filename> <Optionen>
  PRINT
  PRINT "Das Programm gibt den Inhalt einer Binrdatei als Hex-"
  PRINT "Dump auf dem Bildschirm oder Drucker aus. Optionen:"
  PRINT
  PRINT "/W  WIDE-Mode mit Hexzahlen und Text in einer Zeile"
  PRINT "/M  More-Mode, seitenweise Ausgabe am Bildschirm"
  PRINT "/P  Ausgabe auf den Drucker"
  PRINT
  SYSTEM
 END IF
'!
'! getfile separiert den Dateinamen aus der Kommandozeile
'! Falls ein Name fehlt, wrden die Optionen in die jeweilige
'! Variable gespeichert. Dies ist abgefangen, da Optionen mit
'! /.. beginnen. Dann wird ein Leerstring zurckgegeben
'!
 kommando$ = UCASE$(kommando$) + " "  '! Blank als Endeseparator
 ptr% = 1                             '! Parameter holen
 CALL getfile(ptr%, kommando$,filename$) '! Name Eingabedatei
 INCR ptr%                            '! Anfang next token
 hilf% = INSTR(kommando$,"/")         '! suche Optionen
 IF hilf% >= ptr% THEN                '! gefunden ?
  options$ = MID$(kommando$,hilf%)    '! Reststring mit Optionen
 END IF
END IF

IF filename$ = "" THEN                '! Leereingabe ?
 PRINT "Der Name der Eingabedatei fehlt"
 END
END IF

OPEN filename$ FOR INPUT AS #ein%     '! Eingabedatei vorhanden?
CLOSE                                 '! Ja -> ffne als Binrdatei

OPEN filename$ FOR BINARY AS #ein%    '! ffne Eingabedatei

IF LEN(options$) > 0 THEN
 GOSUB getswitch                      '! lese Optionen
END IF

CALL kopf                           '! 1. Seitenkopf ausgeben

'!
'! bearbeite Datei je nach Option
'!
IF druck% THEN
 PRINT "Ausgabe auf dem Drucker"
END IF

ptr% = 0                              '! auf 1. Eintrag
WHILE NOT (EOF(ein%))                 '! lese sequentiell
 GET$ #ein%, 1, zchn$                 '! lese 1 Byte aus Birdatei
 code%(ptr%) = ASC(zchn$)             '! wandele in Hex
 IF ptr% > 14 THEN                    '! 16 Bytes gelesen ?
  IF druck% THEN
   CALL writeprn                      '! auf Printer ausgeben
  ELSE
   CALL writescr                      '! auf Screen ausgeben
  END IF
 ELSE
  INCR ptr%                           '! next entry
 END IF

WEND

IF druck% THEN                        '! Restdaten ausgeben
 CALL writeprn                        '! auf Printer ausgeben
ELSE
 CALL writescr                        '! auf Screen ausgeben
END IF

CLOSE
PRINT "Ende Dump"
END

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in XREF
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";filename$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
END                                 '! MSDOS Exit
RETURN

getswitch:
'--------------------------------------------------------
'! decodiere eingegebene Optionen
'! option$ ist der String mit den Optionen
'---------------------------------------------------------

 options$ = UCASE$(options$)

 IF INSTR(options$,"/M") > 0 THEN
  more% = %true                        '! More  Mode ein
 END IF

 IF INSTR(options$,"/W") > 0 THEN      '! wide Option ?
  wide% = %true                        '! Wide ein
  spacex% = 0                          '! kein Zwischenraum
END IF

 IF INSTR(options$,"/P") > 0 THEN      '! Printer Option ?
  druck% = %true                       '! ja -> setze Mode
  more% = %false                       '! More ausschalten
  maxzeile% = %maxprt                  '! Zeilenzahl fr Printer
 END IF

RETURN


SUB getfile(ptr%,text$,result$)
'!---------------------------------------------------------
'! separiere Filename aus Eingabetext (text$)
'! ptr% -> Anfang Filename, result$ = Filename
'!---------------------------------------------------------
LOCAL tmp%

CALL skipblank (ptr%,text$)            '! entferne Blanks
tmp% = INSTR(ptr%,text$," ")           '! suche Separator
IF tmp% = 0 THEN
 PRINT "Fehler: kein Fileseparator"    '! kein Endeseparator
 END                                   '! Exit
END IF
IF MID$(text$,ptr%,1) = "/" THEN       '! Optionen eingegeben ?
 result$ = ""                          '! Leerstring
ELSE
 result$ = MID$(text$,ptr%,tmp%-ptr%)  '! Filename
 ptr% = tmp%                           '! korrigiere ptr%
END IF

END SUB


SUB newscreen
'---------------------------------------------------------
'! More Abfrage bei vollem Bildschirm
'---------------------------------------------------------
SHARED zeile%

IF zeile% > maxzeile% THEN
 PRINT
 PRINT "Weiter, bitte eine Taste bettigen ..."
 WHILE LEN(INKEY$) = 0                '! warte auf Taste
 WEND
 CALL kopf                             '! Seitenkopf
END IF
END SUB


SUB kopf
'---------------------------------------------------------
'! Seitenvorschub und Ausgabe des Seitenkopfes auf Screen oder
'! Drucker. Bei der Druckerausgabe werden Filename und Seiten-
'! nummer mit ausgegeben.
'---------------------------------------------------------
SHARED seite%, filename$, zeile%, druck%

 IF druck% THEN
  IF seite% > 1 THEN LPRINT CHR$(12); '! Seitenvorschub
  LPRINT "File : "; filename$,
  LPRINT SPACE$(15);"Seite : "; seite%
  LPRINT " Adr               Werte"   '! auf Screen
  LPRINT
  INCR seite%
  zeile% = 3
 ELSE
  CLS
  PRINT " Adr               Werte"     '! auf Screen
  PRINT
  zeile% = 2
 END IF

END SUB

SUB writescr
'--------------------------------------------------------
'! Ausgabe der 16 gelesenen Werte im HEX und ASCII Format
'! auf dem Bildschirm
'! code (16)         16 Bytes aus der Datei
'--------------------------------------------------------
LOCAL res$, i%, zchn$
SHARED zeile%, maxzeile%, code%(), adr&, ptr%
SHARED spacex%, more%, wide%

 IF (zeile% > maxzeile%) AND more% THEN
  CALL newscreen                      '! Bildwechsel
 END IF

 res$ = HEX$(adr&)                    '! Hexausgabe mit
 PRINT STRING$(5-LEN(res$),"0");res$;" "; '! fhrend. Nullen
 FOR i% = 0 TO ptr%                   '! Codes ausgeben
  res$ = HEX$(code%(i%) AND &HFF)     '! Hexausgabe mit
  PRINT STRING$(2-LEN(res$),"0");res$;" "; '! fhrend. Nullen
 NEXT i%

 IF NOT wide% THEN
  PRINT: PRINT "     ";               '! keine Wide Option
 ELSE
  IF ptr% < 15 THEN                   '! Zeile nicht voll !!
   PRINT SPACE$((15 - ptr%) * 3);     '! Vorschub n Zeichen
  END IF
  PRINT " ";                          '! Leerzeichen
 END IF

 FOR i% = 0 TO ptr%                   '! ASCII ausgeben
  IF code%(i%) > &H1F THEN
   zchn$ = CHR$(code%(i%))            '! ASCII Wert
  ELSE
   zchn$ = "."                        '! nicht darstellbar
  END IF
  PRINT SPACE$(spacex%);zchn$; _      '! ASCII Darstellung
        SPACE$(spacex%);              '! ausgeben
 NEXT i%
 PRINT
 INCR adr&, 16                        '! Adresse + 16
 IF wide% THEN
  INCR zeile%                         '! wide -> Zeile + 1
 ELSE
  INCR zeile%, 2                      '! Zeile + 2
 END IF
 ptr% = 0                             '! reset ptr%

END SUB


SUB writeprn
'!--------------------------------------------------------
'! Ausgabe der Werte auf dem Drucker
'!--------------------------------------------------------
LOCAL res$, i%, zchn$
SHARED zeile%, maxzeile%, code%(), adr&, ptr%
SHARED spacex%, wide%

 IF zeile% > maxzeile% THEN
  CALL kopf                           '! Seitenwechsel
 END IF

 res$ = HEX$(adr&)                    '! Hexausgabe mit
 LPRINT STRING$(5-LEN(res$),"0");res$;" "; '! fhrend. Nullen
 FOR i% = 0 TO ptr%                   '! Codes ausgeben
  res$ = HEX$(code%(i%) AND &HFF)     '! Hexausgabe mit
  LPRINT STRING$(2-LEN(res$),"0");res$;" "; '! fhrend. Nullen
 NEXT i%

 IF NOT wide% THEN
  LPRINT: LPRINT "     ";             '! keine Wide Option
 ELSE
  IF ptr% < 15 THEN                   '! Zeile nicht voll !!
   LPRINT SPACE$((15 - ptr%) * 3);    '! Vorschub n Zeichen
  END IF
  LPRINT " ";                         '! Leerzeichen
 END IF

 FOR i% = 0 TO ptr%                   '! ASCII ausgeben
  IF code%(i%) > &H1F THEN
   zchn$ = CHR$(code%(i%))             '! ASCII Wert
  ELSE
   zchn$ = "."                        '! nicht darstellbar
  END IF
  LPRINT SPACE$(spacex%);zchn$; _     '! ASCII Darstellung
        SPACE$(spacex%);              '! ausgeben
 NEXT i%
 LPRINT
 INCR adr&, 16                        '! Adresse + 16
 IF wide% THEN
  INCR zeile%                         '! Zeile + 1 -> wide%
 ELSE
  INCR zeile%, 2                      '! Zeile + 2
 END IF
 ptr% = 0                             '! reset ptr%

END SUB

SUB skipblank(ptr%,text$)
'!---------------------------------------------------------
'! entferne fhrende Leerzeichen aus text$
'!---------------------------------------------------------

LOCAL lang%, zchn$

lang% = LEN (text$)                    '! Stringlnge
zchn$ = MID$(text$,ptr%,1)             '! separiere Zeichen

WHILE (zchn$ = " ") AND (ptr% <= lang%) '! Zeichen <> blank
 INCR ptr%
 zchn$ = MID$(text$,ptr%,1)            '! separiere Zeichen
WEND

END SUB

'***** Programm Ende ******
