'*********************************************************
'! File       : ESC.BAS
'! Vers.      : 1.0
'! Last Edit  : 16.5.92
'! Autor      : G. Born
'! Progr. Spr.: Power Basic
'! Betr. Sys. : DOS 2.1 - 5.0 (DR-DOS 5.0/6.0)
'! Funktion: Das Programm wird mit der Eingabe:
'!
'!           ESC <Para 1> <Para 2> .. <Para n>
'!
'!           aufgerufen. Es liest die Parameter und gibt
'!           den Inhalt auf der Standard Ausgabeinheit aus.
'!           Bei Zahlen als Parameter werden diese als Hexwerte
'!           interpretiert und in ASCII Codes gewandelt. Beispiel:
'!
'!             ESC 20 "Hallo" 0D 0A
'!
'!           Zahlen werden als Hexwerte mit je 2 Ziffern interpre-
'!           tiert. Parameter sind durch Blanks zu separieren.
'!           Zeichenketten sind in ".." einzuschlieen.
'**********************************************************
'! Variable definieren
ptr% = 0
kommando$ = ""
lang% = 0

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

 ON ERROR GOTO fehler

 kommando$ = COMMAND$                 '! Parameter ?

 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "E S C                        (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: ESC <Param 1> <Param 2> .. <Param n>
  PRINT
  PRINT "Das Programm gibt in den Parametern angegebene Texte"
  PRINT "oder Hexzahlen (2 Ziffern) an die Standardausgabeeinheit"
  PRINT "aus. Beispiel:"
  PRINT
  PRINT "ESC 0C > PRN:"
  PRINT "ESC "Hallo" 0D 0A"
  PRINT
  SYSTEM
 END IF

 OPEN "CONS:" FOR OUTPUT AS #1

 ptr% = 1
 lang% = LEN(kommando$)                      '! Lnge Parameterstring

 WHILE ptr% <= lang%                         '! separiere Parameter
  CALL getpara (ptr%, kommando$)
 WEND

 CLOSE #1

END                                          '! Ende

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

SUB getpara (ptr%, text$)

'!---------------------------------------------------------
'! lese die Parameter und geben sie aus
'!---------------------------------------------------------
LOCAL zchn$

'! suche Anfang des Parameters
 CALL skipblank (ptr%,text$)        '! skip fhrende blanks

'! liegt ein String vor ?

 zchn$ = MID$(text$,ptr%,1)
 IF (zchn$ = CHR$(34)) THEN
  CALL WRSTRING (ptr%, text$)       '! String ausgeben
 ELSE
  CALL WRVal (ptr%, text$)          '! Hexwert ausgeben
 END IF
END SUB

SUB skipblank(ptr%,text$)
'---------------------------------------------------------
'! berlese fhrende Blanks in einer Zeichenkette
'! text$ = Zeichenkette, ptr% = Zeiger in Kette
'---------------------------------------------------------
SHARED lang%

WHILE (ptr% =< lang%) and (MID$(text$,ptr%,1) = " ")
 INCR ptr%
WEND
IF ptr% >= lang% THEN
 CALL Ende (0)                   '! Textende erreicht
END IF
END SUB


SUB WRVal (ptr%,text$)

'!---------------------------------------------------------
'! decodieren der Hexzahl
'!---------------------------------------------------------

LOCAL tmp%, zchn$, wert%

 zchn$ = UCASE$(MID$(text$,ptr%,1)) '! hole 1. Ziffer
 tmp%  = INSTR("0123456789ABCDEF",zchn$) '! decodiere Ziffer

 IF tmp% = 0 THEN                 '! Wert gefunden ?
  PRINT "Fehler in Parameter ";MID$(text$,ptr%,10)  '! Text ausgeben
  CALL Ende (255)
 END IF

 wert% = (tmp%-1) * 16

 INCR ptr%
 zchn$ = UCASE$(MID$(text$,ptr%,1)) '! hole 2. Ziffer
 tmp%  = INSTR("0123456789ABCDEF",zchn$) '! decodiere Ziffer

 IF tmp% = 0 THEN                 '! Wert gefunden ?
  PRINT "Fehler in Parameter ";MID$(text$,ptr%,10)  '! Text ausgeben
  CALL Ende (255)
 END IF

 wert% = wert% + (tmp% - 1)

 PRINT #1, CHR$(wert%);            '! Hexzahl als ASCII-Code
 INCR ptr%                         '! auf Folgezeichen
END SUB

SUB WRString (ptr%,text$)

'!---------------------------------------------------------
'! Ausgabe des Strings
'!---------------------------------------------------------

LOCAL tmp%, zchn$, wert%
SHARED lang%

'! suche Ende des Strings

 INCR ptr%
 anf% = ptr%                         '! merke Anfang
 WHILE (MID$(text$,ptr%,1) <> CHR$(34)) AND ptr% <= lang%
  INCR ptr%                          '! hole nchstes Zeichen
 WEND

 PRINT #1, MID$(text$,anf%,ptr%-anf%); '! Text ausgeben
 INCR ptr%

END SUB

fehler:
'!---------------------------------------------------------
'! Abfrageroutine fr Power Basic Fehler
'!---------------------------------------------------------

 PRINT "Fehler : ";ERR;
 CALL Ende(255)
RETURN

SUB Ende (errx%)
'!
'! schliee Dateien und terminiere
'!
 CLOSE #1
 END (errx%)
END SUB

'!***** Programm Ende ******
