'*********************************************************
'! File       : GET.BAS
'! Vers.      : 1.0
'! Last Edit  : 26.5.92
'! Autor      : G. Born
'! Progr. Spr.: Power Basic
'! Betr. Sys. : DOS 2.1 - 5.0 (DR-DOS 5.0/6.0)
'! Funktion: Das Programm wird mit der Eingabe:
'!
'!           GET <Option>
'!
'!           aufgerufen. Es erlaubt die Abfrage verschiedener
'!           Systemprarameter und gibt die Werte als Error-
'!           code an DOS zurck. Das Ergebnis lt sich ber
'!           ERRORLEVEL ausgewerte.
'!
'!             IF ERRORLEVEL 3 ...
'!
'**********************************************************
'! Variable definieren
ptr% = 0
kommando$ = ""

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = UCASE$(COMMAND$)         '! Parameter ?

ptr% = INSTR (kommando$,"/?")        '! Option /?
IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "G E T                        (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: GET  <Option>"
  PRINT
  PRINT "Erlaubt die Abfrage bestimmter Parameter"
  PRINT "GET /DAY   ermittelt den Tag (1-31)"
  PRINT "GET /MONTH ermittelt den Monat (1-12)"
  PRINT "GET /YEAR  ermittelt das Jahr (0-99)"
  PRINT "GET /WEEK  ermittelt den Wochentag (0-6)"
  PRINT "GET /SEC   ermittelt die Sekunden (0-59)"
  PRINT "GET /MIN   ermittelt die Minuten (0-59)"
  PRINT "GET /STD   ermittelt die Stunden (0-23)"
  PRINT "GET /MEM   freier Haupspeicher in 4 KB-Blcken"
  PRINT
  PRINT "Die Fehlercodes lassen sich durch ERRORLEVEL auswerten."
  PRINT
  SYSTEM
END IF

'! Sprungverteiler fr die einzelnen Kommandos
ptr% = INSTR (kommando$,"/DAY")       '! Option /DAY
IF ptr% > 0 THEN CALL GETDATE (1)

ptr% = INSTR (kommando$,"/MONTH")     '! Option /MONTH
IF ptr% > 0 THEN CALL GETDATE (2)

ptr% = INSTR (kommando$,"/YEAR")      '! Option /YEAR
IF ptr% > 0 THEN CALL GETDATE (3)

ptr% = INSTR (kommando$,"/WEEK")      '! Option /Wochentag
IF ptr% > 0 THEN CALL GETDATE (4)

ptr% = INSTR (kommando$,"/SEC")       '! Option /SEC
IF ptr% > 0 THEN CALL GETTIME(1)

ptr% = INSTR (kommando$,"/MIN")       '! Option /MIN
IF ptr% > 0 THEN CALL GETTIME(2)

ptr% = INSTR (kommando$,"/STD")       '! Option /STD
IF ptr% > 0 THEN CALL GETTIME(3)

ptr% = INSTR (kommando$,"/MEM")       '! Option /MEM
IF ptr% > 0 THEN
 REG 1, &H5100                         '! AX = 5100 -> read
                                       '! PSP Segm. Adr
 CALL INTERRUPT &H21                   '! Dispatcher INT
 IF (REG (0) AND &H01) > 0 THEN        '! Fehler ?
  END (0)                              '! Fehlercode
 ELSE
  start& = REG(2)                      '! merke Adresse
 END IF

 CALL INTERRUPT &H12                   '! BIOS: GET RAM SIZE
 ram& = REG(1)                         '! RAM Gre
 ram& = ram& * &H3FF
 frei& = ram& - (start& * 16)          '! berechne. freie Gre
 END (frei& / 4096)                    '! Korrektur 4 Kbyte Block
END IF

END                                   '! Ende

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

SUB GETDATE (Nr%)
'!--------------------------------------------------------
'! Ermittelt das Datum und gibt es als Fehlercode an DOS
'! 1 = Tag, 2 = Monat, 3 = Jahr, 4 = Wochentag
'!--------------------------------------------------------

 LOCAL dat$

 SELECT CASE Nr%

  CASE 1
   dat$ = MID$(DATE$,1,2)                '! Tag ermitteln
   END (VAL(dat$))

  CASE 2
   dat$ = MID$(DATE$,4,2)                '! Monat ermitteln
   END (VAL(dat$))

  CASE 3
   dat$ = MID$(DATE$,9,2)                '! Jahr ermitteln
   END (VAL(dat$))

  CASE 4
   REG 1, &H2A00                         '! INT 21, 2AH GET DATE
   CALL INTERRUPT &H21                   '! Wochentag in AL
   END (REG(1) AND &HFF)

  END SELECT
END SUB


SUB GETTIME (Nr%)
'!--------------------------------------------------------
'! Ermittelt die Zeit und gibt sie als Fehlercode an DOS
'! 1 = Sek., 2 = Min. 3 = Std.
'!--------------------------------------------------------

 LOCAL tim$

 SELECT CASE Nr%

  CASE 1
   tim$ = MID$(TIME$,7,2)                '! Sek. ermitteln
   END (VAL(tim$))

  CASE 2
   tim$ = MID$(TIME$,4,2)                '! Min. ermitteln
   END (VAL(tim$))

  CASE 3
   tim$ = MID$(TIME$,1,2)                '! Std. ermitteln
   END (VAL(tim$))

  END SELECT
END SUB

'***** Programm Ende ******
