'*********************************************************
'! File       : HWINFO.BAS
'! Vers.      : 1.0
'! Last Edit  : 16.5.92
'! Autor      : G. Born
'! Files      : INPUT, OUTPUT
'! Progr. Spr.: Power Basic
'! Betr. Sys. : DOS 2.1 - 5.0
'! Funktion: Das Programm wird mit der Eingabe:
'!
'!           HWINFO
'!
'!           aufgerufen. Es ermittelt die Konfiguration
'!           des PC's und gibt das Ergebnis auf dem
'!           Bildschirm aus.
'**********************************************************
'! Variable definieren
frei& = 0                             '! freier Speicher
start& = 0                            '! Startadresse

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

ON ERROR GOTO fehler

PRINT
PRINT "S y s t e m   I N F O             (c) Born Version 1.0"
PRINT

CALL bios                              '! Bios Copyright
CALL dosvers                           '! DOS Versionsnummer
CALL memory                            '! Speicherbelegung
CALL progadr                           '! Adr. Userprogramme
CALL freemem                           '! freier Speicher

PRINT "Weiter bitte eine Taste bettigen"
DO WHILE INKEY$ = "": WEND

CALL config                            '! Systemkonfigurierung

PRINT
PRINT "Ende System Info"
END                                    '! Ende

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in HWINFO
'---------------------------------------------------------

 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END                                 '! MSDOS Exit

SUB bios
'!---------------------------------------------------------
'! lese Bios Signatur
'!---------------------------------------------------------
LOCAL i%

DEF SEG = &HF800                    '! Segm. Bios ROM

PRINT
PRINT "Bios Version ";
FOR i% = 3 TO 50
 PRINT CHR$(PEEK (i%));
NEXT i%
PRINT

END SUB

SUB dosvers
'!---------------------------------------------------------
'! ermittle die DOS Version ber die INT 21 Funktion 30
'! CALL: AH = 30   RETURN: AL = Untervers. AH = Hauptvers.
'!---------------------------------------------------------

 LOCAL AH%, AL%

 REG 1, &H3000                         '! AX = 3000 -> read
                                       '! Version
 CALL INTERRUPT &H21                   '! Dispatcher INT

 AH% = (REG (1) / 256) AND &HFF        '! lese Wert in AH
 AL% = REG (1) AND &HFF                '! lese Wert in AL
 PRINT
 IF AL% = 0 THEN                       '! AL = leer ?
  PRINT "MS-DOS Version 1.x"
 ELSE
  PRINT "MS-DOS Version ";             '! Versionsnummer
  PRINT USING "##&"; AL%; ".";         '! AL = Hauptversion
  PRINT USING "##"; AH%                '! AH = Unterversion
 END IF
END SUB

SUB memory
'!---------------------------------------------------------
'! ermittle die RAM und ROM Speichergre
'!---------------------------------------------------------
LOCAL i&

PRINT

'!
'! ermittle die RAM Gre ber den BIOS INT 12
'! Ergebnis in AX in Kbyte
'!

 CALL INTERRUPT &H12                   '! BIOS: GET RAM SIZE
 PRINT "RAM from  0000:0000 len ";
 PRINT REG (1);" Kbytes"               '! AX = Gre


'!
'! Prfe die Lage des Bildschirmadadapters auf Segment
'! A000H, B000H, B800H
'!
 DEF SEG = &HA000                      '! setze Segment
 IF (PEEK(0) <> &HFF) AND _            '! Bildschirm RAM ?
     (PEEK(1) <> &HFF) THEN
   PRINT "RAM from  A000:0000"         '! Segmentadr.
 END IF

 DEF SEG = &HB000                      '! setze Segment
 IF (PEEK(0) <> &HFF) AND _            '! Bildschirm RAM ?
     (PEEK(1) <> &HFF) THEN
   PRINT "RAM from  B000:0000"         '! Segmentadr.
 END IF


 DEF SEG = &HB800                      '! setze Segment
 IF (PEEK(0) <> &HFF) AND _            '! Bildschirm RAM ?
     (PEEK(1) <> &HFF) THEN
   PRINT "RAM from  B800:0000"         '! Segmentadr.
 END IF

'!
'! Prfe ab C000:0 in 32 Kbyte Schritten auf ROM's
'!

 FOR i& = &HC000 TO &HFFFF STEP &H800  '! teste ROM
  DEF SEG = i&                         '! setze Segment
  IF (PEEK(0) = &H55) AND _            '! ROM Signatur ?
     (PEEK(1) = &HAA) THEN
   PRINT "ROM from  "; HEX$(i&);":0000";'! Segmentadr.
   PRINT " len "; PEEK(2);             '! Kbytes
   PRINT " Kbyte"
  ELSEIF (PEEK(0) <> &HFF) AND _       '! ROM Signatur ?
     (PEEK(1) <> &HFF) THEN
   PRINT "ROM from  "; HEX$(i&);":0000" '! Segmentadr.
  END IF
 NEXT i&

END SUB

SUB freemem
'!---------------------------------------------------------
'! ermittle den freien Speicher
'!---------------------------------------------------------
SHARED start&
LOCAL frei&, ram&

 CALL INTERRUPT &H12                   '! BIOS: GET RAM SIZE

 ram& = REG(1)                         '! RAM Gre
 ram& = ram& * &H3FF
 frei& = ram& - (start& * 16)          '! berechne. freie Gre

 PRINT
 PRINT "MS-DOS Free Memory  : ";
 PRINT frei&;" Kbyte"                  '! freier Speicher
 PRINT "MS-DOS Used Memory  : ";
 PRINT start& * 16;" Kbyte"           '! belegter Speicher

END SUB

SUB progadr
'!---------------------------------------------------------
'! Ermittle die Anfangsadresse des Anwenderprogrammes
'! ber die undokumentierte Funktion 51H des INT 21.
'! Diese gibt im Register BX die Segmentadresse des
'! aktuellen PSP an. Dies ist gleichzeitig die Start-
'! adresse der Anwenderprogramme.
'!---------------------------------------------------------
 LOCAL res$
 SHARED start&

 REG 1, &H5100                         '! AX = 5100 -> read
                                       '! PSP Segm. Adr
 CALL INTERRUPT &H21                   '! Dispatcher INT

 IF (REG (0) AND &H01) > 0 THEN        '! Fehler ?
  PRINT "Fehler beim Systemaufruf "; REG (1) '! AX = Fehlercode
 ELSE
  PRINT "User Progr. Adresse : ";
  start& = REG(2)                      '! merke Adresse
  res$ = HEX$(REG(2))                  '! Segm. Adr in BX
  res$ = STRING$(4-LEN(res$),"0") + res$ '! fhrende Nullen
  PRINT res$;":0000"
 END IF

END SUB

SUB config
'!---------------------------------------------------------
'! lese die Konfiguration der Hardware ber den INT 11
'!---------------------------------------------------------
LOCAL ax%, drive%, bytes&, frei&, disp%, i% , tmp&
DIM a%(2)                             '! Hilfsvariable fr MOVE

 CALL INTERRUPT &H11                   '! Lese Konfiguration

 ax% = REG(1)                          '! Wert in ax%
 PRINT
 IF (ax% AND 1) = 0 THEN               '! Floppys ?
  PRINT "keine Diskettenlaufwerke gefunden "
 ELSE
  drive% = (ax% AND &HC0) / 64         '! Floppys -> b14, b15
  PRINT "Disks"; SPACE$(15);
  FOR i% = 0 TO drive%                 '! n Drives
   PRINT CHR$(&H41 + i%);": ";         '! Kennbuchstabe A: .. F:
  NEXT i%
 END IF
 PRINT
 PRINT

'!
'! ist eine Festplatte im System integriert ?
'! Platten befinden sich oberhalb der Floppys (C:, D:, etc.).
'! Prfe per INT 21, Funktion 1CH ob Platten vorhanden sind.
'!
 IF drive% < 2 THEN                    '! weniger als 1 Floppy?
  drive% = 3                           '! Platte ab c:
 ELSE
  INCR drive%                          '! oberhalb Floppy
 END IF

 FOR i% = drive% to drive% + 2         '! max. 3 Disks
  REG 1, &H3600                        '! Funktion 3600
  REG 4, i% AND &HFF                   '! Laufwerkscode
  CALL INTERRUPT &H21                  '! INT 21
  IF (REG(1) AND &HFF) <> &HFF THEN    '! Platte gefunden ?
   PRINT "Disk "; SPACE$(15); CHR$(&H40+i%);": ";
   tmp% = REG(4)                       '! Cluster

'!
'! Achtung: wegen I*2 ist eine Typkonvertierung erforderlich !!!!
'!
   a%(1) = VARPTR(tmp%)                '! Adr. Variable bergeben!!!
   a%(2) = VARSEG(tmp%)
   clust& = 0
   CALL MOVE (2,clust&,a%(1))

   bytes& = clust& * REG(3) * REG(1)
   PRINT bytes&;                      '! Speichergre
   PRINT " Bytes"
   PRINT "Sektoren pro Cluster : "; REG(1)
   PRINT "Bytes pro Sektor     : "; REG(3)
   PRINT "Cluster              : "; clust&

   tmp% = REG(2)                      '! freie Cluster
'!
'! Achtung: wegen I*2 ist eine Typkonvertierung erforderlich !!!!
'!
   a%(1) = VARPTR(tmp%)                '! Adr. Variable bergeben!!!
   a%(2) = VARSEG(tmp%)
   fclust& = 0
   CALL MOVE (2,fclust&,a%(1))

   frei& = fclust& * REG(3) * REG(1)
   PRINT "Freie Kapazitt      : "; frei&;    '! in Bytes
   PRINT USING "Bytes (##.#";(frei& * 100.0 / bytes&);
   PRINT " %)"                         '! in %
  END IF
 NEXT i%

'!
'! Anzeige weiterer Informationen aus dem BIOS Aufruf
'!

 PRINT
  disp% = (ax% AND &H30) / 16          '! Bildschirmadapter
  SELECT CASE disp%
   CASE 0
    PRINT "Illegal Display Mode"
   CASE 1
    PRINT "Colorcard 40 x 25 Monochrom"
   CASE 2
    PRINT "Colorcard 80 x 25 Monochrom"
   CASE 3
    PRINT "Monochromcard 80 x 25"
  END SELECT

 PRINT
 PRINT "Serial Interfaces   : "; (ax% AND &H0E00) / 512
 tmp& = (ax% AND &HC000) / &HFF / &H2F
 PRINT "Parallel Interfaces : "; tmp&

END SUB

SUB MOVE INLINE

$INLINE "MOVE.COM"

END SUB

'***** Programm Ende ******
