'!###################################################
'! File:    INT10.INC
'! Version: 1.0 v. 16.7.92 (c) G. Born
'!          Subroutinen zur Bildschirmsteuerung
'!###################################################

SUB SetMode (mode%)
'!----------------------------------------------------
'!  setze den Bildschirmmode
'!   mode% = 0  40 x 25 Zeichen Monochrom
'!           1  40 x 25 Zeichen Color
'!           2  80 x 25 Zeichen Monochrom
'!           3  80 x 25 Zeichen Color
'!           4  320 x 200 Pixel Color
'!           5  320 x 200 Pixel Monochrom
'!           6  640 x 200 Pixel Monochrom
'!----------------------------------------------------
 REG 1, 0 + (mode% AND &H0F)
 CALL INTERRUPT &H10
END SUB

SUB GetMode (mode%)
'!----------------------------------------------------
'!  lese den Bildschirmmode
'!   mode% = 0  40 x 25 Zeichen Monochrom
'!           1  40 x 25 Zeichen Color
'!           2  80 x 25 Zeichen Monochrom
'!           3  80 x 25 Zeichen Color
'!           4  320 x 200 Pixel Color
'!           5  320 x 200 Pixel Monochrom
'!           6  640 x 200 Pixel Monochrom
'!----------------------------------------------------
 REG 1, &H0F00
 CALL INTERRUPT &H10
 mode% = REG (1) AND &H0F
END SUB

SUB CursorSize (ymin%,ymax%)
'!----------------------------------------------------
'!  stelle die Cursorgre ein
'!----------------------------------------------------
 REG 1,&H0100
 REG 3, (ymax% AND &H0F)*16 + (ymin% AND &H0F)
 CALL INTERRUPT &H10
END SUB

SUB SetCursor (xpos%, ypos%)
'!----------------------------------------------------
'!  setze den Cursor auf Bildschirmseite 0
'!----------------------------------------------------
 REG 1,&H0200
 REG 2,0
 REG 4, ((ypos%+1) AND &HFF) * 256 + ((xpos%+1) AND &HFF)
 CALL INTERRUPT &H10
END SUB

SUB GetCursor (xpos%, ypos%)
'!----------------------------------------------------
'!  lese die Cursorposition auf Bildschirmseite 0
'!----------------------------------------------------
 REG 1,&H0300
 REG 2,0
 CALL INTERRUPT &H10
 xpos% = (REG (4) AND &HFF) + 1
 ypos% = ((REG (4) AND &HFF) / 256) + 1
END SUB

SUB Scroll (x1%, y1%, x2%, y2%, lines%, attribut%)
'!----------------------------------------------------
'!  up-/downscroll des Fensters um n lines
'!  x%, y%  = Koordinaten Fenster
'!  lines%  = Zahl der zu scrollenden Zeilen
'!            negativ -> upscroll, sonst downscroll
'!  attribut%= Attribut der neuen Zeile
'!             Bit 7 = Blinkbit
'!                 3 = Intensittsbit
'!               4-6 = Hintergrundfarbe
'!               0-2 = Vordergrundfarbe
'!----------------------------------------------------

 IF lines% < 0 THEN                   '! scroll up
  REG 1,&H0600 + (-lines% AND &HFF)   '! Zahl der Zeilen
 ELSE                                 '! scroll down
  REG 1,&H0700 + (lines% AND &HFF)    '! Zahl der Zeilen
 END IF

 REG 3, (y1%-1 AND &HFF)*256  + (x1%-1 AND &HFF) '! Window
 REG 4, (y2%-1 AND &HFF)*256  + (x2%-1 AND &HFF) '! Window
 REG 2, (attribut% AND &HFF)

 CALL INTERRUPT &H10
END SUB

'! ENDE
