' *********************************************************
' File       : LISTER.BAS
' Vers.      : 1.0
' Last Edit  : 20. 4.92
' Autor      : G. Born
' File I/O   : INPUT, OUTPUT, FILE, PRINTER
' Progr. Spr.: POWER BASIC
' Betr. Sys. : DOS 2.1 - 5.0
' Funktion: Das Programm dient zur Ausgabe von Listings mit
'           Seitennummern, Datum, Dateinamen und einer whl-
'           baren Zeilennumerierung. Weiterhin wird nach n
'           Zeilen ein Papiervorschub auf dem Drucker ausge-
'           lst. Es lassen sich beliebige Textdateien mit
'           diesem Programm ausgeben.
'
' Aufruf:   LISTER Filename /Optionen
'           Optionen:  /N   Zeilennumerierung ein  [Aus]
'                      /Lxx linker Rand            [ 0 ]
'                      /Rxx rechter Rand           [75 ]
'                      /Zxx Zeilen pro Seite       [60 ]
'
'           Die Werte in [] geben die Standardeinstellung
'           wieder. Wird das Programm ohne Parameter aufge-
'           rufen, sind Dateiname und Optionen explizit ab-
'           zufragen. Mit dem Aufruf:
'
'              LISTER /?
'
'           wird ein Hilfsbildschirm ausgegeben.
' **********************************************************
' Variable definieren
%on = 1: %off = 0
nummer% = %off                        '! keine Zeilennummern
zeile& = 0                            '! Zeilennummer Listing
seite% = 1                            '! Seitennummer Listing
maxzeile% = 60                        '! Zeilen pro Seite
rechts% = 75                          '! rechter Rand
links% = 0                            '! linker Rand
spalte% = 0                           '! Einrckung

datei% = 2                            '! Dateinummer

ON ERROR GOTO fehler                  '! Fehlerausgang

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! User Mode ?
 CLS                                  '! clear Screen

 PRINT "L I S T E R                            (c) Born Version 1.0"
 PRINT
 PRINT "Optionen [ /L=00 linker Rand         /R=75  rechter Rand   ]"
 PRINT "         [ /Z=60 Zeilen pro Seite    /N  Zeilennumerierung ]"
 PRINT
 INPUT  "File     : ",filename$
 INPUT  "Optionen : ",options$
 PRINT
ELSE
 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "L I S T E R                  (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: LISTER <Filename> <Optionen>"
  PRINT
  PRINT "Optionen :"
  PRINT
  PRINT "  /L=00 setzt den linken Rand"
  PRINT "  /R=75 setzt den rechten Rand"
  PRINT "  /Z=60 setzt die Zeilenzahl pro Seite"
  PRINT "  /N    schaltet die Zeilennumerierung ein"
  PRINT
  PRINT "Das Programm gibt ein Listing der Datei aus, wobei sich"
  PRINT "die Rnder und die Zahl der Zeilen einstellen lt."
  PRINT
  SYSTEM
 END IF
				      '! Kommando Mode
 ptr% = INSTR (kommando$,"/")         '! Optionen ?
 IF ptr% = 0 THEN
  filename$ = kommando$               '! nur Filename
 ELSE
  filename$ = LEFT$(kommando$,ptr% -1)'! Filename separieren
  options$  = MID$(kommando$,ptr%)    '! Optionen separieren
 END IF
END IF

GOSUB parameter                       '! Optionen decodieren

IF (rechts% < links%) or (maxzeile% < 10) THEN '! sinnlose
 PRINT                                         '! Einstellung
 PRINT "Bitte Randeinstellung neu setzen"      '! Fehlerexit
 SYSTEM
END IF

IF filename$ = "" THEN                '! Leereingabe ?
 PRINT
 PRINT "Der Dateiname fehlt"
 SYSTEM
END IF

' prfe ob Datei vorhanden, nein -> exit

OPEN filename$ FOR INPUT AS #datei%
PRINT
PRINT "Die Datei: ";filename$;" wird auf dem Drucker ausgegeben "

GOSUB pageskip                        '! Seitenkopf ausgeben

WHILE NOT (EOF(datei%))               '! datei sequentiell lesen
 LINE INPUT #datei%, linie$           '! lese Zeile
 GOSUB ausgabe                        '! drucke Zeile
WEND

LPRINT CHR$(12)                       '! Seitenvorschub
CLOSE #datei%                         '! Datei schlieen
PRINT
PRINT "Ausgabe beendet"
END

'#########################################################
'#                   Hilfsroutinen                       #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in LISTER
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";filename$;" existiert nicht"
ELSE
 IF ERR = 27 THEN
  INPUT "Druckerstrung, bitte eine Taste bettigen...";t$
 ELSE
  PRINT "Fehler : ";ERR;" unbekannt"
  PRINT "Programmabbruch"
 END IF
END IF
END                                   '! MSDOS Exit

parameter:
'---------------------------------------------------------
'! Decodiere die Eingabeoptionen
'---------------------------------------------------------
ptr% = INSTR (options$,"/N")
IF ptr% > 0 THEN nummer% = %on        '! Zeilennumerierung EIN

ptr% = INSTR (options$,"/Z=")
IF ptr% > 0 THEN CALL getval (maxzeile%) '! Zeilen / Seite
szeile% = maxzeile% + 1               '! Zeilennr Seite wechseln

ptr% = INSTR (options$,"/L=")
IF ptr% > 0 THEN CALL getval (links%) '! linker Rand

ptr% = INSTR (options$,"/R=")
IF ptr% > 0 THEN CALL getval (rechts%) '! rechter Rand

RETURN

SUB getval (wert%)
'---------------------------------------------------------
'! Decodiere den Eingabestring in eine Zahl
'---------------------------------------------------------
 SHARED options$, ptr%
 LOCAL i%

 ptr% = ptr% + 3                      '! ptr hinter /x=
 i% = 1
 WHILE ((ptr%+i%) =< LEN (options$)) and (MID$(options$,ptr%+i%,1) <> " ")
  i% = i% + 1                         '! Ziffernzahl + 1
 WEND
 wert% = VAL(MID$(options$,ptr%,i%))  '! decodiere die Zahl
END SUB

pageskip:
'---------------------------------------------------------
'! Seitenvorschub mit Kopf (Dateiname, Datum, Seite)
'---------------------------------------------------------
 IF szeile% =< maxzeile% THEN RETURN  '! kein Seitenwechsel !!

 IF seite% > 1 THEN                   '! 1. Seite k. Vorschub
  LPRINT CHR$(12)                     '! Vorschub
  szeile% = 3                         '! Kopf 3 Zeilen
 ELSE
  LPRINT "LISTER "; options$; SPACE$(27);
  LPRINT "(c) Born Version 1.0"
  szeile% = 4                         '! Kopf 1. Seite = 4 Zeilen
 END IF
 LPRINT "Datei : ";filename$;"     Datum : ";DATE$;
 LPRINT "          Seite : "; seite%
 LPRINT
 INCR seite%                          '! Seite erhhen

RETURN


ausgabe:
'--------------------------------------------------------
'! Ausgabe der eingelesenen Zeile auf dem Printer.
'! rest% gibt an, wieviele Zeichen pro Zeile gedruckt
'! werden drfen. Ist die eingelesene Zeile lnger, wird
'! sie auf mehrere Ausgabezeilen aufgeteilt.
'--------------------------------------------------------

 zeile& = zeile& + 1                  '! Zeile im Listing
 GOSUB pageskip                       '! Seitenvorschub ?

 spalte% = links%                     '! linker Rand
 LPRINT SPACE$(spalte%);              '! auf linken Rand

 IF nummer% = %on THEN                '! Zeilennumerierung ?
  LPRINT USING "###### "; zeile&;     '! Zeilennummer drucken
  spalte% = spalte% + 7               '! Spalte 7 setzen
 END IF

 rest% = rechts% - spalte%            '! Restzeilenlnge
 GOSUB skipblank                      '! merke Blanks
 LPRINT LEFT$(linie$,rest%)           '! Ausgabe Teilstring
 linie$ = MID$(linie$, rest% + 1)     '! Reststring
 szeile% = szeile% + 1

 WHILE LEN(linie$) > rest%            '! String > Zeile
  GOSUB pageskip                      '! Seitenvorschub ?
  LPRINT SPACE$(spalte%);             '! linker Rand
  LPRINT LEFT$(linie$,rest%)          '! Teilstring ausgeben
  linie$ = MID$(linie$,rest% + 1)     '! Reststring bestimmen
  szeile% = szeile% + 1               '! Zeile im Listing
 WEND

 IF LEN(linie$) > 0 THEN
  GOSUB pageskip                      '! Seitenvorschub ?
  LPRINT SPACE$(spalte%);linie$       '! Reststring ausgeben
  szeile% = szeile% + 1
 END IF
RETURN

skipblank:
'---------------------------------------------------------
'! zhle fhrende Blanks
'---------------------------------------------------------
i% = 1
WHILE (i% < LEN(linie$)) and (MID$(linie$,i%,1) = " ")
 i% = i%+1
 spalte% = spalte% + 1
WEND
RETURN
' ###### Programm Ende #########
END
