'!###################################################
'! File:    MENU.INC
'! Version: 1.0 v. 10.7.92 (c) G. Born
'!          Subroutinen zur Mensteuerung
'!          Pull Down und Pop Up
'!###################################################

SUB MenuInit (screenseg%)
'!----------------------------------------------------
'!  Subroutine zur Initialisierung der Variablen
'!----------------------------------------------------

SHARED xmax%, ymax%, initflg%, scrseg%

 scrseg% = screenseg%                '! Seg. Adr. Adapter
				     '! B800H oder B000H
 xmax% = 80                          '! rechter Bildrand
 ymax% = 25                          '! unterer Bildrand

 initflg% = 1                        '! Init ok

END SUB

SUB MenuLine (lo$,lu$,ro$,ru$,li$,lup$,style%)
'!----------------------------------------------------
'!  Subroutine zur Einstellung des Rahmentyps
'!----------------------------------------------------

 SELECT CASE style%
  CASE = 1                            '! Linientyp 1
   lo$ = ""                          '! Ecke links oben
   lu$ = ""                          '! Ecke links unten
   ro$ = ""                          '! Ecke rechts oben
   ru$ = ""                          '! Ecke rechts unten
   li$ = ""                          '! Linie waagerecht
   lup$ = ""                         '! Linie senkrecht
  CASE = 2
   lo$ = ""                       '! Linientyp 2
   lu$ = ""
   ro$ = ""
   ru$ = ""
   li$ = ""
   lup$ = ""
  CASE ELSE
   lo$ = " "                       '! Linientyp 3
   lu$ = " "
   ro$ = " "
   ru$ = " "
   li$ = " "
   lup$ = " "
  END SELECT

END SUB

SUB PopMenu (x%, y%, text$(1), items%, fcol%, bcol%, title$, foot$, style%, status%, nr%)
'!----------------------------------------------------
'!  Subroutine fr PopUp-Men
'!
'!  Die Routine gibt die Menbox mit dem Text aus.
'!
'! x%, y%   Anfangskoordinaten linke obere Ecke
'! text$()  Texte mit Menpunkten
'! items%   Zahl der Menpunkte
'! title$   Text Kopfzeile
'! foot$    Text Fuzeile
'! style%   Rahmentyp (1 = einfach, 2 = doppelt, sonst blank
'! fcol%    Vordergrundfarbe
'! bcol%    Hintergrundfarbe
'! status%  vor Aufruf:
'!           0 kein Exit bei Cursor rechts/links 
'!           1 Exit bei Cursor rechts/links 
'!          Ergebnis des Aufrufes:
'!          -2 Fehler: Initialisierung fehlt
'!          -1 Fehler: Box pat nicht auf Bildschirm
'!           0 ok, Men mit RETURN beendet
'!           1 ok, Men mit ESC beendet
'!           2 ok, Men mit Cursor Rechts beendet
'!           3 ok, Men mit Cursor Links beendet
'! nr%      Aufruf: vorselektierter Menpunkt
'!          Return: Nummer des selektierten Menpunktes
'!----------------------------------------------------

LOCAL maxlen%, i%, zchn$, zeile%, old%, flag%
LOCAL lo$, lu$, ro$, ru$, li$, lup$
SHARED xmax%, ymax%, initflg%

flag% = status%                              '! merke status

'! prfe ob INIT durchgefhrt

 IF initflg% <> 1 THEN
  status% = -2
  EXIT SUB
 END IF

'! Emittle Lnge des Menpunktes

 CALL GetMaxLen (text$(),items%, title$, foot$, maxlen%)

'! Pat das Men auf den Bildschirm ?

 IF (x% + maxlen% + 2) > xmax% THEN
  status% = -1
  EXIT SUB
 END IF

 IF (y% + items% + 2) > ymax% THEN
  status% = -1
  EXIT SUB
 END IF

'! Rahmentyp setzen

 CALL MenuLine(lo$,lu$,ro$,ru$,li$,lup$,style%)

'! Rahmen zeichnen

 COLOR fcol%,bcol%
 LOCATE y%, x%                     '! linke obere Ecke
 PRINT lo$;
 IF (LEN(title$) > 0) THEN
  PRINT title$;                    '! Titel Textbox
 END IF
 IF LEN(title$) < maxlen% THEN
  FOR i% = LEN(title$) TO maxlen%-1 : PRINT li$; : NEXT i%
 END IF
 PRINT ro$

 FOR i% = 1 TO items%
  LOCATE (y%+i%), x%
  PRINT lup$;
  CALL PutLine (text$(i%),maxlen%)
  PRINT lup$
 NEXT i%

 LOCATE (y%+items%+1), x%
 PRINT lu$;
 IF (LEN(foot$) > 0) THEN
  PRINT foot$;                       '! Futext
 END IF
 IF LEN(foot$) < maxlen% THEN
  FOR i% = LEN(foot$) TO maxlen%-1 : PRINT li$; : NEXT i%
 END IF
 PRINT ru$

'! Init Variable fr Selection
'! ermittle die Position der invertierten Zeile
'! diese kann in nr% vorgegeben werden (1 - items%)

 old% = items%                      '! letzte Zeile

 IF (nr% < 1) OR (nr% > items%) THEN '!
  zeile% = 1                        '! 1. Menpunkt
 ELSE
  zeile% = nr%                      '! vorgebener Punkt
  IF nr% = items% THEN old% = 1
 END IF

 zchn$ = CHR$(0)                    '! Init Puffer

'! decodiere Benutzerauswahl
'! Warte bis CR oder ESC bettigt wurde
 loopx% = 0
 WHILE (loopx% = 0)

'! prfe ob sich die Cursorauswahl gegenber dem letzten Durchlauf
'! verndert hat. Markiere betreffende Auswahlzeile des Mens durch
'! inverse Textdarstellung

  IF zeile% <> old% THEN             '! nderung
   LOCATE (y%+old%), (x%+1)          '! Cursor auf alte Zeile
   COLOR fcol%,bcol%                 '! normal darstellen
   CALL PutLine(text$(old%),maxlen%) '! schreiben
   LOCATE (y%+zeile%), (x%+1)        '! Cursor auf neue Zeile
   COLOR bcol%,fcol%                 '! invers darstellen
   CALL PutLine(text$(zeile%),maxlen%) '! schreiben
  END IF

'! lese Tastatur aus und decodiere ggf. die Tastencodes

   zchn$ = INKEY$                    '! lese Tastencodes
   IF LEN(zchn$) = 2 THEN            '! Extended ASCII-Code
    zchn$ = RIGHT$(zchn$,1)          '! entferne  1. Zeichen
    SELECT CASE zchn$
     CASE = CHR$(72)                 '! Cursor UP
      old% = zeile%                  '! merke Zeile
      zeile% = zeile% - 1            '! neue Position
      IF zeile% = 0 THEN zeile% = items% '! wrap
     CASE = CHR$(80)                 '! Cursor DOWN
      old% = zeile%                  '! merke Zeile
      zeile% = zeile% + 1            '! neue Position
      IF zeile% > items% THEN zeile% = 1 '! wrap
     CASE = CHR$(75)                 '! Cursor RIGHT
      status% = 2                    '! Exitcode
      IF flag% = 1 THEN loopx% = 1   '! Exit
     CASE = CHR$(77)                 '! Cursor LEFT
      status% = 3
      IF flag% = 1 THEN loopx% = 1   '! Exit
     END SELECT
   ELSE
    SELECT CASE zchn$
     CASE = CHR$(13)                 '! Return
      status%=0                      '! Exitcode CR
      loopx% = 1
     CASE = CHR$(27)
      status%=1                      '! Exitcode ESC
      loopx% = 1
     END SELECT
   END IF
 WEND

 nr% = zeile%                          '! gebe Auswahlcode zurck

END SUB

SUB GetMaxLen (text$(1),items%,title$,foot$,maxlen%)
'!----------------------------------------------------
'!  Subroutine zur Ermittlung der Breite der Box
'!
'!----------------------------------------------------

 LOCAL i%

'! Ermittle die Lnge des grten Menpunktes

 maxlen% = 0
 FOR i% = 1 TO items%
  IF (LEN(text$(i%)) > maxlen%) THEN
   maxlen% = LEN(text$(i%))
  END IF
 NEXT i%

'! Ist die Titellnge > als maxlen?
 IF (LEN(title$) > maxlen%) THEN
  maxlen% = LEN(title$)
 END IF

'! Ist die Fulnge > als maxlen?
 IF (LEN(foot$) > maxlen%) THEN
  maxlen% = LEN(foot$)
 END IF

END SUB

SUB PutLine (text$,xlen%)
'!----------------------------------------------------
'!  Subroutine zur Ausgabe einer Menzeile
'!
'!  Die Routine gibt den text$ der Lnge xlen% in der
'!  gesetzten Farbe in der Menbox aus.
'!----------------------------------------------------

 LOCAL i%

 PRINT text$;                       '! Original Text ausgeben
 FOR i% = 1 TO xlen%-LEN(text$)     '! mit Blanks auffllen
  PRINT " ";
 NEXT i%

END SUB

SUB OpenBox (x%, y%, text$(1), items%, title$, foot$, buff%(1))
'!----------------------------------------------------
'!  Subroutine zur Sicherung des Bildschirmausschnittes
'!  unter der Menbox. (Variable siehe PopMenu)
'!----------------------------------------------------

 SHARED scrseg%                    '! Seg. Adr. Screen
 LOCAL maxlen%

'! ermittle Lnge des Menpunktes

 CALL GetMaxLen (text$(),items%, title$, foot$, maxlen%)
 maxlen% = maxlen% + 2            '! wegen Rahmen

'! sichere Bildschirmausschnitt

 CALL SaveArea (x%, y%, maxlen%,items%+2, buff%())

END SUB

SUB SaveArea (x%, y%, breite%, hohe%, buff%(1))
'!----------------------------------------------------
'!  Subroutine zur Sicherung eines Bildschirmausschnittes
'!  ab Punkt x,y mit den Abmessungen breite x hohe in
'!  buff().
'!----------------------------------------------------

 SHARED scrseg%                    '! Seg. Adr. Screen
 LOCAL i%, j%, ptr%, ofs%

'! sichere die Parameter des Bildausschnitts im Buffer

 buff%(1) = x%
 buff%(2) = y%
 buff%(3) = breite%
 buff%(4) = hohe%

'! sichere den Bildschirmbereich

 DEF SEG = scrseg%                  '! Screen Segment
 ptr% = 5                           '! Beginn Screen-Puffer
 FOR i% = 1 TO hohe%                '! alle Zeilen
  ofs% = ((y%+i%-2)*80 + (x%-1))*2  '! Anfangsadresse
  FOR j% = 0 TO breite%             '! alle Spalten
   buff%(ptr%) = PEEKI(ofs%+j%*2)
   ptr% = ptr% + 1
  NEXT j%
 NEXT i%
 DEF SEG
END SUB

SUB CloseBox (buff%(1))
'!----------------------------------------------------
'!  Subroutine zur Restaurierung des Bildschirmausschnittes
'!  unter der Menbox.
'!----------------------------------------------------

 SHARED scrseg%                    '! Seg. Adr. Screen
 LOCAL i%, j%, ptr%, ofs%, x%, y%, hohe%, breite%

'! lese Parameter des Ausschnittes

 x% = buff%(1)
 y% = buff%(2)
 breite% = buff%(3)
 hohe%   = buff%(4)

 DEF SEG = scrseg%                 '! Screen Segment
 ptr% = 5
 FOR i% = 1 TO hohe%
  ofs% = ((y%+i%-2)*80 + (x%-1))*2
  FOR j% = 0 TO breite%
   POKEI (ofs%+j%*2),buff%(ptr%)
   ptr% = ptr% + 1
  NEXT j%
 NEXT i%
 DEF SEG
END SUB

SUB PullMenu (text$(1), items%, fcol%, bcol%, xpos%(1), status%, nr%)
'!----------------------------------------------------
'!  Subroutine fr PullDown-Men
'!
'!  Die Routine gibt die Menzeile mit dem Text aus.
'!
'! text$()  Texte mit Menpunkten
'! items%() Zahl der Punkt in der Menzeile
'! fcol%    Vordergrundfarbe
'! bcol%    Hintergrundfarbe
'! xpos%()  x-Koordinate Menpunkt
'! status%  vor Aufruf
'!           1 Exit bei Cursor rechts/links
'!           0 kein Exit bei Cursor rechts links
'!          Ergebnis des Aufrufes
'!          -2 Fehler: Initialisierung fehlt
'!          -1 Fehler: Zeile pat nicht auf Bildschirm
'!           0 ok, Men mit RETURN beendet
'!           1 ok, Men mit ESC beendet
'!           2 ok, Men mit Cursor Rechts beendet
'!           3 ok, Men mit Cursor Links beendet
'! nr%      vor Aufruf Position invert. Menpunkt
'!          nach Aufruf:
'!          Nummer des selektierten Menpunktes
'!----------------------------------------------------

LOCAL maxlen%, i%, zchn$, spalte%, old%, tmp%
LOCAL loopx%, flag%, leer$
SHARED xmax%, ymax%, initflg%

 flag% = status%                     '! merke Flag

'! prfe ob INIT durchgefhrt

 IF initflg% <> 1 THEN
  status% = -2
  EXIT SUB
 END IF

'! Pat die Menzeile auf den Bildschirm ?

 tmp% = 1                              '! 1. Leerzeichen
 FOR i% = 1 TO items%
  tmp% = tmp% + LEN(text$(i%)) + 1
 NEXT i%

 IF ptr% > xmax% THEN
  status% = -1
  EXIT SUB
 END IF

'! ermittle ob Zwischenraum vergrert werden kann
 leer$ = " "                           '! 1 Leerzeichen
 IF tmp%+items% < xmax% THEN
  tmp% = (xmax%-tmp%) / items%
  IF tmp% > 8 THEN tmp% = 8            '! max 8 Blanks
  leer$ = SPACE$(tmp%)                 '! n Leerzeichen
 END IF

'! gebe Menzeile mit Hauptpunkten aus
 spalte% = nr%
 IF spalte% < 1 THEN spalte% = 1
 IF spalte% > items% THEN spalte% = items%

 LOCATE 1,1
 COLOR fcol%,bcol%                  '! normal darstellen
 PRINT " ";                         '! Leerzeichen
 FOR i% = 1 TO items%
  xpos%(i%) = POS (x)               '! merke x-pos Menpunkt
  IF i% = spalte% THEN
   COLOR bcol%,fcol%                '! invers darstellen
  ELSE
   COLOR fcol%,bcol%                '! normal darstellen
  END IF
  PRINT text$(i%);leer$;            '! Menpunkt ausgeben
 NEXT i%

 COLOR fcol%,bcol%                  '! normal darstellen
 DO WHILE POS(x) < xmax%            '! Rest mit Blanks fllen
  PRINT " ";
 WEND
  PRINT " ";

'! Init Variable fr Selection
'! ermittle die Position der invertierten Zeile
'! diese kann in nr% vorgegeben werden (1 - items%)

 old% = items%                      '! letzte Spalte

 IF (nr% < 1) OR (nr% > items%) THEN '!
  spalte% = 1                       '! 1. Menpunkt
 ELSE
  spalte% = nr%                     '! vorgebener Punkt
  IF nr% = items% THEN old% = 1
 END IF

'! decodiere Benutzerauswahl
'! Warte bis CR, ESC, oder CurR/CurL bettigt wurde

 loopx% = 0

 WHILE (loopx% = 0)

'! lese Tastatur aus und decodiere ggf. die Tastencodes

  zchn$ = INKEY$                    '! lese Tastencodes
  IF LEN(zchn$) = 2 THEN            '! Extended ASCII-Code
   zchn$ = RIGHT$(zchn$,1)          '! entferne  1. Zeichen
   SELECT CASE zchn$
    CASE = CHR$(80)                 '! Cursor DOWN (unbelegt)
     status% = 3                    '! Exitcode
     IF flag% = 1 THEN loopx% = 1   '! Exit
    CASE = CHR$(77)                 '! Cursor RIGHT
     old% = spalte%                 '! merke Zeile
     spalte% = spalte% + 1          '! neue Position
     IF spalte% > items% THEN spalte% = 1 '! wrap
     status% = 2                    '! Exitcode
    CASE = CHR$(75)                 '! Cursor LEFT
     old% = spalte%                 '! merke Zeile
     spalte% = spalte% - 1          '! neue Position
     IF spalte% = 0 THEN spalte% = items% '! wrap
     status% = 3
    END SELECT
   ELSE
    SELECT CASE zchn$
     CASE = CHR$(13)                 '! Return
      status%=0                      '! Exitcode CR
      loopx% = 1
     CASE = CHR$(27)
      status%=1                      '! Exitcode ESC
      loopx% = 1
     END SELECT
   END IF

'! prfe ob sich die Cursorauswahl gegenber dem letzten Durchlauf
'! verndert hat. Markiere betreffende Auswahlzeile des Mens durch
'! inverse Textdarstellung

  LOCATE 1,2                         '! Text neu ausgeben
  FOR i% = 1 TO items%
   IF i% = spalte% THEN
    COLOR bcol%,fcol%                '! invers darstellen
   ELSE
    COLOR fcol%,bcol%                '! normal darstellen
   END IF
   PRINT text$(i%);leer$;            '! Menpunkt ausgeben
  NEXT i%
  COLOR fcol%,bcol%                  '! normal darstellen

 WEND

 nr% = spalte%                          '! gebe Auswahlcode zurck

END SUB

'! Ende INC-File
