'!###################################################
'! File:    MOUSE.INC
'! Version: 1.0 v. 10.7.92 (c) G. Born
'!          Subroutinen zur Maussteuerung
'!###################################################

SUB MouseInit (status%)
'!----------------------------------------------------
'!  Initialisierung der Maus
'!  status% = 0 -> ok, 1 -> keine Maus
'!----------------------------------------------------
 REG 1,0
 CALL INTERRUPT &H33
 status% = 0
 IF REG(1) <> -1 THEN status% = 1
END SUB

SUB ShowCursor
'!----------------------------------------------------
'!  mache Mauscursor sichtbar
'!----------------------------------------------------
 REG 1,1
 CALL INTERRUPT &H33
END SUB

SUB HideCursor
'!----------------------------------------------------
'!  mache Mauscursor unsichtbar
'!----------------------------------------------------
 REG 1,2
 CALL INTERRUPT &H33
END SUB

SUB GetPara (x%, y%, button%)
'!----------------------------------------------------
'!  lese Mausstatus
'!  x%, y%  = Koordinate Mauszeiger
'!  button% = Tastenstatus
'!              Bit 0 = 1 linke Taste gedrckt
'!              Bit 1 = 1 rechte Taste gedrckt
'!              Bit 2 = 1 mittlere Taste gedrckt
'!----------------------------------------------------
 REG 1,3
 CALL INTERRUPT &H33
 x% = REG(3)
 y% = REG(4)
 button% = REG(2)
END SUB

Def FN XPos%
'!----------------------------------------------------
'!  lese X-Position Mauscursor
'!----------------------------------------------------
 REG 1,3
 CALL INTERRUPT &H33
 FN XPos% = REG(3)
END DEF

Def FN YPos%
'!----------------------------------------------------
'!  lese Y-Position Mauscursor
'!----------------------------------------------------
 REG 1,3
 CALL INTERRUPT &H33
 FN YPos% = REG(4)
END DEF

Def FN Button%
'!----------------------------------------------------
'!  Mausknopf gedrckt?
'!  Wert > 0 ja, Bitcodierung wie GetParam
'!  Bit 0 = links, Bit 1 = rechts, Bit 2 = Mitte 
'!----------------------------------------------------
 REG 1,3
 CALL INTERRUPT &H33
 Button% = REG(2)
END DEF

SUB SetXY (x%, y%)
'!----------------------------------------------------
'!  setze Mausposition
'!  x%, y%  = Koordinate Mauszeiger
'!----------------------------------------------------
 REG 1,4
 REG 3,x%
 REG 4,y%
 CALL INTERRUPT &H33
END SUB

SUB SetXRange (xmin%, xmax%)
'!----------------------------------------------------
'!  setze Mausintervall xmin .. xmax
'!----------------------------------------------------
 REG 1,7
 REG 2,0
 REG 3,xmin%
 REG 4,xmax%
 CALL INTERRUPT &H33
END SUB

SUB SetYRange (ymin%, ymax%)
'!----------------------------------------------------
'!  setze Mausintervall ymin .. ymax
'!----------------------------------------------------
 REG 1,8
 REG 2,0
 REG 3,ymin%
 REG 4,ymax%
 CALL INTERRUPT &H33
END SUB


SUB PenEmul (switch%)
'!----------------------------------------------------
'!  schalte Light Pen Emulation:
'!  switch% = 0 -> aus,  = 1 -> ein
'!----------------------------------------------------

 IF switch% = 0 THEN
  REG 1,&H0E              '! aus
 ELSE
  REG 1,&H0D              '! on
 END IF
 CALL INTERRUPT &H33
END SUB

SUB SetTCursor (ymin%, ymax%)
'!----------------------------------------------------
'!  setze Gre des Mauscursors im Textmode xmin .. xmax
'!----------------------------------------------------
 REG 1,10
 REG 2,1
 REG 3,xmin%
 REG 4,xmax%
 CALL INTERRUPT &H33
END SUB

'! ENDE 
