'*********************************************************
'! File       : PASTE.BAS
'! Vers.      : 1.0
'! Last Edit  : 6. 5.92
'! Autor      : G. Born
'! Files      : INPUT, OUTPUT
'! Progr. Spr.: POWER Basic
'! Betr. Sys. : DOS 2.1 - 5.0
'! Funktion: Das Programm liest zwei Textdateien ein und
'!           kombiniert diese zeilenweise, so da aus je-
'!           weils den zwei Einzelstzen ein Satz wird.
'!           Das Ergebnis wird in einer Ausgabedatei abge-
'!           legt. Es sind folgende Aufrufe mglich:
'!
'! Aufruf:   PASTE                            '! Interaktiv Mode
'!           PASTE <datei1> <datei2> <datei3> '! Kommando Mode
'**********************************************************
'! Variable definieren
%true = &HFFFF: %false = 0            '! Konstante
ein1% = 1 : ein2% = 2 :  aus% = 3     '! Kanle fr I/O
inlinie1$ = ""                        '! Puffer Lesedatei 1
inlinie2$ = ""                        '! Puffer Lesedatei 2
trace% = %false                       '! Trace Mode aus
skip% = 0                             '! Zeilen berlesen
ptr% = 0: hilf% = 0                   '! Hilfszeiger
delimiter$ = ""                       '! Trennzeichen

'ON ERROR GOTO fehler

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! Interaktiv Mode ?
 CLS                                  '! ja -> Clear Screen
'! #####   Kopf ausgeben  ######
 PRINT "P A S T E                          (c) Born Version 1.0"
 PRINT
 PRINT "Optionen : [ /S=xx    Skip n Lines in File 1    ]"
 PRINT "           [ /D=xx    Delimiter   /T Trace ON   ]"
 PRINT
 INPUT "Eingabedatei 1 : ",infilename1$ '! lese Dateiname Eingabe 1
 INPUT "Eingabedatei 2 : ",infilename2$ '! lese Dateiname Eingabe 2
 INPUT "Ausgabedatei   : ",outfilename$ '! lese Dateiname Ausgabe
 INPUT "Optionen       : ",options$     '! lese Optionen
 PRINT
ELSE              '! Kommando Mode
 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "P A S T E                          (c) Born Version 1.0"
  PRINT
  PRINT "Optionen : [ /S=xx    Skip n Lines in File 1    ]"
  PRINT "           [ /D=xx    Delimiter   /T Trace ON   ]"
  PRINT
  PRINT "Das Programm liest zwei Eingabedateien und kombiniert"
  PRINT "die Texte zeilenweise in eine Ausgabedatei. Optionen:"
  PRINT
  PRINT "/S=xx  berliest n Zeilen in File 1 bis File 2 angehngt wird"
  PRINT "/D=xx  definiert den Delimiter, der die Teilstze trennt"
  PRINT "/T     schaltet den Trace-Modus ein"
  PRINT
  SYSTEM
 END IF
'!
'! getfile separiert den Dateinamen aus der Kommandozeile
'!
 kommando$ = UCASE$(kommando$)          '! in Grobuchstaben
 ptr% = 1                               '! Parameter holen
 CALL getfile(ptr%, kommando$,infilename1$)'! Name Eingabedatei1
 INCR ptr%                                 '! Anfang next token
 CALL getfile(ptr%, kommando$,infilename2$)'! Name Eingabedatei2
 INCR ptr%                                 '! Anfang next token
 CALL getfile(ptr%, kommando$,outfilename$)'! Name Ausgabedatei
 hilf% = INSTR(kommando$,"/")           '! suche Optionen
 IF hilf% >= ptr% THEN                  '! gefunden ?
  options$ = MID$(kommando$,hilf%)      '! Reststring mit Optionen
 END IF
END IF

IF infilename1$ = "" THEN              '! Leereingabe ?
 PRINT "Der Name der Eingabedatei 1 fehlt"
 END
END IF

IF infilename2$ = "" THEN              '! Leereingabe ?
 PRINT "Der Name der Eingabedatei 2 fehlt"
 END
END IF

IF outfilename$ = "" THEN              '! Leereingabe ?
 PRINT "Der Name der Ausgabedatei fehlt"
 END
END IF


OPEN infilename1$ FOR INPUT AS #ein1% '! ffne Eingabedatei
OPEN infilename2$ FOR INPUT AS #ein2% '! ffne Eingabedatei
'! Ausgabedatei vorhanden -> prfe ber OPEN inputdatei

ON ERROR GOTO ok
OPEN outfilename$ FOR INPUT AS #aus% '! existiert Ausgabedatei%
ON ERROR GOTO fehler
CLOSE #aus%                          '! nein -> Close

INPUT "Ausgabedatei existiert bereits, berschreiben (J/N) ? ", tmp$
PRINT
IF UCASE$(tmp$) <> "J" THEN END      '! stopp -> sonst Datei weg

ok:
OPEN outfilename$ FOR OUTPUT AS #aus% '! Ausgabedatei open

options$ = UCASE$(options$)           '! in Grobuchstaben
GOSUB getswitch                       '! lese Optionen

print "opt ";skip%;" ";delimiter$;" ";trace%

PRINT
PRINT "PASTE Start "
PRINT

'!
'! berlese fhrende Zeilen falls skip line gesetzt
'!

WHILE (skip% > 0) AND (NOT (EOF(ein1%)))
 DECR skip%                           '! skip% - 1
 LINE INPUT #ein1%, inlinie1$         '! lese eine Zeile
 PRINT #aus%, inlinie1$               '! in Ausgabedatei
 IF trace% THEN                       '! Trace Mode ?
  PRINT inlinie1$                     '! Anzeige Original
 END IF
WEND

'!
'! bearbeite n Zeilen
'!
 LINE INPUT #ein1%, inlinie1$         '! lese eine Zeile
 LINE INPUT #ein2%, inlinie2$         '! lese eine Zeile

WHILE (NOT EOF(ein1%)) AND (NOT EOF(ein2%))
 PRINT #aus%, inlinie1$; delimiter$;_ '! Zeile in Ausgabedatei
              inlinie2$               '!  "
 IF trace% THEN                       '! Trace Mode ?
  PRINT inlinie1$;delimiter$;_        '! Display Zeile
        inlinie2$                     '!  "
 END IF
 LINE INPUT #ein1%, inlinie1$         '! lese eine Zeile
 LINE INPUT #ein2%, inlinie2$         '! lese eine Zeile
WEND

'!
'! restliche Zeilen umcopieren bei unterschiedl. Dateilngen
'!

WHILE NOT (EOF (ein1%))               '! Datei 1 fertig?
 PRINT #aus%, inlinie1$               '! in Ausgabedatei
 IF trace% THEN                       '! Trace Mode ?
  PRINT inlinie1$                     '! ja -> Anzeige
 END IF
 LINE INPUT #ein1%, inlinie1$         '! lese eine Zeile
WEND

WHILE NOT (EOF (ein2%))               '! Datei 2 fertig?
 PRINT #aus%, inlinie2$               '! in Ausgabedatei
 IF trace% THEN                       '! Trace Mode ?
  PRINT inlinie2$                     '! ja -> Anzeige
 END IF
 LINE INPUT #ein2%, inlinie2$         '! lese eine Zeile
WEND

CLOSE

PRINT
PRINT "PASTE Ende"
END

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in PASTE
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";infilename1$;" oder ";infilename2$;_
       " existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
END                                 '! MSDOS Exit
RETURN

getswitch:
'--------------------------------------------------------
'! decodiere eingegebene Optionen
'! /S = skip    /D = separator    /T = tracen
'--------------------------------------------------------

 options$ = UCASE$(options$)

 IF INSTR(options$,"/T") > 0 THEN
  trace% = %true                       '! Trace Mode ein
 END IF

 ptr% = INSTR(options$,"/S=")          '! Skip Lines Option ?
 IF ptr% > 0 THEN
  CALL getval(options$,ptr%+3,skip%)   '! lese Zahl
 END IF

 ptr% = INSTR(options$,"/D=")          '! check Delimiter
 IF ptr% > 0 THEN
  delimiter$ = MID$(options$,ptr%+3,1) '! get Separator
 END IF
RETURN

SUB getval(text$,ptr%,result%)
'--------------------------------------------------------
'! decodiere Eingabewert als Dezimalzahl
'--------------------------------------------------------
LOCAL tmp%, zchn$, leng%, sign%

sign% = 1                             '! Vorzeichen +
tmp% = 0                              '! Hilfsvariable

leng% = LEN(text$)

CALL skipblank(ptr%,text$)            '! berlese Leerzeichen
zchn$ = MID$(text$,ptr%,1)            '! separ. Zeichen
IF zchn$ = "-" THEN                   '! Vorzeichen ?
 sign% = -1                           '! Vorzeichen  -
 INCR ptr%                            '! auf 1. Ziffer
END IF

zchn$ = MID$(text$,ptr%,1)            '! separ. Zeichen

WHILE (zchn$ >= "0") AND (zchn$ <= "9")_
 AND (ptr% <= leng%)                  '! n Ziffern
 tmp% = tmp% * 10 + VAL(zchn$)        '! Ziffer holen
 INCR ptr%                            '! nchstes Zeichen
 zchn$ = MID$(text$,ptr%,1)           '! lese Zeichen
WEND
result% = tmp% * sign%                '! Vorzeichen

END SUB

SUB getfile(ptr%,text$,result$)
'!---------------------------------------------------------
'! separiere Filename aus Eingabetext (text$)
'! ptr% -> Anfang Filename, result$ = Filename
'!---------------------------------------------------------
LOCAL tmp%

CALL skipblank (ptr%,text$)            '! entferne Blanks
tmp% = INSTR(ptr%,text$," ")           '! suche Separator
IF tmp% = 0 THEN
 PRINT "Fehler: kein Fileseparator"    '! kein Endeseparator
 END                                   '! Exit
END IF
IF MID$(text$,ptr%,1) = "/" THEN       '! Optionen eingegeben ?
 result$ = ""                          '! Leerstring
ELSE
 result$ = MID$(text$,ptr%,tmp%-ptr%)  '! Filename
 ptr% = tmp%                           '! korrigiere ptr%
END IF

END SUB

SUB skipblank(ptr%,text$)
'!---------------------------------------------------------
'! entferne fhrende Leerzeichen aus text$
'!---------------------------------------------------------

LOCAL lang%, zchn$

lang% = LEN (text$)                    '! Stringlnge
zchn$ = MID$(text$,ptr%,1)             '! separiere Zeichen

WHILE (zchn$ = " ") AND (ptr% <= lang%) '! Zeichen <> blank
 INCR ptr%
 zchn$ = MID$(text$,ptr%,1)            '! separiere Zeichen
WEND

END SUB

'***** Programm Ende ******
