' *********************************************************
' File       : PCXV.BAS
' Vers.      : 1.0
' Last Edit  : 20. 5.92
' Autor      : G. Born
' File I/O   : INPUT, OUTPUT, FILE, PRINTER
' Progr. Spr.: POWER BASIC
' Betr. Sys. : DOS 2.1 - 5.0
' Funktion: Das Programm zeigt einen PCX-Datei an.
'
' Aufruf:   PCXV Filename
'
' **********************************************************
'! Headervariable definieren
signatur%=0
version%=0
encoding%=0
bits%=0
x1%=0
y1%=0
x2%=0
y2%=0
hres%=0
vres%=0
planes%=0
bytel%=0
palinfo%=0
head$ = ""

debug% = 0                            '! Ausgabe Header ausschalten

'! Puffer fr 1 Zeile mit Bilddaten
DIM pixel%(4,1024)                    '! 4 Ebenen a 1024 Pixel

breite% = 0                           '! Pixel pro Zeile
hoehe% = 0                            '! Zeilen pro Bild


ON ERROR GOTO fehler                  '! Fehlerausgang

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! User Mode ?
 CLS                                  '! clear Screen

 PRINT "P C X  - V i e w                 (c) Born Version 1.0"
 PRINT
 INPUT  "File     : ",filename$
 PRINT
 INPUT  "Option /D: ",options$
 PRINT
ELSE
 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "P C X - V i e w              (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: PCXV <Filename> [/D]"
  PRINT
  PRINT "Zeigt eine PCX-Datei am Bildschirm an. Die"
  PRINT "Option /D schaltet den DEBUG-Mode ein."
  PRINT
  SYSTEM
 END IF
				      '! Kommando Mode
 ptr% = INSTR (kommando$,"/")         '! Optionen ?
 IF ptr% = 0 THEN
  filename$ = kommando$               '! nur Filename
  options$ = ""
 ELSE
  filename$ = LEFT$(kommando$,ptr% -1)'! Filename separieren
  options$  = MID$(kommando$,ptr%)    '! Optionen separieren
 END IF

 IF filename$ = "" THEN               '! Leereingabe ?
  PRINT
  PRINT "Der Dateiname fehlt"
  SYSTEM
 END IF

END IF

'! DEBUG-Option gesetzt (/D)

 options$ = UCASE$(options$)
 ptr% = INSTR (options$,"/D")         '! Debug-Option ?

 IF ptr% > 0 THEN
  debug% = 1                          '! DEBUG-Mode ein
 END IF

' prfe ob Datei vorhanden, nein -> exit

 OPEN filename$ FOR INPUT AS #1       '! File exist?
 CLOSE #1
 OPEN filename$ FOR BINARY AS #1      '! ffne Datei

 GET$ #1, 128, head$                  '! lese Header

 CALL GetHeader (status%, head$)      '! decodiere Header

 IF (status% <> 0) THEN
  PRINT "Keine gltige PCX-Datei"
  CLOSE
  SYSTEM
 END IF

 IF debug% = 1 THEN
  PRINT "Header "; signatur%; " "; version%
  PRINT "Encoding ";encoding%;" Bits ";bits%
  PRINT "Bild ";X1%;" ";Y1%;" ";x2%;" ";Y2%; " Pixel ";x2%-x1%
  PRINT "Planes ";planes%;" Bytes/(Zeile) ";bytel%
  PRINT
  INPUT "Weiter, bitte eine Taste bettigen", tmp$
 END IF

  SCREEN 12: CLS                       '! Graphikmode

breite% = x2% - x1%                   '! Pixel / Zeile
hoehe% = y2% - y1%                    '! Zeilen / Bild

FOR i% = 0 TO hoehe%                  '! alle Zeilen
 FOR k% = 1 to planes%                '! alle Farbebenen
  bcount% = 0                         '! decodierte Bytes
  ptr% = 1                            '! Hilfszeiger
  WHILE bcount% < bytel%              '! lese n Bytes

'! Datei sequentiell lesen und byteweise decodieren
   GET$ #1, 1, zchn$                  '! lese 1 Byte
   byte% = ASC(zchn$)                 '! konvert. in Byte

   IF byte% > &HC0 THEN               '! komprimiert ?
    count% = byte% AND &H3F           '! Wiederholfaktor
    bcount% = bcount% + count%        '! Zahl der Bildbytes
    GET$ #1, 1, zchn$                 '! Datenbyte
    byte% = ASC(zchn$)
    FOR l% = 1 to count%              '! generiere Daten
     pixel%(k%,ptr%) = byte%          '! speichere Byte
     INCR ptr%
    NEXT l%
   ELSE
    INCR bcount%                       '! Zahl der Bildbytes
    pixel%(k%,ptr%) = byte%            '! speichere Byte
    INCR ptr%
   END IF
  WEND
 NEXT k%
'! Bildzeile ausgeben
 Call Plotlinie (x1%, y1%+i%, bcount%-1)
NEXT i%

tmp$ = INPUT$ (1)

LOCATE 24,1

PRINT
PRINT "Ausgabe beendet"
CLOSE                                 '! Dateien schlieen

END


'#########################################################
'#                   Hilfsroutinen                       #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in TEXTS
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";filename$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
 END                                   '! MSDOS Exit
RETURN


SUB getheader (status%, header$)
'---------------------------------------------------------
'! Lese die Daten des Headers in Variable
'---------------------------------------------------------
SHARED signatur%, version%, encoding%, bits%, x1%, y1%
SHARED x2%, y2%, hres%, vres%, colormap%, planes%, bytel%
SHARED palinfo%
LOCAL ptr%, tmp$
DIM a%(2)

'! setze die Infos im Header in Variable um

status% = 0
signatur% = ASC(MID$(header$,1,1))     '! Signatur PCX-File
IF signatur% <> 10 THEN                '! teste Signatur
 status% = 1
 EXIT SUB
END IF

version% = ASC(MID$(header$,2,1))      '! Versionsnummer
encoding% = ASC(MID$(header$,3,1))     '! Kodierungsflag
bits% = ASC(MID$(header$,4,1))         '! Bits pro Ebene

tmp$ = MID$(header$,5,2)               '! Xmin decodieren
a%(1) = STRPTR(tmp$)
a%(2) = STRSEG(tmp$)
CALL MOVE (2,x1%,a%(1))

tmp$ = MID$(header$,7,2)               '! Ymin decodieren
a%(1) = STRPTR(tmp$)
a%(2) = STRSEG(tmp$)
CALL MOVE (2,y1%,a%(1))

tmp$ = MID$(header$,9,2)               '! Xmax decodieren
a%(1) = STRPTR(tmp$)
a%(2) = STRSEG(tmp$)
CALL MOVE (2,x2%,a%(1))

tmp$ = MID$(header$,11,2)               '! Ymax decodieren
a%(1) = STRPTR(tmp$)
a%(2) = STRSEG(tmp$)
CALL MOVE (2,y2%,a%(1))

planes% = ASC(MID$(header$,66,1))      '! Planes decodieren

tmp$ = MID$(header$,67,2)               '! Bytes pro Zeile decodieren
a%(1) = STRPTR(tmp$)
a%(2) = STRSEG(tmp$)
CALL MOVE (2,bytel%,a%(1))
bytel% = bytel%
END SUB


SUB Plotlinie (x1%,y1%,lenx%)
'---------------------------------------------------------
'! CALL Plotline (....)
'! Die Prozedur gibt die Bilddaten in einer Zeile aus.
'---------------------------------------------------------
SHARED planes%, breite%
SHARED pixel%()()
LOCAL i%, k%, ptr%

ptr% = x1%
FOR i% = 1 TO lenx%+1
 mask% = 128                                   '! oberstes Bit
 FOR k% = 8 TO 1 STEP - 1                      '! alle Bits
  IF (pixel%(1,i%) AND mask%) <> 0 THEN bit%=1
  IF (pixel%(2,i%) AND mask%) <> 0 THEN bit%=bit%+2
  IF (pixel%(3,i%) AND mask%) <> 0 THEN bit%=bit%+4
  IF (pixel%(4,i%) AND mask%) <> 0 THEN bit%=bit%+8

  PSET (ptr%,y1%), (bit%)
  INCR ptr%                                     '! next Point
  mask% = mask% / 2                             '! next Bit
 NEXT k%
NEXT i%
END SUB

SUB MOVE INLINE
'---------------------------------------------------------
'! CALL MOVE (LEN, ZIEL, QUELLE)
'! Die Prozedur verschiebt n Byte eines Strings in die
'! Zieladresse. Achtung: der String mu mit seiner Adresse
'! angegeben werden.
'! Bsp.:   A$="AB"      String
'!         DIM a%(2)    Adress Dummy
'!         X% = 0       Ziel
'!         a%(1) = STRPTR (A$)
'!         a%(2) = STRSEG (A$)
'!         CALL MOVE (2, X%, a5(1)  verschiebe 2 Byte
'---------------------------------------------------------

$INLINE "move.com"

END SUB

' ###### Programm Ende #########
