'*********************************************************
'! File       : POPMENU.BAS
'! Vers.      : 1.0
'! Last Edit  : 10.7.92
'! Autor      : G. Born
'! Progr. Spr.: Power Basic
'! Betr. Sys. : DOS 2.1 - 5.0 (DR-DOS 5.0/6.0)
'! Funktion: Das Programm wird mit der Eingabe:
'!
'!           POPMENUE
'!
'!           aufgerufen. Es demonstriert die Verwendung
'!           der Routinen zur Mensteuerung (MENU.INC).
'**********************************************************
'! definiere Variable
DIM MEN$(7)                            '! Mentexte
nr% = 1                                '! Zeilennr. Cursor
tmp% = 1

DIM buff1%(600)                        '! temporre Puffer
DIM buff2%(500)                        '! max. 2000 Elemente
DIM buff3%(500)                        '! fr kompletten
DIM buff4%(500)                        '! Screen
handle1% = 0                           '! handle fr OpenBox
handle2% = 0                           '! und CloseBox
handle3% = 0
handle4% = 0

DIM xp%(3)                              '! Koordinaten Jump Men
DIM yp%(3)                              '! vereinbaren
xp%(1) = 15
xp%(2) = 20
xp%(3) = 30
yp%(1) = 5
yp%(2) = 10
yp%(3) = 15


black% = 0                             '! Farben
blue% = 1
green% = 2
zyan% = 3
red% = 4
magen% = 5
white% = 7

d% = 2                                  '! Doppelrahmen
e% = 1                                  '! Einfachrahmen

'! Bildschirm lschen und mit Zeichen fllen

CLS
FOR i% = 1 TO 1999: PRINT ""; : Next i% '! Screen fllen

'!-----------------------------------------------------
'! Init Variable des Mensystems, der Bildschirmadapter
'! liegt bei Coloradaptern bei Segmentadr. B800H,
'!-----------------------------------------------------

CALL MenuInit (&HB800)             '! Init Variable

done% = 0                          '! Hilfsflag lschen

'!=====================================================

DO WHILE 1                         '! Schleife ber Mensystem

 Kopf$ = ("1.Menue")               '! Titeltext fr Menbox
 MEN$(1) = "1. Submen"            '! Texte fr Men definieren
 MEN$(2) = "2. Submen"
 MEN$(3) = "3. Textbox"
 MEN$(4) = "4. ---"
 MEN$(5) = "5. ---"
 MEN$(6) = "6. Jump Men"
 MEN$(7) = "7. Exit"

'!-----------------------------------------------------
'! Aufruf des Hauptmens mit Kopftext ohne Futext, 7 entries
'! als erstes mu der Fensterbereich gesichert werden
'! Achtung: dies darf nur 1 x erfolgen, deshalb Flag done
'!-----------------------------------------------------

 IF done% = 0 THEN                 '! Box offen?
  CALL OpenBox(8,5,MEN$(),7,kopf$,"",buff1%())
  done% = 1                        '! markiere offene Box
 END IF

 status% = 0
 CALL PopMenu(8,5,MEN$(),7,white%,blue%,kopf$,"",d%,status%,nr%)
 tmp% = nr%                        '! merke Selektion
 IF status% < 0 THEN               '! Fehler beim Aufruf?
  CLS
  PRINT "Fehler: Menbox pat nicht auf Bildschirm"
  END
 ELSE
  IF status% = 1 THEN              '! ESC gedrckt?
   CALL CloseBox(buff1%())         '! Schliee Box
   END                             '! Ja -> Exit
  END IF
 END IF

'! werte selektierten Menpunkt in nr% aus
'! status% = 2 oder 3 wird hier ignoriert und
'! wirkt daher wie RETURN !!!!

 SELECT CASE nr%

  CASE = 1                         '! 1. Auswahlcode Hauptmen
'!-----------------------------------------------------
'! baue ein Submen mit 3 Eintrgen auf
'!-----------------------------------------------------
   MEN$(1) = "Test"                '! Texte fr Men definieren
   MEN$(2) = "------"
   MEN$(3) = "EXIT"

   CALL OpenBox(21,8,MEN$(),3,"Sub-Menu1","",buff2%())
   CALL PopMenu(21,8,MEN$(),3,red%,blue%,"Sub-Menu1","",d%,status%,nr%)
   IF status% < 0 THEN               '! Fehler beim Aufruf?
    CLS
    PRINT "Fehler: Menbox pat nicht auf Bildschirm"
    END
   ELSE                '! werte nur status% = 0 aus
    IF status% = 0 THEN              '! RETURN gedrckt

'!-----------------------------------------------------
'!
'! Trick: Hier wird die Menauswahl als Textbox benutzt
'!
'!-----------------------------------------------------

     MEN$(1) = "Auswahl: " + STR$(nr%)
     MEN$(2) = "Bitte ESC- oder RET-Taste bettigen
     CALL OpenBox(30,10,MEN$(),2,"","",buff3%())
     CALL PopMenu(30,10,MEN$(),2,zyan%,red%,"","",e%,status%,nr%)
     CALL CloseBox(buff3%())               '! close Textbox
    END IF
   END IF

  CALL CloseBox(buff2%())                  '! close Submen

  CASE = 2
  '! baue ein 2. Submen mit 4 Eintrgen auf
   head$ = "Sub-Menue 2"           '! Titeltext fr Menbox
   fuss$ = "Exit->ESC"             '! Futext fr Menbox
   MEN$(1) = "Test 1"              '! Texte fr Men definieren
   MEN$(2) = "Test 2"
   MEN$(3) = "Test 3"
   MEN$(4) = "EXIT"

'! Aufruf des Mens
   CALL OpenBox(15,12,MEN$(),4,head$,fuss$,buff2%())
   CALL PopMenu(15,12,MEN$(),4,white%,black%,head$,fuss$,d%,status%,nr%)
   IF status% < 0 THEN               '! Fehler beim Aufruf?
    CLS
    PRINT "Fehler: Menbox pat nicht auf Bildschirm"
    END
   ELSE
    IF status% = 0 THEN              '! RETURN gedrckt
'!
'! Trick: Hier wird die Menauswahl als Textbox benutzt
'!
     MEN$(1) = "Auswahl: " + STR$(nr%)
     MEN$(2) = "Bitte ESC- oder RET-Taste bettigen
     CALL OpenBox(20,10,MEN$(),2,"","",buff3%())
     CALL PopMenu(20,10,MEN$(),2,2,4,"","",e%,status%,nr%)
     CALL CloseBox(buff3%())
    END IF
   END IF

   CALL CloseBox(buff2%())

  CASE = 3                              '! Textanzeige

  '! schliee das Hauptmen
   CALL CloseBox(buff1%())
   done%=0                              '! reset flag%


'!-----------------------------------------------------
'! baue den Text der Box auf
'!-----------------------------------------------------

   MEN$(1) = "Dies ist ein Beispiel fr den Aufbau einer"
   MEN$(2) = "Textbox. Der Text mu auf die einzelnen Zeilen"
   MEN$(3) = "aufgeteilt werden. Um die Box zu schlieen,"
   MEN$(4) = "drcken Sie bitte die ESC-Taste."

   CALL OpenBox(20,10,MEN$(),4,"Sub-Menu1","",buff2%())
   CALL PopMenu(20,10,MEN$(),4,white%,green%,"Sub-Menu1","",e%,status%,nr%)
   IF status% < 0 THEN               '! Fehler beim Aufruf?
    CLS
    PRINT "Fehler: Textbox pat nicht auf Bildschirm"
    END
   END IF

  CALL CloseBox(buff2%())

  CASE = 4
  CASE = 5
  CASE = 6
   CALL CloseBox(buff1%())                    '! schliee Hauptmen

'!-----------------------------------------------------
'! Demo wie eine BOX verwendet wird (Jump Men)
'!-----------------------------------------------------

   Kopf$ = ("Jump Men")             '! Titeltext fr Menbox
   MEN$(1) = "Punkt 1"               '! Texte fr Men definieren
   MEN$(2) = "Punkt 2"
   MEN$(3) = "Punkt 3"

'! n. Aufrufe des Hauptmens an leicht vernderter Position

  status% = 0
  nr% = 1

  DO WHILE status% = 0
   tmp% = nr%                '! Achtung: alte nr% merken
			     '! und buff4%() verwenden,
			     '! da buff1() noch benutzt !!!!
   CALL OpenBox(xp%(nr%),yp%(nr%),MEN$(),3,kopf$,"",buff4%())
   CALL PopMenu(xp%(nr%),yp%(nr%),MEN$(),3,white%,blue%,kopf$,fuss$,e%,status%,nr%)
   CALL CloseBox(buff4%())

  WEND

  CASE = 7
'! schliee Hauptmen und terminiere
   CALL CloseBox(buff1%())
   END
 END SELECT

 nr% = tmp%                           '! setze Selektionspunkt

WEND
END

'! Routinen zur Mensteuerung einbinden

$INCLUDE "menu.inc"

'! Ende
