' *********************************************************
' File       : PSCRIPT.BAS
' Vers.      : 1.0
' Last Edit  : 29. 4.92
' Autor      : G. Born
' File I/O   : INPUT, OUTPUT, FILE, PRINTER
' Progr. Spr.: POWER BASIC
' Betr. Sys. : DOS 2.1 - 5.0
' Funktion: Das Programm dient zur Ausgabe von Textdateien
'           auf PostScript-Gerten. Der Text wird in eine
'           Datei mit der Extension .PS konvertiert. Es
'           lassen sich beliebige Textdateien mit diesem
'           Programm aufbereiten. Die Steueranweisungen
'           fr den Interpreter (Seitenumbruch, Randein-
'           stellung, etc.) werden in PSCRIPT direkt und
'           ber die Datei HEADER.PS generiert.
'
' Aufruf:   PSCRIPT Filename <Optionen>
'           Optionen:  /H   Kopftext auf 1. Seite
'                      /L=xx linker Rand in Punkt   [  10]
'                      /R=xx rechter Rand           [ 500]
'                      /O=xx oberer Rand            [ 700]
'                      /U=xx unterer Rand           [ 100]
'                      /F=xx Fontgre in Punkt     [  10]
'
'           Die Werte in [] geben die Standardeinstellung
'           wieder. Wird das Programm ohne Parameter aufge-
'           rufen, sind Dateiname und Optionen explizit ab-
'           zufragen. Mit dem Aufruf:
'
'              PSCRIPT /?
'
'           wird ein Hilfsbildschirm ausgegeben.
' **********************************************************
' Variable definieren
rechts% = 500                         '! rechter Rand (Punkt)
links% = 10                           '! linker Rand (Punkt)
oben% = 700                           '! oberer Rand (Punkt)
unten% = 100                          '! unterer Rand (Punkt)
font% = 10                            '! Fontgre (Punkt)

indatei% = 1                          '! Dateinummer Eingabe
indatei2% = 3                         '! Dateinummer Header
outdatei% = 2                         '! Dateinummer Ausgabe
errorname$ = ""                       '! Dateiname bei Fehlern

ON ERROR GOTO fehler                  '! Fehlerausgang

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! User Mode ?
 CLS                                  '! clear Screen

 PRINT "P S C R I P T                         (c) Born Version 1.0"
 PRINT
 PRINT "Optionen [ /L=10  linker Rand         /R=500 rechter Rand   ]"
 PRINT "         [ /O=700 oberer Rand         /U=100 unterer Rand   ]"
 PRINT "         [ /F=10  Fontgre/Punkt     /H     Kopf 1. Seite  ]"
 PRINT
 INPUT  "File     : ",filename$
 INPUT  "Optionen : ",options$
 PRINT
ELSE

 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "P S C R I P T                (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: PSCRIPT <Filename> <Optionen>"
  PRINT
  PRINT "Optionen :"
  PRINT
  PRINT "  /L=10  setzt den linken Rand in Punkt"
  PRINT "  /R=500 setzt den rechten Rand"
  PRINT "  /O=700 setzt den oberen Rand"
  PRINT "  /U=100 setzt den unteren Rand"
  PRINT "  /F=10  setzt die Fontgre in Punkt"
  PRINT "  /H     Kopfzeile auf 1. Seite"
  PRINT
  PRINT "Das Programm wandelt einen Textfile in eine PostScript-"
  PRINT "Datei mit der Extension xxxx.PS um, wobei xxxx dem File-"
  PRINT "namen entspricht. Die Ergebnisdatei kann dann auf einem"
  PRINT "PostScript-Gert ausgegeben werden."
  PRINT
  SYSTEM
 END IF
				      '! Kommando Mode
 ptr% = INSTR (kommando$,"/")         '! Optionen ?
 IF ptr% = 0 THEN
  filename$ = kommando$               '! nur Filename
 ELSE
  filename$ = LEFT$(kommando$,ptr% -1) '! Filename separieren
  options$  = MID$(kommando$,ptr%)    '! Optionen separieren
 END IF
END IF

GOSUB parameter                       '! Optionen decodieren

IF (rechts% < links%) or (oben% < unten%) THEN  '! sinnlose
 PRINT                                        '! Einstellung
 PRINT "Bitte Randeinstellung neu setzen"     '! Fehlerexit
 END                                  '! Exit
END IF

IF filename$ = "" THEN                '! Leereingabe ?
 PRINT
 PRINT "Der Dateiname fehlt"
 END                                  '! Exit
END IF

ptr% = INSTR(filename$,".")           '! hat Datei eine Extension?
IF ptr% > 0 THEN
 outfile$ = LEFT$(filename$,ptr%) + "PS" '! Filename ohne Extension
ELSE
 outfile$ = filename$ + ".PS"         '! Extension anhngen
END IF

' prfe ob Datei vorhanden, nein -> exit

errorname$ = filename$

OPEN filename$ FOR INPUT AS #indatei%  '! ffne Eingabedatei
OPEN outfile$ FOR OUTPUT AS #outdatei% '! ffne Ausgabedatei
PRINT
PRINT "Die Datei: ";filename$;" wird bearbeitet"

GOSUB vorspann                        '! Vorspann generieren

WHILE NOT (EOF(indatei%))             '! Datei sequentiell lesen
 LINE INPUT #indatei%, linie$         '! lese Zeile

 '! scan line auf (..) und wandle in \( oder \) um
 linie1$ = ""
 FOR i% = 1 to LEN(linie$)
  zchn$ = MID$(linie$,i%,1)
  IF (zchn$ = "(") or (zchn$ = ")") THEN
   linie1$ = linie1$ + "\"
  END IF
  linie1$ = linie1$ + zchn$
 NEXT i%

 PRINT #outdatei%, "(";linie1$;") printline" '! schreibe Zeile
WEND

PRINT #outdatei%, "showpage"          '! Abschlu PS-Datei
PRINT #outdatei%, "% END of File"

CLOSE #indatei%                       '! Datei schlieen
CLOSE #outdatei%                      '! Datei schlieen
PRINT
PRINT "Die Datei: ";filename$;" wurde im aktuellen Verzeichnis erzeugt"
END

'#########################################################
'#                   Hilfsroutinen                       #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in PSCRIPT
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";errorname$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
END                                 '! MSDOS Exit
RETURN

parameter:
'---------------------------------------------------------
'! Decodiere die Eingabeoptionen
'---------------------------------------------------------

options$ = UCASE$(options$)

ptr% = INSTR (options$,"/L=")
IF ptr% > 0 THEN CALL getval (links%) '! linker Rand

ptr% = INSTR (options$,"/R=")
IF ptr% > 0 THEN CALL getval (rechts%) '! rechter Rand

ptr% = INSTR (options$,"/O=")
IF ptr% > 0 THEN CALL getval (oben%)   '! oberer Rand

ptr% = INSTR (options$,"/U=")
IF ptr% > 0 THEN CALL getval (unten%)  '! unterer Rand

ptr% = INSTR (options$,"/F=")
IF ptr% > 0 THEN CALL getval (font%)   '! Fontgre

RETURN

SUB getval (wert%)
'---------------------------------------------------------
'! Decodiere den Eingabestring in eine Zahl
'---------------------------------------------------------
 SHARED options$, ptr%
 LOCAL teil$, i%

 ptr% = ptr% + 3                      '! ptr hinter /x=
 i% = 1
 WHILE ((ptr%+i%) =< LEN (options$)) and (MID$(options$,ptr%+i%,1) <> " ")
  i% = i% + 1                         '! Ziffernzahl + 1
 WEND
 wert% = VAL(MID$(options$,ptr%,i%))  '! decodiere die Zahl
END SUB

vorspann:
'---------------------------------------------------------
'! generiere Vorspann mit PostScript-Anweisungen
'---------------------------------------------------------
errorname$ = "HEADER.PS"

OPEN "HEADER.PS" FOR INPUT AS #indatei2%  '! Header ffnen
PRINT "Generiere Fileheader"

PRINT #outdatei%, "%%!PS-Adobe-2.0 EPSF-1.2"
PRINT #outdatei%, "%%Title: ",filename$
PRINT #outdatei%, "%%Creator: PSCRIPT 1.0 (c) Born G."
PRINT #outdatei%, "%%EndComments"
PRINT #outdatei%, ""
PRINT #outdatei%, "%%BeginSetup"
PRINT #outdatei%, "/LM ";links%;" def        % linker Rand"
PRINT #outdatei%, "/RM ";rechts%;" def       % rechter Rand"
PRINT #outdatei%, "/TM ";oben%;" def         % oberer Rand"
PRINT #outdatei%, "/BM ";unten%;" def        % unterer Rand"
PRINT #outdatei%, "/CH ";font%;" def         % Fontgre"
PRINT #outdatei%, ""

WHILE NOT (EOF(indatei2%))            '! Datei sequentiell lesen
 LINE INPUT #indatei2%, linie$        '! lese Zeile
 PRINT #outdatei%, linie$             '! schreibe
WEND

PRINT #outdatei%, "%%EndSetup"
PRINT #outdatei%, ""

CLOSE #indatei2%

'! generiere Kopfzeile, falls Option /H gesetzt
IF (INSTR (options$,"/H") <> 0) THEN
 PRINT #outdatei%, "(P S C R I P T    "; options$; SPACE$(27);
 PRINT #outdatei%, "(c) Born Version 1.0) printline"
 PRINT #outdatei%, "(Datei : ";filename$;"     Datum : ";DATE$;
 PRINT #outdatei%, ") printline"
 PRINT #outdatei%,
END IF

RETURN

END
