' *********************************************************
' File       : PSLIST.BAS
' Vers.      : 1.0
' Last Edit  : 30. 4.92
' Autor      : G. Born
' File I/O   : INPUT, OUTPUT, FILE, PRINTER
' Progr. Spr.: POWER BASIC
' Betr. Sys. : DOS 2.1 - 5.0
' Funktion: Das Programm dient zur Ausgabe von Listings
'           auf PostScript-Gerten. Der Text wird in eine
'           Datei mit der Extension .PS konvertiert. Es
'           lassen sich beliebige Textdateien mit diesem
'           Programm aufbereiten. Die Steueranweisungen
'           fr den Interpreter (Seitenumbruch, Randein-
'           stellung, etc.) werden ber PSLIST direkt und
'           ber die Datei HEADER.PS generiert.
'
' Aufruf:   PSLIST Filename <Optionen>
'           Optionen:  /N   Zeilennumerierung ein   [AUS]
'                      /L=xx linker Rand in Punkten [ 100]
'                      /R=xx rechter Rand           [ 500]
'                      /O=xx oberer Rand            [ 700]
'                      /U=xx unterer Rand           [ 100]
'                      /F=xx Fontgre in Punkt     [  10]
'
'           Die Werte in [] geben die Standardeinstellung
'           wieder. Wird das Programm ohne Parameter aufge-
'           rufen, sind Dateiname und Optionen explizit ab-
'           zufragen. Mit dem Aufruf:
'
'              PSLIST /?
'
'           wird ein Hilfsbildschirm ausgegeben.
' **********************************************************
' Variable definieren
%on = 1: %off = 0
nummer% = %off                        '! keine Zeilennummern
zeile& = 0                            '! Zeilennummer Listing
seite% = 1                            '! Seitennummer Listing

rechts% = 500                         '! rechter Rand in Punkt
links% = 10                           '! linker Rand
oben% = 700                           '! oberer Rand
unten% = 100                          '! unterer Rand
font% = 10                            '! Fontgre
rmargin% = 75                         '! 75 Zeichen pro Zeile

indatei% = 1                          '! Dateinummer Eingabe
indatei2% = 3                         '! Dateinummer Header
outdatei% = 2                         '! Dateinummer Ausgabe
errorname$ = ""

ON ERROR GOTO fehler                  '! Fehlerausgang

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! User Mode ?
 CLS                                  '! clear Screen

 PRINT "P S L I S T                            (c) Born Version 1.0"
 PRINT
 PRINT "Optionen [ /L=10  linker Rand         /R=500 rechter Rand   ]"
 PRINT "         [ /O=700 oberer Rand         /U=100 unterer Rand   ]"
 PRINT "         [ /F=10  Fontgre/Punkt     /N     Numerierung Ein]"
 PRINT
 INPUT  "File     : ",filename$
 INPUT  "Optionen : ",options$
 PRINT
ELSE

 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "P S L I S T                  (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: PSLIST <Filename> <Optionen>"
  PRINT
  PRINT "Optionen :"
  PRINT
  PRINT "  /L=10  setzt den linken Rand in Punkt"
  PRINT "  /R=500 setzt den rechten Rand"
  PRINT "  /O=700 setzt den oberen Rand"
  PRINT "  /U=100 setzt den unteren Rand"
  PRINT "  /F=10  setzt die Fontgre in Punkt"
  PRINT "  /N     Numerierung ein"
  PRINT
  PRINT "Das Programm gibt ein Listing als PostScript-Datei"
  PRINT "mit der Extension xxxx.PS aus, wobei xxxx dem File-"
  PRINT "namen entspricht. Die Ergebnisdatei kann dann auf einem"
  PRINT "PostScript-Gert ausgegeben werden."
  PRINT
  SYSTEM
 END IF
				      '! Kommando Mode
 ptr% = INSTR (kommando$,"/")         '! Optionen ?
 IF ptr% = 0 THEN
  filename$ = kommando$               '! nur Filename
 ELSE
  filename$ = LEFT$(kommando$,ptr% -1) '! Filename separieren
  options$  = MID$(kommando$,ptr%)    '! Optionen separieren
 END IF
END IF

GOSUB parameter                       '! Optionen decodieren

IF (rechts% < links%) or (oben% < unten%) THEN  '! sinnlose
 PRINT                                        '! Einstellung
 PRINT "Bitte Randeinstellung neu setzen"     '! Fehlerexit
 END                                  '! Exit
END IF

IF filename$ = "" THEN                '! Leereingabe ?
 PRINT
 PRINT "Der Dateiname fehlt"
 END                                  '! Exit
END IF

ptr% = INSTR(filename$,".")           '! hat Datei eine Extension?
IF ptr% > 0 THEN
 outfile$ = LEFT$(filename$,ptr%) + "PS" '! Filename ohne Extension
ELSE
 outfile$ = filename$ + ".PS"         '! Extension anhngen
END IF

' prfe ob Datei vorhanden, nein -> exit

errorname$ = filename$

OPEN filename$ FOR INPUT AS #indatei%  '! ffne Eingabedatei
OPEN outfile$ FOR OUTPUT AS #outdatei% '! ffne Ausgabedatei
PRINT
PRINT "Die Datei: ";filename$;" wird bearbeitet"

GOSUB vorspann                        '! Vorspann generieren

WHILE NOT (EOF(indatei%))             '! Datei sequentiell lesen
 LINE INPUT #indatei%, linie$         '! lese Zeile
 '! scan line auf (..) und wandle in \( oder \) um
 linie1$ = ""
 FOR i% = 1 to LEN(linie$)
  zchn$ = MID$(linie$,i%,1)
  IF (zchn$ = "(") or (zchn$ = ")") THEN
   linie1$ = linie1$ + "\"
  END IF
  linie1$ = linie1$ + zchn$
 NEXT i%
 linie$ = linie1$
 GOSUB ausgabe                        '! schreibe Zeile
WEND

PRINT #outdatei%, "showpage"          '! Abschlu PS-Datei
PRINT #outdatei%, "% END of File"

CLOSE #indatei%                       '! Datei schlieen
CLOSE #outdatei%                      '! Datei schlieen
PRINT
PRINT "Die Datei: ";filename$;" wurde im aktuellen Verzeichnis erzeugt"
END

'#########################################################
'#                   Hilfsroutinen                       #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in PSLIST
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";errorname$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
END                                 '! MSDOS Exit
RETURN

parameter:
'---------------------------------------------------------
'! Decodiere die Eingabeoptionen
'---------------------------------------------------------

options$ = UCASE$(options$)

ptr% = INSTR (options$,"/N")
IF ptr% > 0 THEN Nummer%=%on          '! Zeilennumerierung

ptr% = INSTR (options$,"/L=")
IF ptr% > 0 THEN CALL getval (links%) '! linker Rand

ptr% = INSTR (options$,"/R=")
IF ptr% > 0 THEN CALL getval (rechts%) '! rechter Rand

ptr% = INSTR (options$,"/O=")
IF ptr% > 0 THEN CALL getval (oben%)   '! oberer Rand

ptr% = INSTR (options$,"/U=")
IF ptr% > 0 THEN CALL getval (unten%)  '! unterer Rand

ptr% = INSTR (options$,"/F=")
IF ptr% > 0 THEN CALL getval (font%)   '! Fontgre
IF font% > 20 THEN font% = 20          '! max. 20 Punkt

'! berechne Zeilenzahl aus Seiten- und Fontgre
maxzeile% = (oben% - unten%) / (font% + font% / 3)
szeile% = maxzeile%+1
RETURN

SUB getval (wert%)
'---------------------------------------------------------
'! Decodiere den Eingabestring in eine Zahl
'---------------------------------------------------------
 SHARED options$, ptr%
 LOCAL i%

 ptr% = ptr% + 3                      '! ptr hinter /x=
 i% = 1
 WHILE ((ptr%+i%) =< LEN (options$)) and (MID$(options$,ptr%+i%,1) <> " ")
  i% = i% + 1                         '! Ziffernzahl + 1
 WEND
 wert% = VAL(MID$(options$,ptr%,i%))  '! decodiere die Zahl
END SUB

pageskip:
'---------------------------------------------------------
'! Seitenvorschub mit Kopf (Dateiname, Datum, Seite)
'---------------------------------------------------------
 IF szeile% < maxzeile% THEN RETURN   '! kein Seitenwechsel !!

 IF seite% > 1 THEN                   '! 1. Seite k. Vorschub
  PRINT #outdatei%, "newpage"         '! Vorschub
  szeile% = 3                         '! 3 Kopfzeilen
 ELSE
  PRINT #outdatei%, "(P S L I S T    "; options$; SPACE$(27);
  PRINT #outdatei%, "\(c\) Born Version 1.0) printline"
  szeile% = 4                         '! 4 Kopfzeilen
 END IF
 PRINT #outdatei%, "(Datei : ";filename$;"     Datum : ";DATE$;
 PRINT #outdatei%, "         Seite : "; seite%; ") printline"
 PRINT #outdatei%,
 INCR seite%

RETURN

ausgabe:
'--------------------------------------------------------
'! Ausgabe der eingelesenen Zeile in der Datei
'! rest% gibt an, wieviele Zeichen pro Zeile gedruckt
'! werden drfen. Ist die eingelesene Zeile lnger, wird
'! sie auf mehrere Ausgabezeilen aufgeteilt.
'--------------------------------------------------------

 INCR zeile&                          '! Zeile im Listing + 1
 GOSUB pageskip                       '! Seitenvorschub ?

 spalte% = 0                          '! linker Rand (immer 0)
 PRINT #outdatei%, "(";               '! Startklammer

 IF nummer% = %on THEN                '! Zeilennumerierung ?
  PRINT #outdatei%, USING "###### "; zeile&; '! Zeilennummer drucken
  spalte% = spalte% + 7               '! Spalte 7 setzen
 END IF

 rest% = rmargin% - spalte%           '! Restzeilenlnge
 GOSUB skipblank                      '! merke Blanks
 PRINT #outdatei%, LEFT$(linie$,rest%); '! Ausgabe Teilstring
 PRINT #outdatei%, ") printline"
 linie$ = MID$(linie$, rest% + 1)     '! Reststring
 INCR szeile%

 WHILE LEN(linie$) > rest%            '! String > Zeile
  GOSUB pageskip                      '! Seitenvorschub ?
  PRINT #outdatei%, "("; SPACE$(spalte%); '! linker Rand
  PRINT #outdatei%, LEFT$(linie$,rest%);  '! Teilstring ausgeben
  PRINT #outdatei%, ") printline"
  linie$ = MID$(linie$,rest% + 1)     '! Reststring bestimmen
  INCR szeile%                        '! Zeile im Listing + 1
 WEND

 IF LEN(linie$) > 0 THEN
  GOSUB pageskip                      '! Seitenvorschub ?
  PRINT #outdatei%, "("; SPACE$(spalte%);linie$; '! Reststring ausgeben
  PRINT #outdatei%, ") printline"
  INCR szeile%                        '! Zeile im Listing + 1
 END IF
RETURN

skipblank:
'---------------------------------------------------------
'! zhle fhrende Blanks
'---------------------------------------------------------
i% = 1
WHILE (i% < LEN(linie$)) and (MID$(linie$,i%,1) = " ")
 INCR i%
 INCR spalte%
WEND
RETURN

vorspann:
'---------------------------------------------------------
'! generiere Vorspann mit PostScript-Anweisungen
'---------------------------------------------------------
errorname$ = "HEADER.PS"

OPEN "HEADER.PS" FOR INPUT AS #indatei2%  '! Header ffnen
PRINT "Generiere Fileheader"

PRINT #outdatei%, "%%!PS-Adobe-2.0 EPSF-1.2"
PRINT #outdatei%, "%%Title: ",filename$
PRINT #outdatei%, "%%Creator: PSLIST 1.0 (c) Born G."
PRINT #outdatei%, "%%EndComments"
PRINT #outdatei%, ""
PRINT #outdatei%, "%%BeginSetup"
PRINT #outdatei%, "/LM ";links%;" def        % linker Rand"
PRINT #outdatei%, "/RM ";rechts%;" def       % rechter Rand"
PRINT #outdatei%, "/TM ";oben%;" def         % oberer Rand"
PRINT #outdatei%, "/BM ";unten%;" def        % unterer Rand"
PRINT #outdatei%, "/CH ";font%;" def         % Fontgre"
PRINT #outdatei%, ""


WHILE NOT (EOF(indatei2%))            '! Datei sequentiell lesen
 LINE INPUT #indatei2%, linie$        '! lese Zeile
 PRINT #outdatei%, linie$             '! schreibe
WEND

PRINT #outdatei%, "%%EndSetup"
PRINT #outdatei%, ""

CLOSE #indatei2%

RETURN

END
