'*********************************************************
'! File       : PULLMENU.BAS
'! Vers.      : 1.0
'! Last Edit  : 10.7.92
'! Autor      : G. Born
'! Progr. Spr.: Power Basic
'! Betr. Sys. : DOS 2.1 - 5.0 (DR-DOS 5.0/6.0)
'! Funktion: Das Programm wird mit der Eingabe:
'!
'!           PULLMENUE
'!
'!           aufgerufen. Es demonstriert die Verwendung
'!           der Routinen zur Steuerung von PullDown Mens.
'!           (MENU.INC).
'**********************************************************
'! definiere Variable
DIM MEN1$(3)                           '! Mentexte
DIM MEN2$(3)                           '! Mentexte
DIM xpos%(3)                           '! Position Menpunkte
DIM buff1%(100)                        '! Buffer fr Save
DIM buff2%(2000)                       '! "


black% = 0                             '! Farben
blue% = 1
green% = 2
zyan% = 3
red% = 4
magen% = 5
white% = 7

'! Bildschirm lschen und mit Zeichen fllen

CLS
FOR i% = 1 TO 1999: PRINT ""; : Next i% '! Screen fllen

'!-----------------------------------------------------
'! Init Variable des Mensystems, der Bildschirmadapter
'! liegt bei Coloradaptern bei Segmentadr. B800H,
'!-----------------------------------------------------

 CALL MenuInit (&HB800)             '! Init Variable

 MEN$(1) = "Files"                  '! Texte fr Men definieren
 MEN$(2) = "Edit"
 MEN$(3) = "Exit"
 items% = 3                         '! 3 Punkte im Hauptmen

'!-----------------------------------------------------
'! Aufruf des Menzeile des Pull Down Mens
'!-----------------------------------------------------

 CALL SaveArea (1,1,80,1,buff1%()) '! sichere 1. Zeile Screen
 CALL SaveArea (1,2,80,20,buff2%())'! sichere weitere Zeilen
 level% = 0                       '! nur Pull Down Zeile
 punkt% = 0                       '! 1. Menpunkt

DO WHILE 1                        '! Endlosschleife
 nr% = punkt%
 status% = 1                      '! Exit bei Cursor down
 CALL PullMenu(MEN$(),items%,white%,blue%,xpos%(),status%,nr%)
 punkt% = nr%

 IF status% < 0 THEN               '! Fehler beim Aufruf?
  CLS
  IF status% = -1 THEN
   PRINT "Fehler: Menbibliothek nicht initialisiert"
  ELSE
   PRINT "Fehler: Menzeile pat nicht auf Bildschirm"
  END IF
  END
 END IF

 IF status% = 1 THEN               '! ESC gedrckt?
  IF level% = 0 THEN               '! EXIT
   CLS
   END
  ELSE
   CALL CloseBox (buff2%())        '! clear Pull Down Box
   level% = 0
  END IF
 END IF

'! Selektion eines Menpunktes in der Menzeile
'! klappe Men auf

 IF ((status% = 0) OR (status% = 3)) AND (level% = 0) THEN
  SELECT CASE punkt%

   CASE = 1                         '! 1. Pull Down Men
    level% = 1
    MEN2$(1) = "Load     "
    MEN2$(2) = "Save"
    MEN2$(3) = "List"
    nr% = 1
    status% = 1                      '! Exit bei Cursor rechts/links
    CALL PopMenu(xpos%(punkt%),2,MEN2$(),3,white%,blue%,"","",1,status%,nr%)
    IF status% < 0 THEN             '! Fehler beim Aufruf?
     CLS
     PRINT "Fehler: Menbox pat nicht auf Bildschirm"
     END
    ELSE
     SELECT CASE status%
      CASE = 0                      '! RETURN?
       LOCATE 10,2
       PRINT "Auswahl "; punkt%; ":"; nr%
       PRINT "Bitte eine Taste bettigen"
       DO WHILE INKEY$ = "":WEND
      CASE ELSE
       CALL CloseBox(buff2%())      '! Schliee Box
       level% = 0
       IF status% = 3 THEN          '! Cursor rechts
	punkt% = punkt% + 1
	IF punkt% > items% THEN punkt% = 1
       ELSEIF status% = 2 THEN      '! Cursor links
	punkt% = punkt% - 1
	IF punkt% <= 0 THEN punkt% = items%
       END IF
      END SELECT
    END IF

   CASE = 2
    level% = 1
    MEN2$(1) = "Cut"
    MEN2$(2) = "Paste"
    nr% = 1
    status% = 1                      '! Exit bei Cursor rechts/links
    CALL PopMenu(xpos%(punkt%),2,MEN2$(),2,white%,blue%,"","",1,status%,nr%)
    IF status% < 0 THEN             '! Fehler beim Aufruf?
     CLS
     PRINT "Fehler: Menbox pat nicht auf Bildschirm"
     END
    ELSE
     SELECT CASE status%
      CASE = 0                      '! RETURN?
       LOCATE 10,2
       PRINT "Auswahl "; punkt%; ":"; nr%
       PRINT "Bitte eine Taste bettigen"
       DO WHILE INKEY$ = "":WEND
      CASE ELSE
       CALL CloseBox(buff2%())      '! Schliee Box
       level% = 0
       IF status% = 3 THEN          '! Cursor rechts
	punkt% = punkt% + 1
	IF punkt% > items% THEN punkt% = 1
       ELSEIF status% = 2 THEN      '! Cursor links
	punkt% = punkt% - 1
	IF punkt% <= 0 THEN punkt% = items%
       END IF
      END SELECT
    END IF

   CASE 3                             '! Exit
    CLS
    END
  END SELECT
 END IF
WEND

END

'! Routinen zur Mensteuerung einbinden

$INCLUDE "menu.inc"

'! Ende
