'*********************************************************
'! File       : SCREE.BAS
'! Vers.      : 1.0
'! Last Edit  : 11.7.92
'! Autor      : G. Born
'! Progr. Spr.: Power Basic
'! Betr. Sys. : DOS 2.1 - 5.0 (DR-DOS 5.0/6.0)
'! Funktion: Das Programm wird mit der Eingabe:
'!
'!           SCREEN
'!
'!           aufgerufen. Es demonstriert die Verwendung
'!           der Routinen zur Bildschirmsteuerung (INT10.INC).
'**********************************************************
'!
DIM MEN$(7)                            '! Mentexte
nr% = 1                                '! Zeilennr. Cursor
DIM buff1%(600)                        '! temporre Puffer
DIM buff2%(500)                        '! max. 2000 Elemente
black% = 0                             '! Farben
white% = 7

CALL SetMode (3)                     '! 80 x 25 Zeichen

'! Bildschirm lschen und mit Zeichen fllen

CLS
FOR i% = 1 TO 1999: PRINT ""; : Next i% '! Screen fllen

'!-----------------------------------------------------
'! Init Variable des Mensystems, der Bildschirmadapter
'! liegt bei Coloradaptern bei Segmentadr. B800H,
'!-----------------------------------------------------

CALL MenuInit (&HB800)             '! Init Variable

done% = 0                          '! Hilfsflag lschen

DO WHILE 1                         '! Schleife ber Mensystem

 Kopf$ = ("INT10 Demo")            '! Titeltext fr Menbox
 MEN$(1) = "Cursor Size 1"         '! Texte fr Men definieren
 MEN$(2) = "Cursor Size 2"
 MEN$(3) = "Scroll Demo"
 MEN$(4) = "Exit"

'!-----------------------------------------------------
'! Aufruf des Hauptmens mit Kopftext ohne Futext, 7 entries
'! als erstes mu der Fensterbereich gesichert werden
'! Achtung: dies darf nur 1 x erfolgen, deshalb Flag done
'!-----------------------------------------------------

 IF done% = 0 THEN                 '! Box offen?
  CALL OpenBox(8,10,MEN$(),4,kopf$,"",buff1%())
  done% = 1                        '! markiere offene Box
 END IF

 status% = 0
 CALL PopMenu(8,10,MEN$(),4,white%,black%,kopf$,"",1,status%,nr%)
 tmp% = nr%                        '! merke Selektion
 IF status% < 0 THEN               '! Fehler beim Aufruf?
  CLS
  PRINT "Fehler: Menbox pat nicht auf Bildschirm"
  END
 ELSE
  IF status% = 1 THEN              '! ESC gedrckt?
   CALL CloseBox(buff1%())         '! Schliee Box
   END                             '! Ja -> Exit
  END IF
 END IF

'! werte selektierten Menpunkt in nr% aus
'! status% = 2 oder 3 wird hier ignoriert und
'! wirkt daher wie RETURN !!!!

 IF (nr% = 1) OR (nr% = 2) THEN

'!-----------------------------------------------------
'! baue ein Textfenster mit dem Cursor auf
'!-----------------------------------------------------

   MEN$(1) = "Cursor :     "      '! Texte fr Men definieren

   CALL OpenBox(25,10,MEN$(),1,"","",buff2%())
   CALL TextBox(25,10,MEN$(),1,white%,black%,"","Exit -> ESC",1,status%)
   IF status% < 0 THEN               '! Fehler beim Aufruf?
    CLS
    PRINT "Fehler: Textbox pat nicht auf Bildschirm"
    END
   END IF

   CALL SetCursor (32,9)
   IF nr% = 1 THEN
    CALL CursorSize (1,2)             '! Cursorgre 1
   ELSE
    CALL CursorSize (1,7)             '! Cursorgre 2
   END IF

   DO WHILE INKEY$ = "" : WEND       '! warte auf Input

   CALL CloseBox(buff2%())                  '! close Submen

 ELSEIF nr% = 3 THEN

   head$ = "Scroll-Demo"           '! Titeltext fr Menbox
   fuss$ = "Exit->ESC"             '! Futext fr Menbox
   MEN$(1) = " "              '! Texte fr Men definieren
   MEN$(2) = "Scroll Demo"
   MEN$(3) = "Scroll Demo"
   MEN$(4) = "Scroll Demo"
   MEN$(5) = "Scroll Demo"
   MEN$(6) = " "

'! Aufruf des Mens
   CALL OpenBox(25,10,MEN$(),6,head$,fuss$,buff2%())
   CALL TextBox(25,10,MEN$(),6,white%,black%,head$,fuss$,1,status%)
   IF status% < 0 THEN               '! Fehler beim Aufruf?
    CLS
    PRINT "Fehler: Menbox pat nicht auf Bildschirm"
    END
   END IF

   flag% = 0
   DO WHILE INKEY$ <> CHR$(27)
    IF flag% = 0 THEN
     CALL Scroll (26, 11, 36, 15, -1, 4)
     flag% = 1
    ELSE
     CALL Scroll (26, 11, 36, 15, 1, 4)
     flag% = 0
    END IF
    DELAY 1
   WEND

   CALL CloseBox(buff2%())

  nr% = tmp%
 ELSE
  CALL CloseBox(buff1%())
  END
 END IF
WEND

 CALL CloseBox(buff1%())

END
'! Routine Textbox

SUB TextBox (x%, y%, text$(1), items%, fcol%, bcol%, title$, foot$, style%, status%)
'!----------------------------------------------------
'!  Subroutine fr Textausgabe
'!
'!  Die Routine gibt die Textbox mit dem Text aus.
'!
'! x%, y%   Anfangskoordinaten linke obere Ecke
'! text$()  Texte mit Menpunkten
'! items%   Zahl der Menpunkte
'! title$   Text Kopfzeile
'! foot$    Text Fuzeile
'! style%   Rahmentyp (1 = einfach, 2 = doppelt, sonst blank
'! fcol%    Vordergrundfarbe
'! bcol%    Hintergrundfarbe
'! status%  Ergebnis des Aufrufes:
'!          -2 Fehler: Initialisierung fehlt
'!          -1 Fehler: Box pat nicht auf Bildschirm
'!           0 ok
'!----------------------------------------------------

LOCAL maxlen%, i%, flag%
LOCAL lo$, lu$, ro$, ru$, li$, lup$
SHARED xmax%, ymax%, initflg%

'! prfe ob INIT durchgefhrt

 IF initflg% <> 1 THEN
  status% = -2
  EXIT SUB
 END IF

'! Emittle Lnge des Menpunktes

 CALL GetMaxLen (text$(),items%, title$, foot$, maxlen%)

'! Pat das Men auf den Bildschirm ?

 IF (x% + maxlen% + 2) > xmax% THEN
  status% = -1
  EXIT SUB
 END IF

 IF (y% + items% + 2) > ymax% THEN
  status% = -1
  EXIT SUB
 END IF

'! Rahmentyp setzen

 CALL MenuLine(lo$,lu$,ro$,ru$,li$,lup$,style%)

'! Rahmen zeichnen

 COLOR fcol%,bcol%
 LOCATE y%, x%                     '! linke obere Ecke
 PRINT lo$;
 IF (LEN(title$) > 0) THEN
  PRINT title$;                    '! Titel Textbox
 END IF
 IF LEN(title$) < maxlen% THEN
  FOR i% = LEN(title$) TO maxlen%-1 : PRINT li$; : NEXT i%
 END IF
 PRINT ro$

 FOR i% = 1 TO items%
  LOCATE (y%+i%), x%
  PRINT lup$;
  CALL PutLine (text$(i%),maxlen%)
  PRINT lup$
 NEXT i%

 LOCATE (y%+items%+1), x%
 PRINT lu$;
 IF (LEN(foot$) > 0) THEN
  PRINT foot$;                       '! Futext
 END IF
 IF LEN(foot$) < maxlen% THEN
  FOR i% = LEN(foot$) TO maxlen%-1 : PRINT li$; : NEXT i%
 END IF
 PRINT ru$

 status% = 0

END SUB

'! Libs einbinden

$INCLUDE "MENU.BAS
$INCLUDE "INT10.INC"

'! Ende
