'*********************************************************
'! File       : SHOW.BAS
'! Vers.      : 1.0
'! Last Edit  : 6. 5.92
'! Autor      : G. Born
'! Files      : INPUT, OUTPUT
'! Progr. Spr.: POWER Basic
'! Betr. Sys. : DOS 2.1 - 5.0
'! Funktion: Das Programm liest eine Textdatei ein und gibt
'!           diese auf dem Bildschirm aus. Dabei kann angegeben
'!           werden, wieviele Zeilen vom Textende oder -anfang
'!           angezeift werden (max. 99).
'!
'!           /L=+xx   Anzeige des Dateianfangs
'!           /L=-xx   Anzeige des Dateiendes
'!           /N       Zeilennumerierung
'!           /M       More Option
'!
'! Aufruf:   SHOW                               '! Interaktiv Mode
'!           SHOW <datei1> <optionen>           '! Kommando Mode
'**********************************************************
'! Variable definieren
%true = &HFFFF: %false = 0            '! Konstante
ein% = 1                              '! Kanal fr I/O
options$ = ""                         '! Optionen
more% = %false                        '! More Option aus
linenr% = %false                      '! Zeilennummern aus
%max = 99
DIM buff$(0:%max-1)                   '! Puffer Lesedatei
DIM buffz&(0:%max-1)                  '! Puffer Zeilennummern
outz% = 0                             '! Ausgaben /L=...
zeile& = 0                            '! bearbeitete Zeilen
%maxscr = 20                          '! Zeilen pro Screen
scrline& = 0                          '! aktuelle Bildzeile

ptr% = 0: hilf% = 0                   '! Hilfszeiger


ON ERROR GOTO fehler

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! Interaktiv Mode ?
 CLS                                  '! ja -> Clear Screen
'! #####   Kopf ausgeben  ######
 PRINT "S H O W                       (c) Born Version 1.0"
 PRINT
 PRINT "Optionen : [ /L=+xx   Anzeige n Zeilen am Dateianfang   ]"
 PRINT "           [ /L=-xx   Anzeige n Zeilen am Dateiende     ]"
 PRINT "           [ /N       Zeilennumerierung  /M  More Ein   ]"
 PRINT
 INPUT "Eingabedatei : ",infilename$  '! lese Dateiname Eingabe
 INPUT "Optionen     : ",options$     '! lese Optionen
 PRINT
ELSE                                  '! Kommando Mode
 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "S H O W                       (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf:   SHOW"
  PRINT "          SHOW <datei1> <optionen>"
  PRINT
  PRINT "Das Programm gibt n Zeilen am Anfang oder Ende einer Text-"
  PRINT "datei aus. Optionen:"
  PRINT
  PRINT "/L=+xx   Anzeige n Zeilen vom Dateianfang"
  PRINT "/L=-xx   Anzeige n Zeilen vom Dateiende"
  PRINT "/N       Zeilennumerierung"
  PRINT "/M       More-Option"
  PRINT
  SYSTEM
 END IF
'!
'! getfile separiert den Dateinamen aus der Kommandozeile
'! Falls ein Name fehlt, wrden die Optionen in die jeweilige
'! Variable gespeichert. Dies ist abgefangen, da Optionen mit
'! /.. beginnen. Dann wird ein Leerstring zurckgegeben
'!
 kommando$ = UCASE$(kommando$) + " "  '! Blank als Endeseparator
 ptr% = 1                             '! Parameter holen
 CALL getfile(ptr%, kommando$,infilename$) '! Name Eingabedatei
 INCR ptr%                            '! Anfang next token
 hilf% = INSTR(kommando$,"/")         '! suche Optionen
 IF hilf% >= ptr% THEN                '! gefunden ?
  options$ = MID$(kommando$,hilf%)    '! Reststring mit Optionen
 END IF
END IF

IF infilename$ = "" THEN              '! Leereingabe ?
 PRINT "Der Name der Eingabedatei fehlt"
 END
END IF

OPEN infilename$ FOR INPUT AS #ein%   '! ffne Eingabedatei

IF LEN(options$) > 0 THEN
 GOSUB getswitch                      '! lese Optionen
END IF

'!
'! bearbeite Datei je nach Option
'!

PRINT                                 '! Leerzeile
IF more% THEN CLS                     '! clear Screen bei More

SELECT CASE outz%

CASE > 0
 CALL anfang(outz%)                   '! L=+xx Option

CASE = 0
'!---------------------------------------------------------
'! kopiere komplette Textdatei auf Screen
'!---------------------------------------------------------

 WHILE NOT (EOF(ein%))
  INCR zeile&                         '! laufende Zeilennummer
  LINE INPUT #ein%, buff$(1)          '! lese eine Zeile
  INCR scrline&                       '! Bildzeile + 1
  IF more% THEN CALL newscreen        '! Bildwechsel bei More ?
  IF linenr% THEN PRINT zeile&;" ";   '! Zeilennr. ausgeben
  PRINT buff$(1)                      '! anzeigen
 WEND

CASE < 0
 CALL ende (outz%)

END SELECT

CLOSE                                  '! Datei schlieen

END

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in SHOW
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";infilename$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
END                                 '! MSDOS Exit
RETURN

getswitch:
'--------------------------------------------------------
'! decodiere eingegebene Optionen
'! /M= more   /N= Zeilennummern
'! /L=+xx Textanfang   /L=-xx Textende
'--------------------------------------------------------

 options$ = UCASE$(options$)         '! in Grobuchstaben

 IF INSTR(options$,"/M") > 0 THEN
  more% = %true                        '! More Mode ein
 END IF

 IF INSTR(options$,"/N") > 0 THEN      '! Linenr. Option ?
  linenr% = %true                      '! Zeilennumerierung ein
 END IF

 ptr% = INSTR(options$,"/L=")          '! Anfang oder Ende Text
 IF ptr% > 0 THEN
  CALL getval(options$,ptr%+3,outz%)   '! lese Zahl
  IF outz% > %max THEN outz% = %max    '! begrenze Wert
  IF outz% < -%max THEN outz% = - %max '! auf +99 bis -99

 END IF

RETURN

SUB getval(text$,ptr%,result%)
'--------------------------------------------------------
'! decodiere Eingabewert als Dezimalzahl
'--------------------------------------------------------
LOCAL tmp%, zchn$, leng%, sign%

sign% = 1                             '! Vorzeichen +
tmp% = 0                              '! Hilfsvariable

leng% = LEN(text$)

CALL skipblank(ptr%,text$)            '! berlese Leerzeichen
zchn$ = MID$(text$,ptr%,1)            '! separ. Zeichen
IF zchn$ = "+" THEN
 INCR ptr%                            '! auf 1. Ziffer
ELSEIF zchn$ = "-" THEN               '! Vorzeichen ?
 sign% = -1                           '! Vorzeichen  -
 INCR ptr%                            '! auf 1. Ziffer
END IF

zchn$ = MID$(text$,ptr%,1)            '! separ. Zeichen

WHILE (zchn$ >= "0") AND (zchn$ <= "9")_
 AND (ptr% <= leng%)                  '! n Ziffern
 tmp% = tmp% * 10 + VAL(zchn$)        '! Ziffer holen
 INCR ptr%                            '! nchstes Zeichen
 zchn$ = MID$(text$,ptr%,1)           '! lese Zeichen
WEND
result% = tmp% * sign%                '! Vorzeichen

END SUB


SUB getfile(ptr%,text$,result$)
'!---------------------------------------------------------
'! separiere Filename aus Eingabetext (text$)
'! ptr% -> Anfang Filename, result$ = Filename
'!---------------------------------------------------------
LOCAL tmp%

CALL skipblank (ptr%,text$)            '! entferne Blanks
tmp% = INSTR(ptr%,text$," ")           '! suche Separator
IF tmp% = 0 THEN
 PRINT "Fehler: kein Fileseparator"    '! kein Endeseparator
 END                                   '! Exit
END IF
IF MID$(text$,ptr%,1) = "/" THEN       '! Optionen eingegeben ?
 result$ = ""                          '! Leerstring
ELSE
 result$ = MID$(text$,ptr%,tmp%-ptr%)  '! Filename
 ptr% = tmp%                           '! korrigiere ptr%
END IF

END SUB

SUB anfang(maxzeile%)
'!---------------------------------------------------------
'! kopiere Textanfang bis maxzeile auf Screen
'!---------------------------------------------------------

SHARED more%, zeile&, ein%, scrline&, linenr%
SHARED buff$()

WHILE NOT (EOF(ein%))
 INCR zeile&                          '! laufende Zeilennummer
 IF zeile& > maxzeile% THEN
  EXIT SUB                            '! ready
 END IF

 LINE INPUT #ein%, buff$(1)           '! lese eine Zeile
 INCR scrline&                        '! Bildzeile + 1
 IF more% THEN CALL newscreen         '! Bildwechsel bei More ?
 IF linenr% THEN PRINT zeile&;" ";    '! Zeilennr. ausgeben
 PRINT buff$(1)                       '! anzeigen
WEND

END SUB

SUB ende (maxzeile%)
'!---------------------------------------------------------
'! kopiere Ende der Textdatei auf Screen. Hierzu werden
'! %max Zeilen in einen Umlaufpuffer geschrieben. Am Datei-
'! ende liegen dann die letzten Zeilen vor und lassen sich
'! einfach ausgeben.
'!---------------------------------------------------------

LOCAL ptr%, count%
SHARED more%, zeile&, ein%, buff$(), scrline&
SHARED linenr%, buffz&()

ptr% = 0                              '! Zeiger auf Buffer
count% = 0                            '! keine Eintrge
maxzeile% = -maxzeile%                '! Betrag bilden

WHILE NOT (EOF(ein%))                 '! lese Datei
 INCR zeile&                          '! laufende Zeilennummer
 IF count% < %max THEN INCR count%    '! zhle bis %max
 LINE INPUT #ein%, buff$(ptr%)        '! lese eine Zeile
 buffz&(ptr%) = zeile&                '! merke Zeilennummer
 ptr% = (ptr% + 1) MOD %max           '! ptr auf next entry
WEND

'!
'! Text aus dem Ringbuffer ausgeben, count definiert die Satzzahl
'! falls der Puffer nicht voll ist, findet sich der 1. Satz
'! in buff$(0), sonst steht er in buff$(ptr%)
'!

IF count% < %max THEN                 '! Puffer voll ?
 ptr% = ptr% - maxzeile%              '! nein -> auf Anfang
 IF ptr% < 0 THEN ptr% = 0
ELSE
 ptr% = ptr% - maxzeile%              '! Position im Ringpuffer
 IF ptr% < 0 THEN ptr% = ptr% + %max  '! berechnen
END IF                                '! ja -> ptr% lassen
IF count% > maxzeile% THEN            '! Ausgabezahl auf
 count% = maxzeile%                   '! /L=-xx begrenzen
END IF

scrline& = 0
WHILE count% > 0                      '! Stze ausgeben
 INCR scrline&
 IF more% THEN CALL newscreen         '! Bildwechsel bei More ?
 IF linenr% THEN PRINT buffz&(ptr%);" ";'! Zeilennr. ausgeben
 PRINT buff$(ptr%)                    '! anzeigen
 ptr% = (ptr% + 1) MOD %max           '! next entry
 DECR count%                          '! 1 Zeile weniger
WEND

END SUB

SUB newscreen
'---------------------------------------------------------
'! More Abfrage bei vollem Bildschirm
'---------------------------------------------------------
SHARED scrline&

IF scrline& > %maxscr THEN
 PRINT
 PRINT "Weiter, bitte eine Taste bettigen ..."
 WHILE LEN(INKEY$) = 0                '! warte auf Taste
 WEND
 scrline& = 0                         '! auf 1. Zeile
 CLS                                  '! clear Screen
END IF

END SUB

SUB skipblank(ptr%,text$)
'!---------------------------------------------------------
'! entferne fhrende Leerzeichen aus text$
'!---------------------------------------------------------

LOCAL lang%, zchn$

lang% = LEN (text$)                    '! Stringlnge
zchn$ = MID$(text$,ptr%,1)             '! separiere Zeichen

WHILE (zchn$ = " ") AND (ptr% <= lang%) '! Zeichen <> blank
 INCR ptr%
 zchn$ = MID$(text$,ptr%,1)            '! separiere Zeichen
WEND

END SUB

'***** Programm Ende ******
