' *********************************************************
' File       : SPOOL.BAS
' Vers.      : 1.0
' Last Edit  : 28.4.92
' Autor      : G. Born
' File I/O   : INPUT, OUTPUT, FILE, PRINTER
' Progr. Spr.: POWER BASIC
' Betr. Sys. : DOS 3.0 - 5.0
' Funktion: Das Programm dient zur Ausgabe von Listings mit
'           Seitennummern, Datum, Dateinamen und einer whl-
'           baren Zeilennumerierung. Weiterhin wird nach n
'           Zeilen ein Papiervorschub auf dem Drucker ausge-
'           lst. Es lassen sich beliebige Textdateien mit
'           diesem Programm ausgeben.
'
' Aufruf:   SPOOL Filename /Optionen
'           Optionen:  /N   Zeilennumerierung ein  [Aus]
'                      /Lxx linker Rand            [ 0 ]
'                      /Rxx rechter Rand           [75 ]
'                      /Zxx Zeilen pro Seite       [60 ]
'
'           Die Werte in [] geben die Standardeinstellung
'           wieder. Wird das Programm ohne Parameter aufge-
'           rufen, sind Dateiname und Optionen explizit ab-
'           zufragen. Das Programm erzeugt eine Datei mit
'           dem Namen der Eingabedatei und der Extension TMP.
'           Anschlieend wird diese Datei mit Hilfe des DOS
'           Spoolers PRINT im Hintergrund ausgegeben.
' **********************************************************
' Variable definieren
%on = 1: %off = 0
nummer% = %off                        '! keine Zeilennummern
zeile& = 0                            '! Zeilennummer Listing
seite% = 1                            '! Seitennummer Listing
maxzeile% = 60                        '! Zeilen pro Seite
rechts% = 75                          '! rechter Rand
links% = 0                            '! linker Rand
spalte% = 0                           '! Einrckung

indatei% = 1                          '! Dateinummer Eingabe
outdatei% = 2                         '! Dateinummer Ausgabe

ON ERROR GOTO fehler                  '! Fehlerausgang

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

GOSUB install                         '! PRINT installiert?

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! User Mode ?
 CLS                                  '! clear Screen

 PRINT "S P O O L                              (c) Born Version 1.0"
 PRINT
 PRINT "Optionen [ /L=00 linker Rand         /R=75  rechter Rand   ]"
 PRINT "         [ /Z=60 Zeilen pro Seite    /N  Zeilennumerierung ]"
 PRINT
 INPUT  "File     : ",filename$
 INPUT  "Optionen : ",options$
 PRINT
ELSE

 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "S P O O L                    (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: SPOOL <Filename> <Optionen>"
  PRINT
  PRINT "Optionen :"
  PRINT
  PRINT "  /L=00 setzt den linken Rand"
  PRINT "  /R=75 setzt den rechten Rand"
  PRINT "  /Z=60 setzt die Zeilenzahl pro Seite"
  PRINT "  /N    schaltet die Zeilennumerierung ein"
  PRINT
  PRINT "Das Programm gibt ein Listing der Datei aus, wobei sich"
  PRINT "die Rnder und die Zahl der Zeilen einstellen lt. Die"
  PRINT "Ausgabe erfolgt in eine Datei, die per PRINT ausgedruckt"
  PRINT "wird."
  PRINT
  SYSTEM
 END IF
				      '! Kommando Mode
 ptr% = INSTR (kommando$,"/")         '! Optionen ?
 IF ptr% = 0 THEN
  filename$ = kommando$               '! nur Filename
 ELSE
  filename$ = LEFT$(kommando$,ptr% -1) '! Filename separieren
  options$  = MID$(kommando$,ptr%)    '! Optionen separieren
 END IF
END IF

GOSUB parameter                       '! Optionen decodieren

IF (rechts% < links%) or (maxzeile% < 10) THEN '! sinnlose
 PRINT                                         '! Einstellung
 PRINT "Bitte Randeinstellung neu setzen"      '! Fehlerexit
 END                                  '! Exit
END IF

IF filename$ = "" THEN                '! Leereingabe ?
 PRINT
 PRINT "Der Dateiname fehlt"
 END                                  '! Exit
END IF

ptr% = INSTR(filename$,".")           '! hat Datei eine Extension?
IF ptr% > 0 THEN
 outfile$ = LEFT$(filename$,ptr%) + "TMP" '! Filename ohne Extension
ELSE
 outfile$ = filename$ + ".TMP"        '! Extension anhngen
END IF

'! falls TEMP-Verzeichnis existiert, lege Ausgabedatei dort an.
outfile$ = ENVIRON$("TEMP") + "\"+ outfile$

' prfe ob Datei vorhanden, nein -> exit

OPEN filename$ FOR INPUT AS #indatei%  '! ffne Eingabedatei
OPEN outfile$ FOR OUTPUT AS #outdatei% '! ffne Ausgabedatei
PRINT
PRINT "Die Datei: ";filename$;" wird bearbeitet"

GOSUB pageskip                        '! Seitenkopf ausgeben

WHILE NOT (EOF(indatei%))             '! Datei sequentiell lesen
 LINE INPUT #indatei%, linie$         '! lese Zeile
 GOSUB ausgabe                        '! drucke Zeile
WEND

CLOSE #indatei%                       '! Datei schlieen
CLOSE #outdatei%                      '! Datei schlieen
PRINT
PRINT "Die Datei: ";filename$;" wird auf dem Drucker ausgegeben "
GOSUB spool                           '! aktiviere Print
END

'#########################################################
'#                   Hilfsroutinen                       #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in SPOOL
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";filename$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
END                                 '! MSDOS Exit
RETURN

parameter:
'---------------------------------------------------------
'! Decodiere die Eingabeoptionen
'---------------------------------------------------------
ptr% = INSTR (options$,"/N")
IF ptr% > 0 THEN nummer% = %on        '! Zeilennumerierung

ptr% = INSTR (options$,"/Z=")
IF ptr% > 0 THEN CALL getval (maxzeile%) '! Zeilen / Seite
szeile% = maxzeile% + 1               '! Zeilennr Seite wechseln

ptr% = INSTR (options$,"/L=")
IF ptr% > 0 THEN CALL getval (links%) '! linker Rand

ptr% = INSTR (options$,"/R=")
IF ptr% > 0 THEN CALL getval (rechts%) '! rechter Rand

RETURN

SUB getval (wert%)
'---------------------------------------------------------
'! Decodiere den Eingabestring in eine Zahl
'---------------------------------------------------------
 SHARED options$, ptr%
 LOCAL i%

 ptr% = ptr% + 3                      '! ptr hinter /x=
 i% = 1
 WHILE ((ptr%+i%) =< LEN (options$)) and (MID$(options$,ptr%+i%,1) <> " ")
  i% = i% + 1                         '! Ziffernzahl + 1
 WEND
 wert% = VAL(MID$(options$,ptr%,i%))  '! decodiere die Zahl
END SUB

pageskip:
'---------------------------------------------------------
'! Seitenvorschub mit Kopf (Dateiname, Datum, Seite)
'---------------------------------------------------------
 IF szeile% < maxzeile% THEN RETURN   '! kein Seitenwechsel !!

 IF seite% > 1 THEN                   '! 1. Seite k. Vorschub
  PRINT #outdatei%, CHR$(12)          '! Vorschub
  szeile% = 3                         '! 3 Kopfzeilen
 ELSE
  PRINT #outdatei%, "S P O O L "; options$; SPACE$(27);
  PRINT #outdatei%, "(c) Born Version 1.0"
  szeile% = 4                         '! 4 Kopfzeilen
 END IF
 PRINT #outdatei%, "Datei : ";filename$;"     Datum : ";DATE$;
 PRINT #outdatei%, "         Seite : "; seite%
 PRINT #outdatei%,
 INCR seite%

RETURN


ausgabe:
'--------------------------------------------------------
'! Ausgabe der eingelesenen Zeile auf dem Printer.
'! rest% gibt an, wieviele Zeichen pro Zeile gedruckt
'! werden drfen. Ist die eingelesene Zeile lnger, wird
'! sie auf mehrere Ausgabezeilen aufgeteilt.
'--------------------------------------------------------

 INCR zeile&                          '! Zeile im Listing + 1
 GOSUB pageskip                       '! Seitenvorschub ?

 spalte% = links%                     '! linker Rand
 PRINT #outdatei%, SPACE$(spalte%);   '! auf linken Rand

 IF nummer% = %on THEN                '! Zeilennumerierung ?
  PRINT #outdatei%, USING "###### "; zeile&; '! Zeilennummer drucken
  spalte% = spalte% + 7               '! Spalte 7 setzen
 END IF

 rest% = rechts% - spalte%            '! Restzeilenlnge
 GOSUB skipblank                      '! merke Blanks
 PRINT #outdatei%, LEFT$(linie$,rest%) '! Ausgabe Teilstring
 linie$ = MID$(linie$, rest% + 1)     '! Reststring
 INCR szeile%

 WHILE LEN(linie$) > rest%            '! String > Zeile
  GOSUB pageskip                      '! Seitenvorschub ?
  PRINT #outdatei%, SPACE$(spalte%);  '! linker Rand
  PRINT #outdatei%, LEFT$(linie$,rest%) '! Teilstring ausgeben
  linie$ = MID$(linie$,rest% + 1)     '! Reststring bestimmen
  INCR szeile%                        '! Zeile im Listing + 1
 WEND

 IF LEN(linie$) > 0 THEN
  GOSUB pageskip                      '! Seitenvorschub ?
  PRINT #outdatei%, SPACE$(spalte%);linie$  '! Reststring ausgeben
  INCR szeile%                        '! Zeile im Listing + 1
 END IF
RETURN

skipblank:
'---------------------------------------------------------
'! zhle fhrende Blanks
'---------------------------------------------------------
i% = 1
WHILE (i% < LEN(linie$)) and (MID$(linie$,i%,1) = " ")
 INCR i%
 INCR spalte%
WEND
RETURN

install:
'---------------------------------------------------------
'! prfe den PRINT Installationsstatus
'---------------------------------------------------------

 REG 1, &H0100                         '! AX = 0100 -> check
                                       '! Status
 CALL INTERRUPT &H2F                   '! Multiplexer INT

 IF (REG (1) and &H00FF) <> &HFF THEN  '! PRINT installiert?
  PRINT "Bitte installieren Sie zuerst das MS-DOS Programm:"
  PRINT "PRINT"
  PRINT
  END                                   '! Exit
 END IF

RETURN

spool:
'---------------------------------------------------------
'! aktiviere PRINT um die Datei xxx.TMP zu drucken
'---------------------------------------------------------

SHELL "PRINT " + outfile$             '! Spool Datei
RETURN
' ###### Programm Ende #########
END
