' *********************************************************
' File       : TEXTS.BAS
' Vers.      : 1.0
' Last Edit  : 20. 4.92
' Autor      : G. Born
' File I/O   : INPUT, OUTPUT, FILE, PRINTER
' Progr. Spr.: POWER BASIC
' Betr. Sys. : DOS 2.1 - 5.0
' Funktion: Das Programm liest beliebige Binrdateien ein
'           und versucht daraus Texte zu extrahieren und
'           anzuzeigen.
'
' Aufruf:   TEXTS Filename /Optionen
'           Optionen:  /L=XX min. Wortlnge        [ 3 ]
'
'           Die Werte in [] geben die Standardeinstellung
'           wieder. Wird das Programm ohne Parameter aufge-
'           rufen, sind Dateiname und Optionen explizit ab-
'           zufragen. Mit dem Aufruf:
'
'              TEXTS /?
'
'           wird ein Hilfsbildschirm ausgegeben.
' **********************************************************
' Variable definieren
%on = 1: %off = 0
txt$ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
txt$ = txt$ + "abcdefghijklmnopqrstuvwxyz"
txt$ = txt$ + " -_+#!$%&/(){}*><[]?'`';,"

datei% = 1
lang% = 3                             '! 3 Zeichen fr Wort

ON ERROR GOTO fehler                  '! Fehlerausgang

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! User Mode ?
 CLS                                  '! clear Screen

 PRINT "T e x t s                           (c) Born Version 1.0"
 PRINT
 PRINT "Optionen [ /L=03 minimale Zeichenzahl pro Wort   ]"
 PRINT
 INPUT  "File     : ",filename$
 INPUT  "Optionen : ",options$
 PRINT
ELSE
 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "T e x t s                    (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: TEXTS <Filename> <Optionen>"
  PRINT
  PRINT "Optionen :"
  PRINT
  PRINT "  /L=3  min. Zeichen pro Wort"
  PRINT
  PRINT "Das Programm liest eine Binrdatei ein und gibt alle"
  PRINT "Texte aus, die mehr als n Zeichen (/L=xx) enthalten."
  PRINT
  SYSTEM
 END IF
				      '! Kommando Mode
 ptr% = INSTR (kommando$,"/")         '! Optionen ?
 IF ptr% = 0 THEN
  filename$ = kommando$               '! nur Filename
 ELSE
  filename$ = LEFT$(kommando$,ptr% -1)'! Filename separieren
  options$  = MID$(kommando$,ptr%)    '! Optionen separieren
 END IF
END IF

GOSUB parameter                       '! Optionen decodieren

IF (lang% < 2) OR (lang% > 30) THEN   '! sinnlose
 PRINT                                '! Einstellung
 PRINT "Bitte Einstellung fr Lnge neu setzen" '! Fehlerexit
 SYSTEM
END IF

IF filename$ = "" THEN                '! Leereingabe ?
 PRINT
 PRINT "Der Dateiname fehlt"
 SYSTEM
END IF

' prfe ob Datei vorhanden, nein -> exit

OPEN filename$ FOR BINARY AS #datei%

'! ffne Ausgabeeinheit fr I/O-Umleitung
OPEN "CONS:" FOR OUTPUT AS #2

PRINT #2,
PRINT #2, "Die Datei: ";filename$;" wird bearbeitet"

tmp% = 0
text$ = ""

WHILE NOT (EOF(datei%))               '! Datei sequentiell lesen
 GET$ #datei%, 1, zchn$               '! lese 1 Byte aus Binrdatei
 IF (INSTR(txt$,zchn$) > 0) THEN      '! Zeichen gehrt zu Wort
  INCR tmp%                           '! zhle Buchstaben
  text$ = text$ + zchn$               '! merke Zeichen
 ELSE
  IF tmp% >= lang% THEN PRINT #2, (text$) '! gebe Satz aus
  tmp% = 0
  text$ = ""
 END IF
WEND

PRINT
PRINT "Ausgabe beendet"
CLOSE                                 '! Dateien schlieen

END

'#########################################################
'#                   Hilfsroutinen                       #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in TEXTS
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";filename$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
END                                   '! MSDOS Exit

parameter:
'---------------------------------------------------------
'! Decodiere die Eingabeoptionen
'---------------------------------------------------------

ptr% = INSTR (options$,"/L=")
IF ptr% > 0 THEN CALL getval (lang%)  '! min. Zeichen / Wort

RETURN

SUB getval (wert%)
'---------------------------------------------------------
'! Decodiere den Eingabestring in eine Zahl
'---------------------------------------------------------
 SHARED options$, ptr%
 LOCAL i%

 ptr% = ptr% + 3                      '! ptr hinter /x=
 i% = 1
 WHILE ((ptr%+i%) =< LEN (options$)) and (MID$(options$,ptr%+i%,1) <> " ")
  i% = i% + 1                         '! Ziffernzahl + 1
 WEND
 wert% = VAL(MID$(options$,ptr%,i%))  '! decodiere die Zahl
END SUB


' ###### Programm Ende #########
