' *********************************************************
' File       : WC.BAS
' Vers.      : 1.0
' Last Edit  : 7. 5.92
' Autor      : G. Born
' Files      : INPUT
' Progr. Spr.: Power Basic
' Betr. Sys. : MS-DOS 2.1 - 5.0
' Funktion: Das Programm untersucht einen Textfile und
'           gibt die Zahl der Zeichen, Wrter und Zeilen
'           aus. Ein Wort wird nur gezhlt, falls es mehr
'           als einen Buchstaben enthlt. Trennzeichen
'           zwischen Wrtern sind Leerzeichen.
' **********************************************************
' screens und Variable definieren
zeile& = 0                           '! Zeilen im Text
worte& = 0                           '! Worte im Text
char& = 0                            '! Zeichen im Text
leerz& = 0                           '! Leerzeilen
ein% = 3                             '! I/O Kanal
linie$ = ""                          '! Textpuffer
lang% = 0                            '! Zeilenlnge
ptr% = 0

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

ON ERROR GOTO fehler

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! User Mode ?
 CLS                                  '! clear Screen
 PRINT "W C                         (c) Born Version 1.0"
 PRINT
 INPUT  "File : ",filename$
 PRINT
ELSE
 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "W C                       (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: WC <Filename>"
  PRINT
  PRINT "Das Programm analysiert die Textdatei und gibt die Anzahl"
  PRINT "der Zeichen, Wrter und Zeilen aus."
  PRINT
  SYSTEM
 END IF
				      '! Kommando Mode
 filename$ = kommando$               '! nur Filename
END IF

' prfe ob Datei vorhanden, nein -> exit

OPEN filename$ FOR INPUT AS #ein%    '! File ffnen

PRINT "Datei ";filename$;" wird bearbeitet"

WHILE NOT (EOF(ein%))                 '! Datei sequentiell lesen
 LINE INPUT #ein%, linie$             '! lese Zeile
 lang% = LEN (linie$)                 '! Zeichen / Zeile
 char& = char& + lang%                '! count chars
 INCR zeile&                          '! count lines
 IF lang% <= 0 THEN
  INCR leerz&                         '! Zahl der Leerzeilen
 ELSE
  GOSUB getword                       '! count words
 END IF
WEND

CLOSE #ein%                           '! close datei

PRINT
PRINT "Zeichen    :", char&
PRINT "Wrter     :", worte&
PRINT "Zeilen     :", zeile&
PRINT "Leerzeilen :", leerz&
PRINT
END

'#########################################################
'#                   Hilfsroutinen                       #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in WC
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";filename$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
END                                  '! MSDOS Exit
RETURN

getword:
'---------------------------------------------------------
'! zhle die Zahl der Worte in der Zeile
'---------------------------------------------------------

 zahl& = 0                            '! init char count
 FOR i%= 1 TO lang%                   '! scan line
  zchn$ = MID$(linie$,i%,1)           '! separate char
  IF zchn$ <> " " THEN
   INCR zahl&                         '! zhle Buchstaben
  ELSE
   IF zahl& > 1 THEN INCR worte&      '! count words
   zahl& = 0                          '! clear char count
  END IF
 NEXT i%
 IF zahl& > 1 THEN INCR worte&        '! letztes Wort zhlen
RETURN
' ###### Programm Ende #########
