'*********************************************************
'! File       : XCALC.BAS
'! Vers.      : 1.0
'! Last Edit  : 16.5.92
'! Autor      : G. Born
'! Progr. Spr.: Power Basic
'! Betr. Sys. : DOS 2.1 - 5.0 (DR-DOS 5.0/6.0)
'! Funktion: Das Programm wird mit der Eingabe:
'!
'!           XCALC <Ausdruck>
'!
'!           aufgerufen. Es liest den Ausdruck ein und berechnet
'!           das Ergebnis (mu zwischen 0 und 255 liegen) und
'!           gibt dieses in ERRORLEVEL zurck.
'!
'!             XCALC 3+5
'!
'!           Damit lassen sich Berechnungen in Batchdateien
'!           ausfhren.
'**********************************************************
'! Variable definieren
'! globale Konstanten
 %true = -1: %false = 0
 %add = 1: %sub = 2: %mul = 3: %div = 4'! code fr Operationen
'! globale Variablen
 %maxentry = 10
 DIM wertx%(1:%maxentry)               '! Speicher fr 10 Parameter
 DIM opc%(1:%maxentry)                 '!     "     "  10 Operatoren
 wert% = 0                             '! Ergebnis
 errx% = 0                             '! Fehlernummer
 count% = 0                            '! Zahl der Parameter

 lang% = 0                             '! Lnge Eingabetext
 text$ = ""                            '! Eingabetext

 ptr% = 0

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

 ON ERROR GOTO fehler1

 text$ = COMMAND$                     '! Parameter ?

 ptr% = INSTR (text$,"/?")            '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "X C A L C                    (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: XCALC <Ausdruck>"
  PRINT
  PRINT "Das Programm berechnet den angegebenen Ausdruck und"
  PRINT "gibt das Resultat als Fehlercode an DOS zurck."
  PRINT "Die Ergebnisse drfen zwischen 0 und 255 liegen und"
  PRINT "lassen sich mit ERRORLEVEL auswerten. Beispiel:"
  PRINT
  PRINT "XCALC 3 + 5"
  PRINT
  SYSTEM
 END IF

 ptr% = 1
 lang% = LEN(text$)                        '! Lnge Parameterstring

 CALL decode (text$)                       '! berechne Ergebnis

 IF errx% <> 0 THEN                        '! Fehlerabbruch
  PRINT "Fehler im Ausdruck : ";text$
  END 255
 END IF

 IF (wert% > 255) OR (wert% < 0) THEN
  PRINT "Bereichsberlauf Wert : ";wert%    '! Fehlerexit
  END (255)
 ELSE
  END (wert%)
 END IF

END                                          '! Ende

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

SUB decode (text$)

'!---------------------------------------------------------
'! bearbeite Eingabe und berechne Ergebnis
'!---------------------------------------------------------
LOCAL ptr%, l%, flag%

SHARED lang%, count%, errx%, wert%
SHARED wertx%(), opc%()

 ptr% = 1: errx% = 0: count% = 1     '! init locale variable
 WHILE ptr% <= lang%                 '! scan String
  CALL getval (ptr%,wertx%(count%))  '! ermittle 1. Parameter
  IF errx% > 0 THEN EXIT SUB         '! Error Exit
'  IF wertx%(count%) = 0 THEN GOTO ready '! WHILE EXIT
  CALL getop (ptr%,opc%(count%))     '! ermittle 1. Operator
  IF errx% > 0 THEN EXIT SUB         '! Error Exit
  INCR ptr%                          '! hinter Operator
  INCR count%                        '! nchste Zelle
 WEND

 DECR count%                         '! Zahl der Werte

ready:
'! nur 1 Parameter gefunden, oder Leereingabe ?
 IF count% < 2 THEN
  wert% = wertx%(1)
  EXIT SUB
 END IF

'! Punktrechnung "*"  "/" vorziehen !!!
 FOR l% = 1 TO count%-1
  IF opc%(l%) = %mul THEN
   wertx%(l%+1) = wertx%(l%) * wertx%(l%+1)
  ELSE
   IF opc%(l%) = %div THEN
    wertx%(l%+1) = INT(wertx%(l%) / wertx%(l%+1))
   END IF
  END IF
 NEXT l%

'! Strichrechnung "+"  "-" nachziehen !!!
 FOR l% = 1 TO count%-1
  WHILE (opc%(l%) = %mul) OR (opc%(l%) = %div) '! skip A * B  + ...
   INCR l%
  WEND
  j% = l%+1: flag% = %false              '! clear gefunden
  WHILE (opc%(j%) = %mul) OR (opc%(j%) = %div) '! skip A + B * C ...
   INCR j% : flag% = %true               '! setze gefunden
  WEND

  IF opc%(l%) = %add THEN
   wertx%(j%) = wertx%(l%) + wertx%(j%)
  ELSE
   IF opc%(l%) = %sub THEN
    wertx%(j%) = wertx%(l%) - wertx%(j%)
   END IF
  END IF
  IF flag% THEN l% = j%-1
 NEXT l%

' FOR n% = 1 TO count%
'  PRINT "n= ";n%;" wert ";wertx%(n%);" opc "; opc%(n%)
' NEXT n%

 wert% = wertx%(count%)                 '! Endergebnis

END SUB

SUB getval (ptr%, wert%)

'!---------------------------------------------------------
'! lese eine Zahl ein und decodiere sie
'!---------------------------------------------------------

SHARED text$, errx%, count%, lang%, vorz%
LOCAL tmp%, zchn$, first%, last%

 vorz% = 1 : tmp% = 0                '! init Hilfsvariablen

'! suche Anfang und Ende der Zahl
 CALL skipblank  (ptr%,text$)        '! skip fhrende blanks

'! Vorzeichen bearbeiten
 zchn$ = MID$ (text$,ptr%,1)         '! hole Zeichen

 IF (zchn$ = "-") THEN
  vorz% = -1                         '! negative Zahl
  INCR ptr%
 ELSE
  IF (zchn$ = "+") THEN              '! Vorz. berlesen
   INCR ptr%
  END IF
 END IF
 zchn$ = MID$ (text$,ptr%,1)         '! hole Zeichen
 first% = ptr%                       '! merke Anfang Zahl

'! suche Ende der Zahl = " ";"+";"-";"*";"/"
 WHILE (INSTR(" +-*/",zchn$) = 0) AND ptr% <= lang%
  INCR ptr%                          '! hole nchstes Zeichen
  zchn$ = MID$ (text$,ptr%,1)        '! hole Zeichen
 WEND
'! merke Ende der Zahl
 IF ptr% < lang% THEN
  last% = ptr% - 1                   '! auf letzte Ziffer
 ELSE
  last% = lang%                      '! auf Textende
 END IF

 CALL dec1 (first%, last%, wert%)    '! Zahl decodieren

END SUB

SUB getop (ptr%,opcode%)

'!---------------------------------------------------------
'! ermittle operator (+ - * / )
'!---------------------------------------------------------

SHARED errx%, text$, lang%
LOCAL  zchn$, tmp%

 CALL skipblank (ptr%,text$)         '! berlese blanks

 IF ptr% >= lang% THEN
  opcode% = 0                        '! nichts gefunden
  EXIT SUB
 END IF

 zchn$ = MID$(text$,ptr%,1)          '! hole Zeichen
 tmp% = INSTR ("+-*/",zchn$)         '! decodiere Operator

 SELECT CASE tmp%                    '! Zuweisung Opcode

 CASE 1
  opcode% = %add                     '! Addition

 CASE 2
  opcode% = %sub                     '! Subtraktion

 CASE 3
  opcode% = %mul                     '! Multiplikation

 CASE 4
  opcode% = %div                     '! Division

 CASE ELSE
  errx% = 3                          '! ungltiger Operator
  opcode% = 0

 END SELECT

END SUB

SUB skipblank(ptr%,text$)
'---------------------------------------------------------
'! zhle fhrende Blanks in einer Zeichenkette
'! text$ = Zeichenkette, zeiger% = Zeiger in Kette
'---------------------------------------------------------
SHARED lang%

WHILE (ptr% =< lang%) and (MID$(text$,ptr%,1) = " ")
 INCR ptr%
WEND
END SUB


SUB dec1 (first%,last%,wert%)

'!---------------------------------------------------------
'! decodieren der Dezimalzahl
'!---------------------------------------------------------

SHARED text$, vorz%, errx%
LOCAL tmp%, b%

 wert% = 0                        '! init

 FOR b% = first% TO last%         '! alle Ziffern
  zchn$ = MID$(text$,b%,1)        '! hole Ziffer

  '! Achtung VAL funktioniert nicht, da 0 bei Fehler geliefert wird
  tmp% = INSTR ("0123456789",zchn$) '! Wert der Ziffer

'! gltige Ziffer ????
  IF tmp% = 0 THEN
   errx% = 1                      '! Fehlerexit
  ELSE
   tmp% = tmp% - 1                '! Wert korrigieren
   wert% = wert% * 10 + (tmp% * vorz%) '! Ziffer auf Zahl addieren
  END IF
 NEXT b%

END SUB

fehler1:
'!---------------------------------------------------------
'! Abfangroutine fr Power Basic Fehler
'!---------------------------------------------------------

IF ERR = 6 THEN
 PRINT "Overflow Error";                '! Fehlermeldung
ELSE
 PRINT "Fehler : ";ERR;
END IF

END
RETURN

'!***** Programm Ende ******
