'*********************************************************
'! File       : XFORM.BAS
'! Vers.      : 1.0
'! Last Edit  : 2. 5.92
'! Autor      : G. Born
'! Files      : INPUT, OUTPUT
'! Progr. Spr.: Power Basic 2.x
'! Betr. Sys. : DOS 2.1 - 5.0 (+ DR-DOS 5.0/6.0)
'! Funktion: Das Programm liest eine Power Basic Quellcodedatei
'!           ein und rckt alle Anweisungen zwischen
'!
'!              FOR        NEXT
'!              DO         LOOP
'!              WHILE      WEND
'!              IF/THEN    ELSEIF / END IF
'!
'!           ein.
'!
'! Aufruf:   XFORM Filename1 Filename2
'!
'!           Wird das Programm ohne Parameter aufgerufen, sind die
'!           Dateinamen explizit abzufragen.
'**********************************************************
'! Variable und Konstanten definieren
%true = &HFFFF: %false = 0
spalte% = 0                           '! Einrckung
indent% = 2                           '! Einrck. pro Stufe
remflg% = %false                      '! Kommentar gefunden
lang% = 0                             '! Lnge Zeile
lev1% = 0                             '! Level
lev2% = 0
ein% = 1                              '! Dateinummer Eingabe
aus% = 2                              '! Dateinummer Ausgabe

ON ERROR GOTO fehler                  '! Fehlerausgang

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! User Mode ?
 CLS                                  '! clear Screen

 PRINT "X F O R M                          (c) Born Version 1.0"
 PRINT
 INPUT  "Eingabedatei: ",filename1$
 INPUT  "Ausgabedatei: ",filename2$
 INPUT  "Option      : ",kommando$
 PRINT
ELSE                                  '! Kommando Mode
 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "X F O R M                      (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: XFORM <Eingabefile> <Ausgabefile> </L>"
  PRINT
  PRINT "XFORM liest eine Power Basic Quelldatei ein und rckt die"
  PRINT "Anweisungen zwischen:
  PRINT
  PRINT "       FOR        NEXT"
  PRINT "       DO         LOOP"
  PRINT "       WHILE      WEND"
  PRINT "       IF/THEN    ELSEIF / END IF"
  PRINT "       SUB        END SUB"
  PRINT
  PRINT "ein. Dadurch entsteht ein formtiertes Listing, welches sich"
  PRINT "besser lesen lt. ber die Option /L kann die Schachtelungs-"
  PRINT "jeder Zeile ausgegeben werden."
  PRINT
  SYSTEM
 END IF

'! separiere Filenamen

 ptr% = 1                                  '! Parameter holen
 CALL getfile(ptr%, kommando$,filename1$)  '! Name Eingabedatei1
 INCR ptr%
 CALL getfile(ptr%, kommando$,filename2$)  '! Name Ausgabedatei
END IF

IF filename1$ = "" THEN              '! Leereingabe ?
 PRINT "Der Name der Eingabedatei fehlt"
 END
END IF

IF filename2$ = "" THEN              '! Leereingabe ?
 PRINT "Der Name der Ausgabedatei fehlt"
 END
END IF

IF filename1$ = filename2$ THEN          '! gleiche Namen ?
 PRINT "Eingabedatei = Ausgabedatei nicht erlaubt!"
 END
END IF

' prfe ob Datei vorhanden, nein -> exit

OPEN filename1$ FOR INPUT AS #ein%      '! ffne Eingabedatei
OPEN filename2$ FOR OUTPUT AS #aus%     '! ffne Ausgabedatei
PRINT
PRINT "Die Datei: ";filename1$;" wird bearbeitet"

WHILE NOT (EOF(ein%))                 '! Datei sequentiell lesen
 LINE INPUT #ein%, linie$             '! lese Zeile
 CALL skiprem(1,linie$,remflg%)       '! prfe auf Kommentar
 lang% = LEN(linie$)                  '! ermittle Zeilenlnge
 IF (lang% > 0) AND (NOT remflg%) THEN '! nur Anweisungen
  CALL scanner(linie$)                '! analysiere Satz
 END IF
 IF (INSTR(UCASE$(kommando$),"/L") > 0) THEN '! Level ausgeben
  PRINT #aus%, USING "## "; lev1%;
  lev1% = lev2%
 END IF
 PRINT #aus%, linie$                  '! Satz speichern
WEND

CLOSE                                 '! Dateien schlieen
PRINT
PRINT "Die Datei: ";filename2$;" wurde erzeugt"
END

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in XFORM
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";filename1$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Erradr : ";ERADR
 PRINT "Programmabbruch"
END IF
END                                 '! MSDOS Exit
RETURN


SUB getfile(ptr%,text$,result$)
'!---------------------------------------------------------
'! separiere Filename aus Eingabetext (text$)
'! ptr% -> Anfang Filename, result$ = Filename
'!---------------------------------------------------------
LOCAL tmp%, i%, zchn$

CALL skipblank (ptr%,text$)            '! entferne Blanks
tmp% = ptr%                            '! Anfang Filename
FOR i% = ptr% to LEN(text$)            '! suche Ende Filename
 zchn$ = MID$(text$,i%,1)
 IF (zchn$ = " ") or (zchn$ = "/") THEN
  result$ = MID$(text$,ptr%,i%-ptr%)   '! Filename extrahieren
  ptr% = i%
  EXIT SUB
 END IF
 tmp% = i%
NEXT i%

IF (tmp% = ptr%) THEN
  PRINT "Fehler: kein Fileseparator"    '! kein Endeseparator
  END                                   '! Exit
ELSE
  result$ = MID$(text$,ptr%,tmp%-ptr%+1) '! Filename extrahieren
  ptr% = tmp%
END IF

END SUB

SUB scanner(text$)
'!---------------------------------------------------------
'! Scan Quellcode zeilenweise und rcke die Zeilen gegeben-
'! enfalls ein. Die Zeile wird in text$ zurckgegeben.
'!---------------------------------------------------------

LOCAL token%, tokentxt$, ptr%, found%, ptr1%, zchn$, tmp%
SHARED lang%, spalte%, indent%, lev1%, lev2%

 ptr% = 1                                  '! Start mit 1. Zeichen
 CALL skipblank (ptr%,text$)               '! Blanks entfernen
 ptr1% = ptr%
 CALL gettoken(ptr%,text$,tokentxt$,token%) '! suche token
 IF token% THEN
  tokentxt$ = UCASE$(tokentxt$)             '! Grobuchstaben

'! bearbeite 1. Token und berechne Einrckung

  IF (tokentxt$ = "FOR") THEN
   text$ = SPACE$(spalte%) + MID$(text$,ptr1%,lang%)
   spalte% = spalte% + indent%
   lev2% = lev2% + 1

  ELSEIF (tokentxt$ = "DO") THEN
   text$ = SPACE$(spalte%) + MID$(text$,ptr1%,lang%)
   spalte% = spalte% + indent%
   lev2% = lev2% + 1

  ELSEIF (tokentxt$ = "WHILE") THEN
   text$ = SPACE$(spalte%) + MID$(text$,ptr1%,lang%)
   spalte% = spalte% + indent%
   lev2% = lev2% + 1

  ELSEIF (tokentxt$ = "SUB") THEN
   text$ = SPACE$(spalte%) + MID$(text$,ptr1%,lang%)
   spalte% = spalte% + indent%
   lev2% = lev2% + 1

  ELSEIF (tokentxt$ = "IF") THEN

   text$ = SPACE$(spalte%) + MID$(text$,ptr1%,lang%)
   token% = %true
   DO WHILE (token%)   '! prfe, ob letztes Token = THEN
    CALL gettoken(ptr%,text$,tokentxt$,token%) '! suche token
    IF token% THEN oldtoken$ = UCASE$(tokentxt$)
   LOOP

   IF oldtoken$ = "THEN" THEN
    spalte% = spalte% + indent%
    lev2% = lev2% + 1
   END IF

  ELSEIF (tokentxt$ = "ELSE") THEN
   tmp% = spalte% - indent%
   IF tmp% < 0 THEN tmp% = 0
   text$ = SPACE$(tmp%) + MID$(text$,ptr1%,lang%)
   IF lev2% > 0 THEN lev1% = lev2% - 1

  ELSEIF (tokentxt$ = "ELSEIF") THEN
   tmp% = spalte% - indent%
   IF lev2% > 0 THEN lev1% = lev2% - 1

   IF tmp% < 0 THEN tmp% = 0
   text$ = SPACE$(tmp%) + MID$(text$,ptr1%,lang%)

  ELSEIF (tokentxt$ = "END") THEN             '! END IF/ END SUB
   CALL gettoken(ptr%,text$,tokentxt$,token%) '! suche token
   IF token% THEN
    tokentxt$ = UCASE$(tokentxt$)             '! Grobuchstaben
    IF (tokentxt$ = "IF") or (tokentxt$ = "SUB") THEN
     spalte% = spalte% - indent%
     IF spalte% < 0 THEN spalte% = 0
     IF lev2% > 0 THEN lev2% = lev2% - 1
     lev1% = lev2%
    END IF
   END IF
   text$ = SPACE$(spalte%) + MID$(text$,ptr1%,lang%)

  ELSEIF (tokentxt$ = "NEXT") THEN
   spalte% = spalte% - indent%
   IF spalte% < 0 THEN spalte% = 0
   text$ = SPACE$(spalte%) + MID$(text$,ptr1%,lang%)
   IF lev2% > 0 THEN lev2% = lev2% - 1
   lev1% = lev2%

  ELSEIF (tokentxt$ = "LOOP") THEN
   spalte% = spalte% - indent%
   IF spalte% < 0 THEN spalte% = 0
   text$ = SPACE$(spalte%) + MID$(text$,ptr1%,lang%)
   IF lev2% > 0 THEN lev2% = lev2% - 1
   lev1% = lev2%

  ELSEIF (tokentxt$ = "WEND") THEN
   spalte% = spalte% - indent%
   IF spalte% < 0 THEN spalte% = 0
   text$ = SPACE$(spalte%) + MID$(text$,ptr1%,lang%)
   IF lev2% > 0 THEN lev2% = lev2% - 1
   lev1% = lev2%

  ELSE
   text$ = SPACE$(spalte%) + MID$(text$,ptr1%,lang%)
  END IF
 END IF

END SUB

SUB gettoken(ptr%,text$,token$,found%)

'!---------------------------------------------------------
'! durchsuche Zeile auf Variablennamen, found% = TRUE falls
'! Variable gefunden. Der Name wird dann in token zurckgegeben.
'!---------------------------------------------------------

LOCAL first%, remflg%, search%            '! locale Variablen
SHARED lang%                              '! globale Variablen

found% = %false                           '! init Flag nicht gefunden
search% = %true                           '! init Flag
lang% = LEN (text$)

WHILE search% AND ptr% <= lang%           '! suche Variablenanfang
 CALL skipblank(ptr%,text$)               '! skip fhrende Blanks
 IF ptr% >= lang% THEN EXIT SUB           '! Zeilenende -> Exit

 CALL skiprem(ptr%,text$,remflg%)         '! Kommentar ?
 IF remflg% THEN EXIT SUB                 '! ja -> Zeile fertig

 IF MID$(text$,ptr%,1) = CHR$(34) THEN    '! String "...." ?
  CALL skipstring(ptr%,text$)             '! skip string
  IF ptr% >= lang% THEN EXIT SUB          '! Ende -> Exit
 END IF

 zchn$ = UCASE$(MID$(text$,ptr%,1))       '! Zeichen separieren
 IF ((zchn$ < "A") OR (zchn$ > "Z")) _    '! Suche Anfang Namem
  AND (INSTR("$&%",zchn$) = 0) THEN       '!    "
   INCR ptr%                              '! nein -> next
 ELSE
  search% = %false                        '! ja -> exit
 END IF
WEND

IF search% THEN                           '! gefunden ?
 EXIT SUB                                 '! nein, Zeilenende -> Exit
END IF

'! ### Anfang eines Tokens gefunden ####

first% = ptr%                             '! merke Anfang token
search% = %true                           '! init Flag

WHILE search% AND ptr% <= lang%           '! suche Variablenende
 zchn$ = UCASE$(MID$(text$,ptr%,1))       '! Zeichen separieren
 IF (zchn$ < "A") OR (zchn$ > "Z") THEN   '! Ende Name ?
   IF (zchn$ < "0") OR (zchn$ > "9") THEN
     IF INSTR("$%&!#",zchn$) = 0 THEN
      search% = %false                    '! gefunden
      DECR ptr%                           '! korrigiere ptr% wg. Fehler
     END IF                               '! da EXIT WHILE nicht geht !
   END IF
 END IF
 INCR ptr%                                '! nein -> next

WEND

found% = %true                            '! gefunden !
token$ = MID$(text$,first%,(ptr%-first%)) '! get token

END SUB

SUB skipblank(ptr%,text$)
'---------------------------------------------------------
'! zhle fhrende Blanks in einer Zeichenkette
'! text$ = Zeichenkette, zeiger% = Zeiger in Kette
'---------------------------------------------------------
SHARED lang%

WHILE (ptr% =< lang%) and (MID$(text$,ptr%,1) = " ")
 INCR ptr%
WEND
END SUB

SUB skipstring(ptr%,text$)
'!---------------------------------------------------------
'! Es wird geprft, ob ptr% auf ein " im Text zeigt. In diesem
'! Falls liegt ein String "...." vor, dessen Ende (") gesucht
'! wird. ptr% zeigt nach dem Ablauf auf das Zeichen hinter ".
'! text$ = Zeichenkette mit Anweisung
'!---------------------------------------------------------
SHARED lang%

IF MID$(text$,ptr%,1) <> CHR$(34) THEN
 EXIT SUB                              '! kein String "..."
END IF

DO                                     '! suche Ende String
 INCR ptr%                             '! next char
LOOP UNTIL (MID$(text$,ptr%,1) = CHR$(34)) OR (ptr% >= lang%)

END SUB

SUB skiprem (ptr%,text$,flag%)

'!---------------------------------------------------------
'! prfe auf Kommentare, text$ = String mit Anweisung
'! ptr% = Zeiger in Text, flag% = true -> Kommentar gefunden
'!---------------------------------------------------------

 CALL skipblank(ptr%,text$)        '! fhrende blanks entfernen
 IF INSTR(text$,"REM") = ptr% THEN '! scan Anfang = REM oder '
  flag% = %true                    '! Kommantar
 ELSE
  IF MID$(text$,ptr%,1) = "'" THEN
   flag% = %true                    '! Kommentar
  ELSE
   flag% = %false                   '! kein Kommentar
  END IF
 END IF
END SUB
'***** Programm Ende ******
