'*********************************************************
'! File       : XPARK.BAS
'! Vers.      : 1.0
'! Last Edit  : 16.5.92
'! Autor      : G. Born
'! Files      : INPUT, OUTPUT
'! Progr. Spr.: Power Basic
'! Betr. Sys. : DOS 2.1 - 5.0
'! Funktion: Das Programm wird mit der Eingabe:
'!
'!           PARK
'!
'!           aufgerufen und parkt die Festplattenkpfe.
'**********************************************************
'! Variable definieren
drive% = 0

ON ERROR GOTO fehler

PRINT
PRINT "P A R K                   (c) Born Version 1.0"
PRINT

CALL DRIVESX                           '! Laufwerkszahl

PRINT "Es wurden ";drive%;" Platten erkannt"
PRINT

SELECT CASE drive%
 CASE 0
  PRINT "Es sind keine Festplatten vorhanden"

 CASE 1
  CALL park (1)
  PRINT "Festplatte 1 geparkt"

 CASE 2
  CALL park (1)
  PRINT "Festplatte 1 geparkt"
  CALL park (2)
  PRINT "Festplatte 2 geparkt"
END SELECT

PRINT "Schalten Sie nun Ihren Rechner aus."
PRINT "Falls Sie ein Taste bettigen, ist"
PRINT "das Parken der Festplatte(n) aufgehoben."
PRINT
WHILE INKEY$ = ""                      '! Endlosschleife
WEND
PRINT "Ende PARK, Platte nicht geparkt"
END                                    '! Ende

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in PARK
'---------------------------------------------------------

 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END                                 '! MSDOS Exit

SUB drivesx
'!---------------------------------------------------------
'! ermittle die Zahl der Plattendrives per INT 13
'! CALL:   AH = 800H DX = 0080H
'! RETURN: DL = drives
'!---------------------------------------------------------

 SHARED drive%

 REG 1, &H0800                        '! AX = 0800
 REG 4, &H80                          '! Drives
 CALL INTERRUPT &H13                  '! BIOS INT
 drive% = REG (4) AND &HFF            '! lese Wert in DL
END SUB

SUB park (lw%)
'!---------------------------------------------------------
'! positioniere Kopf auf letzte Spur
'! CALL:   AH = C00H DX = 0080H + drive_nr
'!---------------------------------------------------------

 REG 1, &H0800                        '! AX = 0800
 REG 4, &H80 + lw%                    '! Drive
 CALL INTERRUPT &H13                  '! ermittle Drivedaten

 '! Kopf des Laufwerkes auf letzte Spur positionieren

 REG 1,H0C00                           '! Seek
 REG 3,REG (3)                         '! Inhalt von CX
 REG 4, &H80 + lw%                     '! Laufwerk
 CALL INTERRUPT &H13
END SUB

'***** Programm Ende ******
