'*********************************************************
'! File       : XREF.BAS
'! Vers.      : 1.0
'! Last Edit  : 22. 4.92
'! Autor      : G. Born
'! Files      : INPUT, OUTPUT
'! Progr. Spr.: Power Basic 2.x
'! Betr. Sys. : DOS 2.1 - 5.0 (+ DR-DOS 5.0/6.0)
'! Funktion: Das Programm liest eine Power Basic Quellcodedatei
'!           ein und gibt diese mit Zeilennummern versehen in
'!           einer zweiten Datei wieder aus. Gleichzeitig
'!           wird eine Crossreferenzliste der auftretenden
'!           Variablen erzeugt. Diese Liste wird dann an die
'!           Quelldatei angehngt. Die Datei besitzt den
'!           gleichen Namen wie die Quelldatei, allerdings mit
'!           der Extension .REF. Die Datei kann per Editor an-
'!           gesehen werden und lt sich mit dem DOS Programm
'!           PRINT auf dem Drucker ausgeben.
'!
'! Aufruf:   XREF Filename /Optionen
'!           Optionen:  /Lxx linker Rand            [ 0 ]
'!                      /Rxx rechter Rand           [75 ]
'!                      /Zxx Zeilen pro Seite       [60 ]
'!
'!           Die Werte in [] geben die Standardeinstellung
'!           wieder. Wird das Programm ohne Parameter aufge-
'!           rufen, sind Dateiname und Optionen explizit ab-
'!           zufragen.
'**********************************************************
'! Variable und Konstanten definieren
%true = &HFFFF: %false = 0: %nil = 0
tmpx% = 0                             '! Hilfsvariable
zeile% = 0                            '! Zeilennummer Listing
seite% = 1                            '! Seitennummer Listing
maxzeile% = 60                        '! Zeilen pro Seite
rechts% = 75                          '! rechter Rand
links% = 0                            '! linker Rand
spalte% = 0                           '! Einrckung

remflg% = %false                      '! Kommentar gefunden
lang% = 0                             '! Lnge Zeile

ein% = 1                              '! Dateinummer Eingabe
aus% = 2                              '! Dateinummer Ausgabe

'### Tabellen fr XREF, automatischer Init durch Basic
'
%maxentry = 295                       '! Feldgre
DIM keyword$(1:%maxentry)             '! Schlsselworte
DIM keycode%(1:%maxentry)             '! Schlsselcodes

DIM index1%(0:26)                     '! Indextabelle
%tablen = 1000                        '! Tabellengre XREF
DIM tableptr%(1:%tablen)              '! ptr auf Folgesatz
DIM tablename$(1:%tablen)             '! Variablennamen
DIM tableline$(1:%tablen)             '! Zeilennummern

top% = 0                              '! oberster Eintrag

ON ERROR GOTO fehler                  '! Fehlerausgang

'#########################################################
'#                     Hauptprogramm                     #
'#########################################################

kommando$ = COMMAND$                  '! Parameter ?
IF LEN (kommando$) = 0 THEN           '! User Mode ?
 CLS                                  '! clear Screen

 PRINT "C r o s s  R e f e r e n z  G e n e r a t o r ";
 PRINT "  (c) Born Version 1.0"
 PRINT
 PRINT "Optionen [ /L=00 linker Rand         /R=75  rechter Rand   ]"
 PRINT "         [ /Z=60 Zeilen pro Seite                          ]"
 PRINT
 INPUT  "File     : ",filename$
 INPUT  "Optionen : ",options$
 PRINT
ELSE                                  '! Kommando Mode
 ptr% = INSTR (kommando$,"/?")        '! Option /?
 IF ptr% <> 0 THEN                    '! Hilfsbildschirm
  PRINT "X R E F                      (c) Born Version 1.0"
  PRINT
  PRINT "Aufruf: XREF <Filename> <Optionen>"
  PRINT
  PRINT "Optionen :"
  PRINT
  PRINT "  /L=00 setzt den linken Rand"
  PRINT "  /R=75 setzt den rechten Rand"
  PRINT "  /Z=60 setzt die Zeilenzahl pro Seite"
  PRINT
  PRINT "XREF erzeugt aus Power Basic Dateien ein Listing mit einer"
  PRINT "Cross-Referenz-Tabelle aller Variablen des Programmes. Die"
  PRINT "Rnder und die Zahl der Zeilen pro Seite lassen sich im Listing"
  PRINT "einstellen. Die Ausgabe erfolgt in eine Datei mit dem Namen"
  PRINT "xxxx.REF, die anschlieend ausgedruckt werden kann."
  PRINT
  SYSTEM
 END IF

 ptr% = INSTR (kommando$,"/")         '! Optionen ?
 IF ptr% = 0 THEN
  filename$ = kommando$               '! nur Filename
 ELSE
  filename$ = LEFT$(kommando$,ptr% -1) '! Filename separieren
  options$  = MID$(kommando$,ptr%)    '! Optionen separieren
 END IF
END IF

GOSUB parameter                       '! Optionen decodieren

IF (rechts% < links%) or (maxzeile% < 10) THEN '! sinnlose
 PRINT                                         '! Einstellung
 PRINT "Bitte Randeinstellung neu setzen"      '! Fehlerexit
 END                                  '! Exit
END IF

IF filename$ = "" THEN                '! Leereingabe ?
 PRINT
 PRINT "Der Dateiname fehlt"
 END                                  '! Exit
END IF

ptr% = INSTR(filename$,".")           '! hat Datei eine Extension?
IF ptr% > 0 THEN
 outfile$ = LEFT$(filename$,ptr%) + "REF" '! Filename ohne Extension
ELSE
 outfile$ = filename$ + ".REF"        '! Extension anhngen
END IF

' prfe ob Datei vorhanden, nein -> exit

OPEN filename$ FOR INPUT AS #ein%     '! ffne Eingabedatei
OPEN outfile$ FOR OUTPUT AS #aus%     '! ffne Ausgabedatei
PRINT
PRINT "Die Datei: ";filename$;" wird bearbeitet"

GOSUB init                            '! Tabellen aufbauen
GOSUB pageskip                        '! Seitenkopf ausgeben

WHILE NOT (EOF(ein%))                 '! Datei sequentiell lesen
 LINE INPUT #ein%, linie$             '! lese Zeile
 CALL skiprem(1,linie$,remflg%)       '! prfe auf Kommentar
 lang% = LEN(linie$)                  '! ermittle Zeilenlnge
 CALL ausgabe (linie$)                '! drucke Zeile
 IF (lang% > 0) AND (NOT remflg%) THEN '! nur Anweisungen
  CALL scanner(linie$)                '! analysiere Satz
 END IF
WEND

PRINT "Referenzliste erzeugen"
GOSUB addtable                        '! xref Liste erzeugen

CLOSE                                 '! Dateien schlieen
PRINT
PRINT "Ende Cross Referenz Generator"
END

'#########################################################
'#                    Hilfsroutinen                      #
'#########################################################

fehler:
'---------------------------------------------------------
'! Fehlerbehandlung in XREF
'---------------------------------------------------------

IF ERR = 53 THEN
 PRINT "Die Datei ";filename$;" existiert nicht"
ELSE
 PRINT "Fehler : ";ERR;" unbekannt"
 PRINT "Programmabbruch"
END IF
END                                 '! MSDOS Exit
RETURN


init:
'!---------------------------------------------------------
'! Initialisierung der Tabelle mit den Schlsselwrtern
'!---------------------------------------------------------

FOR i% = 1 to %maxentry
 READ keyword$(i%), keycode%(i%)    '! Schlsselworte einlesen
NEXT i%

RETURN


parameter:
'---------------------------------------------------------
'! Decodiere die Eingabeoptionen
'---------------------------------------------------------

ptr% = INSTR (options$,"/Z=")
IF ptr% > 0 THEN CALL getval (maxzeile%) '! Zeilen / Seite
szeile% = maxzeile% + 1               '! Zeilennr Seite wechseln

ptr% = INSTR (options$,"/L=")
IF ptr% > 0 THEN CALL getval (links%) '! linker Rand

ptr% = INSTR (options$,"/R=")
IF ptr% > 0 THEN CALL getval (rechts%) '! rechter Rand

RETURN

SUB getval (wert%)
'---------------------------------------------------------
'! Decodiere den Eingabestring in eine Zahl
'---------------------------------------------------------
 SHARED options$, ptr%
 LOCAL i%

 ptr% = ptr% + 3                      '! ptr hinter /x=
 i% = 1
 WHILE ((ptr%+i%) =< LEN (options$)) AND _
     (MID$(options$,ptr%+i%,1) <> " ")
  i% = i% + 1                         '! Ziffernzahl + 1
 WEND
 wert% = VAL(MID$(options$,ptr%,i%))  '! decodiere die Zahl
END SUB

pageskip:
'---------------------------------------------------------
'! Seitenvorschub mit Kopf (Dateiname, Datum, Seite)
'---------------------------------------------------------
 IF szeile% < maxzeile% THEN RETURN   '! kein Seitenwechsel !!

 IF seite% > 1 THEN                   '! 1. Seite k. Vorschub
  PRINT #aus%, CHR$(12)               '! Vorschub
  szeile% = 5                         '! 5 Kopfzeilen
 ELSE
  PRINT #aus%, "X R E F   "; options$; SPACE$(27);
  PRINT #aus%, "(c) Born Version 1.0"
  szeile% = 6                         '! 6 Kopfzeilen
 END IF
 PRINT #aus%, "Datei : ";filename$;"     Datum : ";DATE$;
 PRINT #aus%, "         Seite : "; seite%
 PRINT #aus%,
 PRINT #aus%, SPACE$(links%); " Zeile     Anweisung"
 PRINT #aus%,
 INCR seite%

RETURN

SUB ausgabe (text$)
'--------------------------------------------------------
'! Ausgabe der eingelesenen Zeile in die Ausgabedatei.
'! rest% gibt an, wieviele Zeichen pro Zeile gedruckt
'! werden drfen. Ist die eingelesene Zeile lnger, wird
'! sie auf mehrere Ausgabezeilen aufgeteilt.
'--------------------------------------------------------
 LOCAL linie$, rest%, spalte%
 SHARED aus%,links%,rechts%,zeile%
 SHARED lang%, szeile%, remflg%

 linie$ = text$                       '! copiere String
 GOSUB pageskip                       '! Seitenvorschub ?

 PRINT #aus%, SPACE$(links%);         '! auf linken Rand

 IF (lang% > 0) AND (NOT remflg%) THEN
  INCR zeile%                          '! Zeile im Listing + 1
  PRINT #aus%, USING "##### "; zeile%; '! Zeilennummer drucken
 ELSE
  PRINT #aus%, SPACE$(6);             '! Leerzeichen
 END IF

 spalte% = links% + 7                 '! linker Rand setzen

 rest% = rechts% - spalte%            '! Restzeilenlnge
 CALL skipblank(spalte%,linie$)       '! merke Blanks
 PRINT #aus%, LEFT$(linie$,rest%)     '! Ausgabe Teilstring
 linie$ = MID$(linie$, rest% + 1)     '! Reststring
 INCR szeile%

 WHILE LEN(linie$) > rest%            '! String > Zeile
  GOSUB pageskip                      '! Seitenvorschub ?
  PRINT #aus%, SPACE$(spalte%);       '! linker Rand
  PRINT #aus%, LEFT$(linie$,rest%)    '! Teilstring ausgeben
  linie$ = MID$(linie$,rest% + 1)     '! Reststring bestimmen
  INCR szeile%                        '! Zeile im Listing + 1
 WEND

 IF LEN(linie$) > 0 THEN
  GOSUB pageskip                      '! Seitenvorschub ?
  PRINT #aus%, SPACE$(spalte%);linie$ '! Reststring ausgeben
  INCR szeile%                        '! Zeile im Listing + 1
 END IF
END SUB


SUB scanner(text$)
'!---------------------------------------------------------
'! Scan Quellcode zeilenweise und trage alle Variablen, Labels
'! und Prozeduren in die Referenztabelle ein.
'!---------------------------------------------------------

LOCAL token%, tokentxt$, ptr%, found%, code%
LOCAL zchn$, number%
SHARED linie$, zeile%

ptr% = 1                                  '! start mit 1. Zeichen

DO
 CALL gettoken(ptr%,linie$,tokentxt$,token%) '! suche token
 IF token% THEN
  zchn$ = MID$(tokentxt$,1,1)                 '! 1. Zeichen
  IF (zchn$ <> "$") AND (zchn$ <> "&") THEN   '! ignore $... , &...
   CALL keychk(tokentxt$,found%,code%,number%)'! Schlsselwort ?
   IF NOT found% THEN                         '! nur Variable
    CALL writeref (tokentxt$,zeile%)          '! schreibe Zeilennr.
   END IF
  END IF
 END IF
LOOP WHILE (token%)                        '! Ende erreicht ?

END SUB

SUB gettoken(ptr%,text$,token$,found%)

'!---------------------------------------------------------
'! durchsuche Zeile auf Variablennamen, found% = TRUE falls
'! Variable gefunden. Der Name wird dann in token zurckgegeben.
'!---------------------------------------------------------

LOCAL first%, remflg%, search%            '! locale Variablen
SHARED lang%                              '! globale Variablen

found% = %false                           '! init Flag nicht gefunden
search% = %true                           '! init Flag

WHILE search% AND ptr% <= lang%           '! suche Variablenanfang
 CALL skipblank(ptr%,text$)               '! skip fhrende Blanks
 IF ptr% >= lang% THEN EXIT SUB           '! Zeilenende -> Exit

 CALL skiprem(ptr%,text$,remflg%)         '! Kommentar ?
 IF remflg% THEN EXIT SUB                 '! ja -> Zeile fertig

 IF MID$(text$,ptr%,1) = CHR$(34) THEN    '! String "...." ?
  CALL skipstring(ptr%,text$)             '! skip string
  IF ptr% >= lang% THEN EXIT SUB          '! Ende -> Exit
 END IF

 zchn$ = UCASE$(MID$(text$,ptr%,1))       '! Zeichen separieren
 IF ((zchn$ < "A") OR (zchn$ > "Z")) _    '! Suche Anfang Namem
  AND (INSTR("$&%",zchn$) = 0) THEN       '!    "
   INCR ptr%                              '! nein -> next
 ELSE
  search% = %false                        '! ja -> exit
 END IF
WEND

IF search% THEN                           '! gefunden ?
 EXIT SUB                                 '! nein, Zeilenende -> Exit
END IF

'! ### Anfang eines Tokens gefunden ####

first% = ptr%                             '! merke Anfang token
search% = %true                           '! init Flag

WHILE search% AND ptr% <= lang%           '! suche Variablenende
 zchn$ = UCASE$(MID$(text$,ptr%,1))       '! Zeichen separieren
 IF (zchn$ < "A") OR (zchn$ > "Z") THEN   '! Ende Name ?
   IF (zchn$ < "0") OR (zchn$ > "9") THEN
     IF INSTR("$%&!#",zchn$) = 0 THEN
      search% = %false                    '! gefunden
      DECR ptr%                           '! korrigiere ptr% wg. Fehler
     END IF                               '! da EXIT WHILE nicht geht !
   END IF
 END IF
 INCR ptr%                                '! nein -> next

WEND

found% = %true                            '! gefunden !
token$ = MID$(text$,first%,(ptr%-first%)) '! get token

END SUB

SUB keychk(symbol$,found%,code%,index%)
'!---------------------------------------------------------
'! prfe, ob symbol in der Tabelle mit den Schlsselworten
'! vorliegt, falls ja -> found% = true, code% = Schlsselcode
'! sonst -> found% = false, index% = Nummer in Tabelle
'! Es wird ein binres Suchverfahren benutzt.
'!---------------------------------------------------------

LOCAL low%, high%, ptr% , token$
SHARED keycode%(), keyword$()

low% = 1                                  '! Untergrenze
high% = %maxentry                         '! Obergrenze
found% = %false                           '! not found
token$ = UCASE$(symbol$)                  '! Grobuchst.

WHILE (low% + 1 < high%)                  '! Binrsuche in Tabelle
 ptr% = (high% + low%) / 2                '! calc. Index
 IF token$ = keyword$(ptr%) THEN
  found% = %true                          '! gefunden
  code% = keycode%(ptr%)                  '! Befehlscode
  index% = ptr%                           '! Tabellenindex
  EXIT SUB                                '! Exit
 ELSE
  IF token$ < keyword$(ptr%) THEN         '! welche Hlfte?
   high% = ptr%                           '! neue Obergrenze
  ELSE
   low% = ptr%                            '! neue Untergrenze
  END IF
 END IF
WEND

 IF token$ = keyword$(low%) THEN          '! erstes Keyword
  found% = %true                          '! gefunden
  code% = keycode%(low%)                  '! Befehlscode
  index% = low%                           '! Tabellenindex
  EXIT SUB                                '! ja -> EXIT
 END IF

 IF token$ = keyword$(high%) THEN         '! letztes Keyword?
  found% = %true                          '! gefunden
  code% = keycode%(high%)                 '! Befehlscode
  index% = high%                          '! Tabellenindex
  EXIT SUB                                '! ja -> EXIT
 END IF

END SUB


SUB writeref(token$,zeile%)
'!---------------------------------------------------------
'! Eintrag des Variablennamens und der Zeilennummer
'! in die Referenzliste. Ist kein Eintrag vorhanden,
'! wird ein neuer Eintrag mit dem Namen angelegt, sonst
'! wird nur die Zeilennummer angehngt.
'!---------------------------------------------------------

LOCAL zchn$, ptr%, code%, tmp%
SHARED index1%(), tableline$(), top%

zchn$ = UCASE$(MID$(token$,1,1))       '! erstes Zeichen
IF zchn$ = "%" THEN
 ptr% = 0                              '! Index %
ELSE
 ptr% = ASC(zchn$) - 64                '! Index A .. Z
END IF

IF (ptr% > 26) or (ptr% < 0) THEN
 PRINT "Fehler : Variablenname falsch "
 EXIT SUB                              '! Exit
END IF

IF index1%(ptr%) = %nil THEN           '! kein Eintrag ?
 CALL addtxt(ptr%,1,token$)            '! Eintrag anlegen
 tableline$(top%) = STR$(zeile%)+" "   '! Eintrag Zeilennr.
ELSE
 tmp% = index1%(ptr%)                  '! erster Satz
 CALL searchf(tmp%,token$,code%)       '! suche Eintrag
 IF code% > 0 THEN                     '! neu anlegen?
  IF code% = 1 THEN                    '! an Anfang
   CALL addtxt(ptr%,code%,token$)      '! ptr% in index1%()
  ELSE
   CALL addtxt(tmp%,code%,token$)      '! ptr% in tableptr()
  END IF
  tableline$(top%) = STR$(zeile%)+" "  '! Eintrag Zeilennr.
 ELSE                                  '! Eintrag vorhanden
  zchn$ = STR$(zeile%)+" "             '! Zeile in ASCII
  IF INSTR(tableline$(tmp%),zchn$)_    '! Zeile bereits
     > 0 THEN EXIT SUB                 '! vorhanden -> Exit
  tableline$(tmp%) = tableline$(tmp%) + zchn$ '! add Zeilenr
 END IF
END IF

END SUB   '! write_ref


SUB searchf (ptr%,token$,result%)
'!---------------------------------------------------------
'! Suche den Variablennamen in der Liste. Es gelten folgende
'! Bedingungen: ptr% -> pointer auf den ersten Satz in der
'! Teilkette. Ergebnisse: result% > 0 -> nicht gefunden
'!  0  gefunden                   -> ptr% zeigt auf Satz
'!  1  an Tabellenanfang einfgen -> ptr% zeigt auf Anfang
'!  2  an Tabellenende anhngen   -> ptr% auf letzten Satz
'!  3  in Tabelle einfgen        -> ptr% auf Vorgngersatz
'!---------------------------------------------------------

LOCAL alt%, varname$, tabname$, last%  '! Hilfsvariable
SHARED tableptr%(), index1%(), tablename$()

varname$ = UCASE$(token$)              '! in Grobuchst.
alt% = ptr%                            '! merke Zeiger
WHILE ptr% <> %nil                     '! bis Ende Liste
 tabname$ = UCASE$(tablename$(ptr%))   '! Listenname
 IF varname$ > tabname$ THEN           '! gefunden ?
  last% = ptr%                         '! nein -> merke ptr%
  ptr% = tableptr%(ptr%)               '! next entry
 ELSE
  IF varname$ = tabname$ THEN          '! gefunden ?
   result% = 0: EXIT SUB               '! ja, ready
  ELSE
   IF ptr% = alt% THEN                 '! Tabellenanfang
    result% = 1: EXIT SUB              '! ja, ready
   ELSE
    result% = 3                        '! nein, einfgen
    ptr% = last%: EXIT SUB             '! ptr% auf Vorgnger
   END IF
  END IF
 END IF
WEND

result% = 2                            '! Satz anhngen
ptr% = last%                           '! ptr% auf letzten Satz

END SUB   '! search


SUB addtxt(ptr%,code%,varname$)
'!---------------------------------------------------------
'! Eintrag eines neuen Variablennamens in die Liste
'! ptr% zeigt auf den Satz hinter dem eingefgt wird.
'! code bestimmt den Einfgemode:
'!  1  an Tabellenanfang einfgen -> ptr% in index1% (root)
'!  2  an Tabellenende anhngen   -> ptr% in tableptr% (last)
'!  3  in Tabelle einfgen        -> ptr% in tableptr% (pred)
'! varname$ enthlt den Variablennamen
'!---------------------------------------------------------

SHARED top%, tableptr%(), tablename$()
SHARED index1%()

INCR top%                                '! auf nchsten Satz
IF top% > %tablen THEN CALL full         '! berlauf
IF code% = 2 THEN                        '! anhngen
 tableptr%(top%) = %nil                  '! Ende Liste
 tableptr%(ptr%) = top%                  '! Link Folgesatz
ELSE
 IF code% = 1 THEN                       '! erster Satz
  tableptr%(top%) = index1%(ptr%)        '! Link Folgesatz
  index1%(ptr%) = top%                   '! Link Kopf
 ELSE
  IF code% = 3 THEN                      '! zwischen Stze
   tableptr%(top%) = tableptr%(ptr%)     '! Link Folgesatz
   tableptr%(ptr%) = top%                '! Link neuen Satz
  ELSE
   PRINT "Fehler: falscher Code in add"
   END                                   '! Fehlerausgang
  END IF
 END IF
END IF

tablename$(top%) = varname$              '! Name eintragen

END SUB

SUB full
'! Fehlerabbruch bei berlauf der Tabellen
 PRINT "Fehler : interner Tabellenberlauf ####"
 END
END SUB


addtable:
'!---------------------------------------------------------
'! erzeuge Referenztabelle
'!---------------------------------------------------------

 PRINT #aus%, CHR$(12)                  '! Seitenwechsel
 PRINT #aus%, "X R E F - T a b e l l e"; SPACE$(27);
 PRINT #aus%, "(c) Born Version 1.0"
 PRINT #aus%, "Datei : ";filename$;"     Datum : ";DATE$;
 PRINT #aus%, "         Seite : "; seite%
 PRINT #aus%,
 INCR seite%                              '! Seite + 1
 szeile% = 3                              '! 3 Kopfzeilen

'!--- gebe die Referenztabelle formatiert aus

 FOR i% = 0 TO 26                         '! ber Indextabelle
  ptrx% = index1%(i%)                     '! Index in Tabelle
  WHILE ptrx% <> %nil                     '! Liste bis Ende
   PRINT #aus%, tablename$(ptrx%)         '! Name ausgeben
   INCR szeile%                           '! Zeilenzhler + 1
   GOSUB kopf                             '! Seitenwechsel ?
   linie$ = tableline$(ptrx%)             '! hole Zeilennr.
   rest% = rechts% - links%               '! Drucklnge
   WHILE LEN(linie$) > rest%              '! formatiert ausgeben
    GOSUB kopf                            '! Seitenwechsel ?
    PRINT #aus%, SPACE$(links%);          '! linker Rand
    tmpx% = rest%                         '! Drucklnge merken
    WHILE (MID$(linie$,tmpx%,1) <> " ")_  '! vermeide da letzte
      AND (tmpx% > 9)                     '! Zahl abgeschnitten
      DECR tmpx%                          '! wird
    WEND
    PRINT #aus%, MID$(linie$,1,tmpx%)     '! Teilstring
    linie$ = MID$(linie$,tmpx%+1)         '! Rest holen
    INCR szeile%                          '! Zeilennr. + 1
   WEND
   IF LEN(linie$) > 0 THEN
    GOSUB kopf                            '! Seitenwechsel
    PRINT #aus%, SPACE$(links%);linie$    '! Rest ausgeben
    PRINT #aus%,
    INCR szeile%, 2
   END IF
   ptrx% = tableptr%(ptrx%)               '! next entry
  WEND
 NEXT i%                                  '! next index

 szeile% = szeile% + 7                    '! 7 Zeilen res.
 GOSUB kopf                               '! Seitenwechsel
 PRINT #aus%,
 PRINT #aus%,"XREF Modul Information"
 PRINT #aus%,
 PRINT #aus%,"Lines read    : ";zeile%
 PRINT #aus%,"Symbols found : ";top%
 PRINT #aus%,
 PRINT #aus%,"End XREF"
 PRINT #aus%, CHR$(12)                    '! Seitenvorschub

RETURN

kopf:
'!---------------------------------------------------
'! Ausgabe des Kopfes fr die Referenzliste
'!---------------------------------------------------

 IF szeile% < maxzeile% THEN RETURN        '! Seitenwechsel ?

 PRINT #aus%, CHR$(12)                  '! Seitenwechsel
 PRINT #aus%, "Datei : ";filename$;"     Datum : ";DATE$;
 PRINT #aus%, "         Seite : "; seite%
 PRINT #aus%,
 szeile% = 2                              '! 2 Kopfzeilen
 INCR seite%

RETURN

SUB skipblank(ptr%,text$)
'---------------------------------------------------------
'! zhle fhrende Blanks in einer Zeichenkette
'! text$ = Zeichenkette, zeiger% = Zeiger in Kette
'---------------------------------------------------------
SHARED lang%

WHILE (ptr% =< lang%) and (MID$(text$,ptr%,1) = " ")
 INCR ptr%
WEND
END SUB

SUB skipstring(ptr%,text$)
'!---------------------------------------------------------
'! Es wird geprft, ob ptr% auf ein " im Text zeigt. In diesem
'! Falls liegt ein String "...." vor, dessen Ende (") gesucht
'! wird. ptr% zeigt nach dem Ablauf auf das Zeichen hinter ".
'! text$ = Zeichenkette mit Anweisung
'!---------------------------------------------------------
SHARED lang%

IF MID$(text$,ptr%,1) <> CHR$(34) THEN
 EXIT SUB                              '! kein String "..."
END IF

DO                                     '! suche Ende String
 INCR ptr%                             '! next char
LOOP UNTIL (MID$(text$,ptr%,1) = CHR$(34)) OR (ptr% >= lang%)

END SUB

SUB skiprem (ptr%,text$,flag%)

'!---------------------------------------------------------
'! prfe auf Kommentare, text$ = String mit Anweisung
'! ptr% = Zeiger in Text, flag% = true -> Kommentar gefunden
'!---------------------------------------------------------

 CALL skipblank(ptr%,text$)        '! fhrende blanks entfernen
 IF INSTR(text$,"REM") = ptr% THEN '! scan Anfang = REM oder '
  flag% = %true                    '! Kommantar
 ELSE
  IF MID$(text$,ptr%,1) = "'" THEN
   flag% = %true                    '! Kommentar
  ELSE
   flag% = %false                   '! kein Kommentar
  END IF
 END IF
END SUB

'!---------------------------------------------------------
'! Data Anweisungen mit den reservierten Schlsselwrtern
'! von Turbo Basic. Der erste Wert enthlt das Schlsselwort,
'! whrend der zweite Wert angibt, ob es sich um ein Funktion
'! oder ein Schlsselwort fr einen Befehl handelt:
'! Bsp.:     "IF"   , 0   '! Schlsselwort
'!           "CHR$" , 1  '! Basic Funktion
'!---------------------------------------------------------
'
DATA "ABS"     ,1, "ABSOLUTE" ,0, "AND"    ,0, "APPEND"  ,0
DATA "ARRAY"   ,0, "AS"       ,0, "ASC"    ,1, "ASCEND"  ,0
DATA "ASCII"   ,1, "ATN"      ,1, "ATTRIB" ,0, "BASE"    ,0
DATA "BEEP"    ,0, "BIN$"     ,1, "BINARY" ,0, "BLOAD"   ,0
DATA "BLOCK"   ,0, "BSAVE"    ,0, "CALL"   ,0, "CASE"    ,0
DATA "CBCD"    ,0, "CDBL"     ,1, "CEIL"   ,1, "CEXT"    ,1
DATA "CFIX"    ,1, "CHAIN"    ,0, "CHDIR"  ,0, "CHR$"    ,1
DATA "CINT"    ,1, "CIRCLE"   ,1, "CLEAR"  ,0, "CLNG"    ,1
DATA "CLOSE"   ,0, "CLS"      ,0, "COLOR"  ,0, "COLLATE" ,0
DATA "COM"     ,0, "COMMAND$" ,1, "COMMON" ,1, "COS"     ,1
DATA "CQUD"    ,1, "CSNG"     ,1, "CSRLIN" ,1, "CURDIR$" ,0
DATA "CVB"     ,1, "CVD"      ,1, "CVE"    ,1, "CVF"     ,1
DATA "CVI"     ,1, "CVL"      ,1, "CVMD"   ,1, "CVMS"    ,1
DATA "CVQ"     ,1, "CVS"      ,1, "DATA"   ,0, "DATE$"   ,1
DATA "DECLARE" ,0, "DECR"     ,0, "DEF"    ,0, "DEFBCD"  ,0
DATA "DEFDBL"  ,0, "DEFEXT"   ,0, "DEFFIX" ,0, "DEFFLX"  ,0
DATA "DEFINT"  ,0, "DEFLNG"   ,0, "DEFQUD" ,0, "DEFSNG"  ,0
DATA "DEFSTR"  ,0, "DELAY"    ,0, "DELETE" ,0, "DESCEND" ,0
DATA "DIM"     ,0, "DIR"      ,0, "DO"     ,0, "DRAW"    ,1
DATA "DYNAMIC" ,0, "ELSE"     ,0, "ELSEIF" ,0, "END"     ,0
DATA "ENDMEM"  ,0, "ENVIRON"  ,1, "ENVIRON$",1,"EOF"     ,0
DATA "EQV"     ,1, "ERADR"    ,1, "ERASE"  ,0, "ERDEV"   ,0
DATA "ERDEV$"  ,0, "ERL"      ,0, "ERR"    ,0, "ERROR"   ,0
DATA "EXECUTE" ,0, "EXIT"     ,0, "EXP"    ,1, "EXP10"   ,1
DATA "EXP2"    ,1, "EXTERNAL" ,0, "EXTRACT$",0,"FIELD"   ,0
DATA "FILEATTR",0, "FILES"    ,0, "FIX"    ,1, "FN"      ,0
DATA "FOR"     ,0, "FRE"      ,0, "FREEFILE",0, "FUNCTION",0
DATA "GET"     ,0, "GET$"     ,0, "GOSUB"   ,0, "GOTO"   ,0
DATA "HEX$"    ,1, "IF"       ,0, "INCR"    ,0, "INKEY$" ,0
DATA "INLINE"  ,0, "INP"      ,1, "INPUT"   ,0, "INPUT#" ,0
DATA "INPUT$"  ,0, "INSERT"   ,0, "INSTAT"  ,0
DATA "INSTR"   ,1, "INT"      ,0, "INTERRUPT",0,"IOCTL"  ,0
DATA "IOCTL$"  ,0, "KEY"      ,0, "KILL"    ,0, "LBOUND" ,0
DATA "LCASE$"  ,1, "LEFT$"    ,1, "LEN"     ,1, "LET"    ,0
DATA "LINE"    ,0, "LIST"     ,0, "LLIST"   ,0, "LOC"    ,0
DATA "LOCAL"   ,0, "LOCATE"   ,0, "LOCK"    ,0, "LOF"    ,0
DATA "LOG"     ,1
DATA "LOG10"   ,1, "LOG2"     ,1, "LOOP"   ,0, "LPOS"    ,1
DATA "LPRINT"  ,0, "LSET"     ,0, "LTRIM"  ,1, "MAP"     ,0
DATA "MAX"     ,1, "MAX%"     ,1, "MAX$  " ,1, "MEMSET"  ,0
DATA "MID$"    ,1, "MIN"      ,1, "MIN%"   ,1, "MIN$"    ,1
DATA "MKDIR"   ,0, "MKB$"     ,1, "MKD$"   ,1, "MKE$"    ,1
DATA "MKF$"    ,1, "MKI$"     ,1, "MKL$"   ,1, "MKMD$"   ,1
DATA "MKMS$"   ,1, "MKQ$"     ,1, "MKS$"   ,1, "MOD"     ,0
DATA "MTIMER"  ,0
DATA "NAME"    ,0, "NEXT"     ,0, "NOT"    ,0, "OCT$"    ,1
DATA "OFF"     ,1, "ON"       ,1, "OPEN"   ,0, "OPTION"  ,0
DATA "OR"      ,0, "OUT"      ,0, "OUTPUT" ,0, "PAINT"   ,0
DATA "PALETTE" ,0, "PEEK"     ,0, "PEEKI"  ,0, "PEEKL"   ,0
DATA "PEEK$"   ,0, "PEN"      ,0, "PLAY"   ,0, "PMAP"    ,0
DATA "POINT"   ,0, "POKE"     ,0, "POKEI"  ,0, "POKEL"   ,0
DATA "POKE$"   ,0, "POS"      ,0, "PRESET" ,0, "PRINT"   ,0
DATA "PRINT#"  ,0, "PSET"     ,0, "PUBLIC" ,0
DATA "PUT"     ,0, "PUT$"     ,0, "RANDOM" ,0, "RANDOMIZE",0
DATA "READ"    ,0, "RECURSIVE",0, "REDIM"  ,0, "REG"     ,0
DATA "REM"     ,0, "REMOVE$"  ,1, "REPEAT$",0, "REPLACE" ,0
DATA "RESET"   ,0, "RESTORE"  ,0, "RESUME" ,0, "RETURN"  ,0
DATA "RIGHT$"  ,1, "RMDIR"    ,0, "RND"    ,1, "ROUND"   ,1
DATA "RSET"    ,0, "RSET"     ,0, "RTRIM$" ,1, "RUN"     ,0
DATA "SAVE"    ,0, "SCAN"     ,0, "SCREEN" ,0, "SEEK"    ,0
DATA "SEG"     ,0, "SELECT"   ,0, "SERVICE",0, "SGN"     ,1
DATA "SHARED"  ,0, "SHELL"    ,0, "SIN"    ,1, "SORT"    ,0
DATA "SOUND"   ,0, "SPACE$"   ,1, "SPC"    ,1, "SQR"     ,1
DATA "STATIC"  ,1, "STEP"     ,0, "STICK"  ,0, "STOP"    ,0
DATA "STR$"    ,1, "STRIG"    ,0, "STRING$",0, "STRPTR"  ,1
DATA "STRSEG"  ,1, "SUB"      ,0, "SWAP"   ,0
DATA "SYSTEM"  ,0, "TAB"      ,0, "TALLY"  ,1, "TAN"     ,1
DATA "THEN"    ,0
DATA "TIME$"   ,0, "TIMER"    ,0, "TO"     ,0, "TROF"    ,0
DATA "TRON"    ,0, "UBOUND"   ,0, "UCASE$" ,1, "UNTIL"   ,0
DATA "UNTIL"   ,0
DATA "USING"   ,0, "USR"      ,0, "USR0"   ,0, "USR1"    ,0
DATA "USR2"    ,0, "USR3"     ,0, "USR4"   ,0, "USR5"    ,0
DATA "USR6"    ,0, "USR7"     ,0, "USR8"   ,0, "USR9"    ,0
DATA "VAL"     ,1, "VARPTR"   ,0, "VARPTR$",0, "VARSEG"  ,0
DATA "VERIFY"  ,1
DATA "VIEW"    ,0, "WAIT"     ,0, "WEND"   ,0, "WHILE"   ,0
DATA "WIDTH"   ,0, "WINDOW"   ,0, "WRITE"  ,0, "WRITE#"  ,0
DATA "XOR"     ,0

'***** Programm Ende ******
