;===================================
; File: ASK.ASM   (c) Born G.
; Funktion: Programm zur Benutzerab-
; frage in Batchdateien. Aufruf:
;
;     ASK <Text>
;
; Der Text wird auf dem Screen ausge-
; gegeben. Der Tastencode wird an DOS
; zurckgegeben. (Bei Funktionstasten
; wird FF zurckgegeben). Er lt sich
; per ERRORLEVEL abfragen. Das Programm
; ist als COM-Datei zu bersetzen!!
;===================================
;
       RADIX 16            ; Hexadezimalsystem
       ORG 0100            ; Startadresse COM
       CODE SEGMENT
       Blank EQU 20        ; Blank
       Err1  EQU 0FF       ; Error
;
ASK:   JMP NEAR Start      ; ins Hauptprogramm
;
;--------------------------------
; Unterprogramm zur Textausgabe
;--------------------------------
; prfe ob Text im PSP vorhanden ist
;
Text:  CS: MOV CL,[80]     ; lese Pufferlnge
       CMP CL,0            ; Text vorhanden ?
       JZ  Ready           ; Nein -> Exit
;
; Text ist vorhanden, ausgeben per INT 21, AH = 02
;
       MOV BX,0081         ; Zeiger auf 1. Zeichen
Loop1:           ; Beginn der Ausgabeschleife !!!!
       MOV AH,02           ; INT 21-Code Display Char.
       CS: MOV DL,[BX]     ; Zeichen in DL laden
       INT 21              ; CALL DOS-Zeichenausgabe 
       INC BX              ; Zeiger auf nchstes Zchn
       DEC CL              ; Zeichenzahl - 1
       JNZ Loop1           ; Textende ? Nein-> Loop
;
       MOV AH,02           ; INT 21-Code Display
       MOV DL,Blank        ; Blank anhngen
       INT 21              ; und ausgeben
Ready: RET                 ; Ende Unterprogramm

;
;--------------------------------
; Unterprogramm zur Tastaturabfrage
; benutze INT 21, AH = 08 Read Keyboard
; oder:           AH = 01 Read Keyboard & Echo
;--------------------------------
; lese 1. Zeichen
Key:   MOV AH,01           ; INT 21-Read Key & Echo
       INT 21              ; Read Code
       CMP AL,0            ; Extended ASCII-Code ?
       JNZ Exit            ; Nein -> Ready
;
; lese 2. Zeichen beim Extended ASCII-Code
;
       MOV AH,08           ; INT 21 Read Keyboard
       INT 21              ; Code aus Puffer lesen
       MOV AL,Err1         ; Fehlercode setzen
Exit:  RET                 ; Ende Unterprogramm

;
;--------------------------------
; Hauptprogramm
;--------------------------------
;
Start: CALL NEAR Text     ; Text ausgabe falls vorhanden
       CALL NEAR Key      ; Abfrage der Tastatur
       PUSH AX            ; merke Tastencode
;
; CR,LF ausgeben
;
       MOV AH,09          ; INT 21-Stingausgabe
       MOV DX,Crlf        ; Stringadresse
       INT 21             ; ausgeben
       POP AX             ; restauriere Tastencode
;
; DOS-Exit, Returncode steht bereits in AL
;
       MOV AH,4C          ; INT 21-Exitcode
       INT 21             ; terminiere
;
; Bereich mit den Textkonstanten
;
Crlf:  DB 0D,0A,"$"
;
END Ask

