'!*********************************************************
'! File       : DEMO.BAS
'! Vers.      : 1.1
'! Autor      : G. Born
'! Files      : ---
'! Progr. Spr.: Quick Basic 4.x
'! Betr. Sys. : DOS ab 2.1
'! Funktion: Das Programm dient zur Demonstration der Ein-
'!           bindung von Assemblermodulen in QuickBasic.
'!           Es wird das Modul CRC.OBJ benutzt, Die Parameter
'!           stehen als Bytes im Feld buff%(), oder im String
'!           buff$. Aus diesen Zeichen wird dann die CRC16-
'!           Summe mittels der Procedur CRC (File CRC.OBJ)
'!           berechnet. Compiler und Linker sind mit folgenden
'!           Parametern aufzurufen:
'!
'!           BC DEMO.BAS
'!           LINK DEMO.OBJ,CRCA.OBJ
'!
'!********************************************************

DIM buff%(255)                   '! Integer Puffer

crcres% = 0                      '! clear CRC-Register
'!
'! setze Zeichen in Puffer, beachte aber, da es kein Byte
'! Datum gibt, d.h. zwei Bytes sind in einer Integer Variablen
'! zu speichern !!!
'!
buff%(0) = &H8855                '! setze Zeichen in
buff%(1) = &HCC                  '! INTEGER Puffer
'!
'! Setze Zeichen alternativ in den Stingpuffer
'!
buff$ = CHR$(&H55)+CHR$(&H88)+CHR$(&HCC) '! Testcode setzen

PRINT "CRC-Demo Programm in Basic (c) Born G."
PRINT
PRINT "CRC-Berechnung per Polynomdivision"
PRINT
'!
'! Berechne CRC aus Integer Puffer
'!
CALL CRC (SEG crcres%, SEG buff%(0), BYVAL 3) '! Aufruf CRC Routine 1

PRINT "Die CRC - Summe ist : ";HEX$(crcres%) '! Hexzahl ausgeben

'!
'! Berechne CRC aus String Puffer
'!
crcres% = 0                      '! clear CRC-Register
FOR i% = 1 TO LEN(buff$)         '! separiere Zeichen
 tmp% = ASC(MID$(buff$,i%,1))    '! in Integer wandeln
 CALL CRC (SEG crcres%, SEG tmp%, BYVAL 1) '! CRC Routine 1
NEXT i%

PRINT
 '! Hexzahl ausgeben
PRINT "Die CRC - Summe ist : ";HEX$(crcres%)
END
'!**** Ende *****

