{*************************************************
  File       : DEMO.PAS
  Vers.      : 1.1
  Autor      : G. Born
  Files      : ---
  Progr. Spr.: Turbo Pascal 4.0 (und hher)
  Betr. Sys. : DOS ab 2.1
  Funktion: Das Programm dient zur Demonstration
  des Aufrufes von Assemblerprogrammen aus Turbo
  Pascal. Es wird das Programm CRC.OBJ einge-
  bunden. Die zu bertragenden Zeichen stehen als
  Bytes im Feld buff[].
*************************************************}

TYPE Buffer = Array [1 .. 255] OF Byte;

VAR crc_res : Word;                { CRC Register }
    buff : Buffer;                 { Datenpuffer  }

{*************       Hilfroutinen **************}

{*
    Hier wird die OBJ-Datei eingebunden
    und die Prozedur definiert
*}
{$L CRC.OBJ}                      { OBJ. File    }
{$F+}                             { FAR Modell ! }
procedure CRC (var crc_res : word; var buff : Buffer; len : integer);
external;
{$F-}

procedure Write_hex (value, len : integer);
 {
   Ausgabe eines Wertes als Zahl auf dem Bildschirm.
   Durch Len wird festgelegt, ob ein Byte (Len = 1)
   oder Wort (Len = 2) ausgegeben werden soll.
  }
 const Hexzif : array [0..15] of char = '0123456789ABCDEF';
       Byte_len = 1;
       Word_len = 2;

 TYPE zahl = 1..2;
 VAR temp : integer;
    carry : zahl;
     i    : zahl;
 begin
  if len = Word_len then
   begin
    temp := swap (value) and $0FF;      { high byte holen     }
    write (Hexzif[temp div 16]:1,Hexzif[temp mod 16]:1);
   end;
  temp := value and $0FF;               { low byte holen      }
  write (Hexzif[temp div 16]:1,Hexzif[temp mod 16]:1);
end;  { Write_hex }

{**** Hauptprogramm ****}

begin

 crc_res := 0;                          { clear CRC - Register }
 buff[1] := $55;                        { Testcode setzen      }
 buff[2] := $88;
 buff[3] := $CC;

 writeln ('CRC - Demo (c) Born G.');
 writeln;
 writeln ('CRC-Berechnung per Polynomdivision');
 writeln;

 CRC (crc_res, buff, 3);                { Aufruf CRC Routine 1 }
 write ('Die CRC - Summe ist : ');
 write_hex (crc_res,2);                 { Hexzahl ausgeben     }
 writeln;
end.                                    { Ende                 }

