;===========================================
; File : HEXASC.ASM  (c) G. Born
; Version: 1.0  (MASM 6.0)
; Convert ASCII-> HEX
; CALL: ES:DI -> Adresse 1.Ziffer (XX)
;       CX       Lnge Parameterstring
; Ret.: CY : 0  o.k.
;       AL      Ergebnis
;       ES:DI -> Adresse nchstes Zeichen
;       CY : 1  Fehler
;===========================================
;
       .MODEL SMALL
       .RADIX 16           ; Hexadezimalsystem
       PUBLIC HexAsc       ; Label global

Blank  EQU 20             ; Leerzeichen
Null   EQU 30

       .CODE
;
HexAsc: MOV AL,ES:[DI]    ; lese ASCII-Ziffer
        CMP AL,'a'        ; Ziffer a - f ?
        JB L1             ; keine Kleinbuchstaben
        SUB AL,Blank      ; in Grobuchstaben
L1:     CMP AL,Null       ; Ziffer 0 - F ?
        JB Error1         ; keine Ziffer -> Error
        CMP AL,'F'        ; Ziffer 0 - F ?
        JA Error1         ; keine Ziffer -> Error
        SUB AL,Null       ; in Hexzahl wandeln
        CMP AL,9          ; Ziffer > 9 ?
        JBE Ok            ; JMP OK
        SUB AL,07         ; korrigiere Ziffern A..F
        JO  Error1        ; keine Ziffer -> Error
Ok:     CLC               ; Clear Carry
        RET               ; Exit
; -> setze Carry
Error1: STC               ; Error-Flag
        RET               ; Exit
;
        END HexAsc
