;===========================================
; File : MODULE.ASM  (c) G. Born
; Version: 1.0 (MASM 6.0)
; File mit den Modulen zur Ausgabe und Be-
; arbeitung der Zeichen.
;===========================================
;
       .MODEL SMALL
       .RADIX 16           ; Hexadezimalsystem
       EXTRN HexAsc:NEAR   ; Externes Modul

       .CODE
;
;===========================================
; SKIP Separator (Blank, Komma)
;
; Aufgabe: Suche die Separatoren Blank oder
;          Komma und berlese sie.
;
; CALL: ES:DI -> Adresse ParameterString
;       CX       Lnge Parameterstring
; Ret.: CY : 0  o.k.
;       ES:DI -> Adresse 1. Zchn. Parameter
;       CY : 1  Ende Parameterliste erreicht
;===========================================
;
       PUBLIC Skip
;
Skip   PROC NEAR
Loops:CMP CX,0000     ; Ende Parameterliste ?
      JNZ Test1       ; Nein -> JMP Test
      STC             ; markiere Ende mit Carry
      JMP SHORT Exit2 ; JMP Exit2
Test1:CMP BYTE PTR ES:[DI],' ' ; Zchn. = Blank ?
      JZ  Skip1       ; Ja -> Skip
      CMP BYTE PTR ES:[DI],',' ; Zchn. = "," ?
      JNZ Exit1       ; Nein -> Exit1
Skip1:DEC CX          ; Count - 1
      INC DI          ; Ptr to next Char.
      JMP NEAR PTR Loops  ; JMP Loop
Exit1:CLC             ; Clear Carry
Exit2:RET
Skip  ENDP
;
;-------------------------------------------
; Display String
;
; Aufgabe: Gebe einen String innerhalb der
;          Parameterliste aus.
;
; CALL: ES:DI -> Adresse "......" String
;       CX       Lnge Parameterstring
; Ret.: CY : 0  o.k.
;       ES:DI -> Adresse nach String 
;       CY : 1  Ende Parameterliste erreicht
;-------------------------------------------
;
       PUBLIC String
;
String PROC NEAR

Begin: CMP BYTE PTR ES:[DI],22 ; " gefunden ?
       JNZ Exit3       ; kein String -> EXIT
       INC DI          ; auf nchstes Zeichen
       DEC CX          ; Count - 1
Loop1: CMP CX,0000     ; Ende Parameterliste ?
       JNZ Test2       ; Nein -> JMP Test
       STC             ; markiere Ende mit Carry
       RET             ; Exit
Test2: CMP BYTE PTR ES:[DI],22 ; " -> Stringende ?
       JZ  Ende        ; Ja -> JMP Ende
Write: MOV DL,ES:[DI]  ; lese Zeichen
       MOV AH,02       ; DOS-Code
       INT 21          ; ausgeben
       DEC CX          ; Count - 1
       INC DI          ; Ptr to next Char.
       JMP NEAR PTR Loop1  ; JMP Loop
Ende:  INC DI          ; auf Stringende
       DEC CX          ; Count - 1
Exit3: CLC             ; ok-> clear Carry
       RET
String ENDP
;
;-------------------------------------------
; Display Number
;
; Aufgabe: Gebe eine HEX-Zahl innerhalb der
;          Parameterliste aus.
;
; CALL: ES:DI -> Adresse 1.Ziffer (XX)
;       CX       Lnge Parameterstring
; Ret.: CY : 0  o.k.
;       ES:DI -> Adresse nach Zahl 
;       CY : 1  Ende Parameterliste erreicht
;-------------------------------------------
;
       PUBLIC Number
;
Number  PROC NEAR

        CALL NEAR PTR HexAsc ; 1. Ziffer konvertieren
        JC Error         ; keine Ziffer -> Error
        MOV DL,AL        ; merke Ergebnis
; 2. Ziffer lesen
        INC DI            ; nchstes Zeichen
        DEC CX            ; Zhler - 1
        CMP CX,0000       ; Pufferende ?
        JZ Display        ; JMP Display
        CALL NEAR PTR HexAsc  ; 2. Ziffer konvertieren
        JC Display        ; keine Ziffer -> JMP Display
;
; schiebe 1. Ziffer in High Nibble
;
        PUSH CX           ; schiebe 1. Ziffer
        MOV CL,04         ; in High Nibble
        SHL DL,CL
        POP CX
        OR  DL,AL         ; Low Nibble einblenden
Display:MOV AH,02         ; DOS-Code
        INT 21            ; Code in DL ausgeben
        AND CX,CX         ; Ende Parameterliste?
        STC               ; setze Carry zur Vorsicht
        JZ Exit4          ; Ende ereicht -> Exit
        INC DI            ; auf nchstes Zeichen
        DEC CX            ; Count - 1
        CLC               ; Clear Carry
Exit4:  RET
;-------------------------------------------
; Ausgabe des Fehlertextes und Exit zu DOS
;-------------------------------------------
Error: MOV AX,SEG Txt    ; DS: auf Text
       MOV DS,AX
       MOV AH,09         ; DOS-Code
       MOV DX,OFFSET Txt ; Adr. String
       INT 21            ; Ausgabe
       MOV AX,4C01       ; DOS-Code
       INT 21            ; Exit
;
;===========================================
; Fehlertext
;===========================================
Txt BYTE "Fehler in der Parameterliste",0D,0A,"$"
;
Number ENDP
       END

