;===================================
; File: ASK.ASM   (c) Born G.
; Version: V 1.0 TASM
; Funktion: Programm zur Benutzerab-
; frage in Batchdateien. Aufruf:
;
;     ASK <Text>
;
; Der Text wird auf dem Screen ausge-
; gegeben. Der Tastencode wird an DOS
; zurckgegeben. (Bei Funktionstasten
; wird FF zurckgegeben). Er lt sich
; per ERRORLEVEL abfragen. Das Programm
; ist als COM-Datei zu bersetzen!!
;===================================
;
       .MODEL SMALL
       .RADIX 16            ; Hexadezimalsystem
       
       Blank EQU 20        ; Blank
       Err1  EQU 0FF       ; Error

       .STACK              ; 1 K Stack

       .DATA
;
; Bereich mit den Textkonstanten
;
Crlf  DB 0D, 0A,"$"
;

       .CODE
;
ASK:   CALL NEAR PTR Text  ; Textausgabe falls vorhanden
       CALL NEAR PTR Key   ; Abfrage der Tastatur
       PUSH AX             ; merke Tastencode
;
; CR,LF ausgeben
;
       MOV AX,SEG Crlf     ; lese Segment Text
       PUSH DS             ; merke DS-Inhalt
       MOV DS,AX           ; setze Segmentadr.
       MOV AH,09           ; INT 21-Stingausgabe
       MOV DX,OFFSET Crlf  ; Stringadresse
       INT 21              ; ausgeben
       POP DS              ; restauriere DS
       POP AX              ; restauriere Tastencode
;
; DOS-Exit, Returncode steht bereits in AL
;
       MOV AH,4C           ; INT 21-Exitcode
       INT 21              ; terminiere
;

Text   PROC NEAR
;--------------------------------
; Unterprogramm zur Ausgabe des
; Textes aus der Kommandozeile
;--------------------------------
; ermittle Lage des PSP ber undok.
; Funktion 51 des INT 21
;
       MOV AH,51           ; DOS-Code
       INT 21              ; Get PSP
       MOV ES,BX           ; ES:= PSP-Adr
;
; prfe ob Text im PSP vorhanden ist
;
       MOV CL,ES:[80]      ; lese Pufferlnge
       CMP CL,0            ; Text vorhanden ?
       JZ  Ready           ; Nein -> Exit
;
; Text ist vorhanden, ausgeben per INT 21, AH = 02
;
       MOV BX,0082         ; Zeiger auf 2. Zeichen
       DEC CL              ; 1 Zeichen weniger
Loop1:           ; Beginn der Ausgabeschleife !!!!
       MOV AH,02           ; INT 21-Code Display Char.
       MOV DL,ES:[BX]      ; Zeichen in DL laden
       INT 21              ; CALL DOS-Zeichenausgabe 
       INC BX              ; Zeiger auf nchstes Zchn
       DEC CL              ; Zeichenzahl - 1
       JNZ Loop1           ; Textende ? Nein-> Loop
;
       MOV AH,02           ; INT 21-Code Display
       MOV DL,Blank        ; Blank anhngen
       INT 21              ; und ausgeben
Ready: RET                 ; Ende Unterprogramm
Text   ENDP

;
Key    PROC NEAR
;--------------------------------
; Unterprogramm zur Tastaturabfrage
; benutze INT 21, AH = 08 Read Keyboard
; oder:           AH = 01 Read Keyboard & Echo
;--------------------------------
; lese 1. Zeichen
       MOV AH,01           ; INT 21-Read Key & Echo
       INT 21              ; Read Code
       CMP AL,0            ; Extended ASCII-Code ?
       JNZ Exit            ; Nein -> Ready
;
; lese 2. Zeichen beim Extended ASCII-Code
;
       MOV AH,08           ; INT 21 Read Keyboard
       INT 21              ; Code aus Puffer lesen
       MOV AL,Err1         ; Fehlercode setzen
Exit:  RET                 ; Ende Unterprogramm
Key    ENDP

END Ask

