;----------------------------------------------------------
; File       : CRCA.ASM
; Version    : 1.1 (MASM 6.0)
; Last Edit  : 12.9.91
; Autor      : (c) G. Born
; Funktion   :
;
;        CRC 16 Generator fr den 8086 Prozessor
;
; Es wird das Polynom y = x^16 + x^15 + x^2 + 1 verwendet
; Aufruf von Hochsprachen mit:
;
; CALL CRC (CRCr,Buff,Len)
;
; CRCr = Adresse Variable 16 Bit CRC Register
; Buff = Adresse des Zeichenpuffers
; Len  = Wert Zeichenzahl im Puffer
;
; Es sind die Adressen der zwei Parameter CRCr, Buff und
; der Wert von Len ber den Stack zu bergeben:
;
;        Stack Anordnung
;      +-------------------+
;      ! Seg:   CRCr       !
;      +-------------------+ + 0E
;      ! Ofs:   CRCr       !
;      +-------------------+ + 0C
;      ! Seg:   Buff       !
;      +-------------------+ + 0A
;      ! Ofs:   Buff       !
;      +-------------------+ + 08
;      ! Wert   Len        !
;      +-------------------+ + 06
;      ! Seg:   Return Adr.!
;      +-------------------+ + 04
;      ! Ofs:   Return Adr.!
;      +-------------------+ + 02
;      !  BP  von CRCA     !
;      +-------------------+
;
; Die Procedur ist als FAR aufzurufen. Es wird angenommen, da die
; Variablen im DS - Segment liegen. Diese Konvention entspricht der
; Parameterbergabe in Turbo Pascal und Quick Basic. Fr die eigent-
; liche CRC Berechnung gilt folgende Registerbelegung:
; 
; Register: BX = CRC Register
;           SI = Zeiger in den Datenstrom
;           CX = Zahl der Daten
;           AH = Bit Counter
;           AL = Hilfsaccu
;
; Die Theorie der CRC-Berechnung ist dem Artikel:
;
; G. Born: CRC-Sicherung per Software, Der Cyclic Redundancy Check
; Toolbox Spezial, Heft 7'89, DMV-Verlag Eschwege.
;
; zu entnehmen.
;----------------------------------------------------------
;
        .RADIX    16
        .MODEL    LARGE

POLY     EQU       0010000000000001B ; Polynom

        .CODE

        PUBLIC    CRC 
CRC     PROC      FAR

CRCX:   PUSH      BP            ; save old frame
        MOV       BP,SP         ; set new frame
        PUSH      DS            ; save DS
        MOV       CX,[BP]+06    ; get (Len)
        MOV       SI,[BP]+08    ; get Adr (Buff)
        MOV       DS,[BP]+0A    ; get Seg (Buff)
        MOV       BX,[BP]+0C    ; get Adr (CRC)
        MOV       DI,BX         ; merke Adr
        MOV       BX,DS:[BX]    ; load CRC value
;
        CLD                     ; Autoincrement
;
LESE:   MOV       AH,08         ; 8 Bit pro Zeichen
        LODSB                   ; Zeichen lesen & SI + 1
        MOV       DL, AL        ; merke Zeichen
;
; CRC Generator
;
CRC1:   XOR       AL,BL         ; BCC - LSB XOR Zchn
        RCR       AL,1          ; Ergebnis in Carry Bit
        JNC       NULL          ; Serial Quotient ?
;
; Serial Quotient = 1
;
EINS:   RCR       BX,1          ; SHIFT CRC right
        XOR       BX,POLY       ; bertrag einblenden
        JMP       TESTE         ; weitere Bits
;
; Serial Quotient = 0
;
NULL:   RCR       BX,1          ; Shift CRC right
;
TESTE:  MOV       AL,DL         ; Lese Zeichen
        RCR       AL,1          ; Shift Zeichen 1 Bit right
        MOV       DL,AL         ; merke Restzeichen
        DEC       AH            ; 8 Bit fertig ?
        JNZ       CRC1          ; Zeichen weiter bearbeiten ?
        LOOP      LESE          ; String bearbeitet?
;
; Ende -> Das CRC Ergebnis steht im Register BX
;      -> schreibe in Ergebnisvariable zurck
;
        MOV       DS:[DI],BX    ; restore CRC result

        POP       DS            ; restore Segmentreg.
        POP       BP            ; restore old frame
        RETF      0A            ; Return + POP 10 Bytes

CRC     ENDP
        END

